/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty.binders;

import io.micronaut.core.bind.ArgumentBinder;
import io.micronaut.core.bind.annotation.Bindable;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionError;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.type.Argument;
import io.micronaut.http.annotation.Part;
import io.micronaut.http.bind.binders.AnnotatedRequestArgumentBinder;
import io.micronaut.http.bind.binders.PendingRequestBindingResult;
import io.micronaut.http.netty.stream.StreamedHttpRequest;
import io.micronaut.http.server.netty.NettyHttpRequest;
import io.micronaut.http.server.netty.binders.CompletedFileUploadBinder;
import io.micronaut.http.server.netty.binders.PublisherPartUploadBinder;
import io.micronaut.http.server.netty.binders.StreamedNettyRequestArgumentBinder;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import reactor.core.publisher.Mono;

public class PartUploadAnnotationBinder<T>
implements AnnotatedRequestArgumentBinder<Part, T>,
StreamedNettyRequestArgumentBinder<T> {
    private final ConversionService conversionService;
    private final CompletedFileUploadBinder completedFileUploadBinder;
    private final PublisherPartUploadBinder publisherPartUploadBinder;

    public PartUploadAnnotationBinder(ConversionService conversionService, CompletedFileUploadBinder completedFileUploadBinder, PublisherPartUploadBinder publisherPartUploadBinder) {
        this.conversionService = conversionService;
        this.completedFileUploadBinder = completedFileUploadBinder;
        this.publisherPartUploadBinder = publisherPartUploadBinder;
    }

    @Override
    public ArgumentBinder.BindingResult<T> bindForStreamedNettyRequest(final ArgumentConversionContext<T> context, StreamedHttpRequest streamedHttpRequest, NettyHttpRequest<?> request) {
        if (request.getContentType().isEmpty() || !request.isFormOrMultipartData()) {
            return ArgumentBinder.BindingResult.unsatisfied();
        }
        if (this.completedFileUploadBinder.matches(context.getArgument().getType())) {
            return this.completedFileUploadBinder.bind(context, request);
        }
        if (this.publisherPartUploadBinder.matches(context.getArgument().getType())) {
            return this.publisherPartUploadBinder.bind(context, request);
        }
        Argument<T> argument = context.getArgument();
        String inputName = argument.getAnnotationMetadata().stringValue(Bindable.NAME).orElse(argument.getName());
        final CompletableFuture<Object> completableFuture = Mono.from(request.formRouteCompleter().claimFieldsComplete(inputName)).map(d -> this.conversionService.convert(d, argument.getType(), context).orElse(null)).toFuture();
        return new PendingRequestBindingResult<T>(){

            @Override
            public boolean isPending() {
                return !completableFuture.isDone();
            }

            @Override
            public List<ConversionError> getConversionErrors() {
                return context.getLastError().map(List::of).orElseGet(List::of);
            }

            @Override
            public Optional<T> getValue() {
                return Optional.ofNullable(completableFuture.getNow(null));
            }
        };
    }

    @Override
    public Class<Part> getAnnotationType() {
        return Part.class;
    }
}

