/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty.binders;

import io.micronaut.core.bind.ArgumentBinder;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionError;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.exceptions.ConversionErrorException;
import io.micronaut.core.type.Argument;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.bind.binders.NonBlockingBodyArgumentBinder;
import io.micronaut.http.server.netty.HttpContentProcessorResolver;
import io.micronaut.http.server.netty.NettyHttpRequest;
import io.micronaut.http.server.netty.NettyHttpServer;
import io.micronaut.http.server.netty.body.ByteBody;
import io.micronaut.http.server.netty.body.ImmediateByteBody;
import io.micronaut.web.router.exceptions.UnsatisfiedRouteException;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufHolder;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.ReferenceCounted;
import jakarta.inject.Singleton;
import java.util.Optional;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

@Singleton
public class PublisherBodyBinder
implements NonBlockingBodyArgumentBinder<Publisher<?>> {
    public static final String MSG_CONVERT_DEBUG = "Cannot convert message for argument [{}] and value: {}";
    private static final Logger LOG = LoggerFactory.getLogger(NettyHttpServer.class);
    private static final Argument<Publisher<?>> TYPE = Argument.of(Publisher.class);
    private final HttpContentProcessorResolver httpContentProcessorResolver;
    private final ConversionService conversionService;

    public PublisherBodyBinder(ConversionService conversionService, HttpContentProcessorResolver httpContentProcessorResolver) {
        this.httpContentProcessorResolver = httpContentProcessorResolver;
        this.conversionService = conversionService;
    }

    @Override
    public Argument<Publisher<?>> argumentType() {
        return TYPE;
    }

    @Override
    public ArgumentBinder.BindingResult<Publisher<?>> bind(ArgumentConversionContext<Publisher<?>> context, HttpRequest<?> source) {
        if (source instanceof NettyHttpRequest) {
            ImmediateByteBody imm;
            NettyHttpRequest nhr = (NettyHttpRequest)source;
            ByteBody byteBody = nhr.rootBody();
            if (byteBody instanceof ImmediateByteBody && (imm = (ImmediateByteBody)byteBody).empty()) {
                return ArgumentBinder.BindingResult.empty();
            }
            Argument<Object> targetType = context.getFirstTypeVariable().orElse(Argument.OBJECT_ARGUMENT);
            try {
                Publisher<?> publisher = nhr.rootBody().processMulti(this.httpContentProcessorResolver.resolve(nhr, targetType).resultType(context.getArgument())).mapNotNull(o -> {
                    ArgumentConversionContext conversionContext = context.with(targetType);
                    return PublisherBodyBinder.convertAndRelease(this.conversionService, conversionContext, o);
                }).asPublisher();
                return () -> Optional.of(publisher);
            }
            catch (Throwable t) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Server received error for argument [" + context.getArgument() + "]: " + t.getMessage(), t);
                }
                return () -> Optional.of(Mono.error(t));
            }
        }
        return ArgumentBinder.BindingResult.empty();
    }

    private static RuntimeException extractError(Object message, ArgumentConversionContext<?> conversionContext) {
        Optional<ConversionError> lastError = conversionContext.getLastError();
        if (lastError.isPresent()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(MSG_CONVERT_DEBUG, (Object)conversionContext.getArgument(), (Object)lastError.get());
            }
            return new ConversionErrorException(conversionContext.getArgument(), lastError.get());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(MSG_CONVERT_DEBUG, (Object)conversionContext.getArgument(), message);
        }
        return UnsatisfiedRouteException.create(conversionContext.getArgument());
    }

    static Object convertAndRelease(ConversionService conversionService, ArgumentConversionContext<?> conversionContext, Object o) {
        try {
            ByteBufHolder holder;
            if (o instanceof ByteBufHolder && !((ByteBuf)(o = (holder = (ByteBufHolder)o).content())).isReadable()) {
                Object var4_4 = null;
                return var4_4;
            }
            Optional<?> converted = conversionService.convert(o, conversionContext);
            if (converted.isPresent()) {
                Object conv = converted.get();
                if (conv instanceof io.micronaut.core.io.buffer.ReferenceCounted) {
                    io.micronaut.core.io.buffer.ReferenceCounted rc = (io.micronaut.core.io.buffer.ReferenceCounted)conv;
                    rc.retain();
                } else if (conv instanceof ReferenceCounted) {
                    ReferenceCounted rc = (ReferenceCounted)conv;
                    rc.retain();
                }
                Object obj = conv;
                return obj;
            }
            throw PublisherBodyBinder.extractError(o, conversionContext);
        }
        finally {
            ReferenceCountUtil.release(o);
        }
    }
}

