/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty.binders;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.bind.ArgumentBinder;
import io.micronaut.core.bind.annotation.Bindable;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.reflect.ClassUtils;
import io.micronaut.core.type.Argument;
import io.micronaut.http.MediaType;
import io.micronaut.http.bind.binders.TypedRequestArgumentBinder;
import io.micronaut.http.multipart.PartData;
import io.micronaut.http.multipart.StreamingFileUpload;
import io.micronaut.http.server.netty.MicronautHttpData;
import io.micronaut.http.server.netty.NettyHttpRequest;
import io.micronaut.http.server.netty.binders.NettyRequestArgumentBinder;
import io.micronaut.http.server.netty.multipart.NettyPartData;
import io.micronaut.http.server.netty.multipart.NettyStreamingFileUpload;
import io.netty.handler.codec.http.multipart.FileUpload;
import java.util.Optional;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;

@Internal
final class PublisherPartUploadBinder
implements TypedRequestArgumentBinder<Publisher<?>>,
NettyRequestArgumentBinder<Publisher<?>> {
    private static final Argument<Publisher<?>> PUBLISHER_ARGUMENT = Argument.of(Publisher.class);
    private static final Argument<PartData> PART_DATA_ARGUMENT = Argument.of(PartData.class);
    private final ConversionService conversionService;
    private final NettyStreamingFileUpload.Factory fileUploadFactory;

    public PublisherPartUploadBinder(ConversionService conversionService, NettyStreamingFileUpload.Factory fileUploadFactory) {
        this.conversionService = conversionService;
        this.fileUploadFactory = fileUploadFactory;
    }

    @Override
    public ArgumentBinder.BindingResult<Publisher<?>> bindForNettyRequest(ArgumentConversionContext<Publisher<?>> context, NettyHttpRequest<?> request) {
        Flux<Object> publisher;
        if (request.getContentType().isEmpty() || !request.isFormOrMultipartData()) {
            return ArgumentBinder.BindingResult.unsatisfied();
        }
        Argument<Publisher<?>> argument = context.getArgument();
        String inputName = argument.getAnnotationMetadata().stringValue(Bindable.NAME).orElse(argument.getName());
        Argument<Object> contentArgument = argument.getFirstTypeVariable().orElse(Argument.OBJECT_ARGUMENT);
        Class contentTypeClass = contentArgument.getType();
        if (contentTypeClass == StreamingFileUpload.class) {
            publisher = request.formRouteCompleter().claimFields(inputName, (data, flux) -> this.fileUploadFactory.create((FileUpload)((Object)data), (Flux<PartData>)flux));
        } else if (contentTypeClass == Publisher.class) {
            Argument<Object> nestedType = contentArgument.getFirstTypeVariable().orElse(Argument.OBJECT_ARGUMENT);
            publisher = request.formRouteCompleter().claimFields(inputName, (data, flux) -> flux.mapNotNull(partData -> this.conversionService.convert(partData, nestedType).orElse(null)));
        } else {
            Flux<MicronautHttpData<?>> raw = request.formRouteCompleter().claimFieldsRaw(inputName);
            Flux<Object> mnTypeIfNecessary = contentTypeClass == PartData.class || ClassUtils.isJavaLangType(contentTypeClass) ? raw.mapNotNull(data -> {
                MicronautHttpData.Chunk chunk = data.pollChunk();
                if (chunk != null) {
                    return new NettyPartData(() -> {
                        if (data instanceof FileUpload) {
                            FileUpload fileUpload = (FileUpload)((Object)data);
                            return Optional.of(MediaType.of(fileUpload.getContentType()));
                        }
                        return Optional.empty();
                    }, chunk::claim);
                }
                return null;
            }) : raw;
            publisher = mnTypeIfNecessary.mapNotNull(it -> this.conversionService.convert(it, contentArgument).orElse(null));
        }
        return () -> Optional.of(publisher);
    }

    @Override
    public Argument<Publisher<?>> argumentType() {
        return PUBLISHER_ARGUMENT;
    }
}

