/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty.body;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.execution.ExecutionFlow;
import io.micronaut.http.netty.stream.StreamedHttpRequest;
import io.micronaut.http.server.netty.HttpContentProcessor;
import io.micronaut.http.server.netty.body.HttpBody;
import io.micronaut.http.server.netty.body.ImmediateByteBody;
import io.micronaut.http.server.netty.body.MultiObjectBody;
import io.micronaut.http.server.netty.body.StreamingByteBody;
import io.netty.buffer.ByteBufAllocator;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpRequest;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Internal
public interface ByteBody
extends HttpBody {
    public MultiObjectBody processMulti(HttpContentProcessor var1) throws Throwable;

    public ExecutionFlow<ImmediateByteBody> buffer(ByteBufAllocator var1);

    public static ByteBody of(HttpRequest request) {
        if (request instanceof FullHttpRequest) {
            FullHttpRequest full = (FullHttpRequest)request;
            return new ImmediateByteBody(full.content());
        }
        return new StreamingByteBody((StreamedHttpRequest)request);
    }
}

