/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty.body;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.execution.ExecutionFlow;
import io.micronaut.http.server.netty.HttpContentProcessor;
import io.micronaut.http.server.netty.body.ByteBody;
import io.micronaut.http.server.netty.body.ImmediateMultiObjectBody;
import io.micronaut.http.server.netty.body.ImmediateSingleObjectBody;
import io.micronaut.http.server.netty.body.ManagedBody;
import io.micronaut.http.server.netty.body.MultiObjectBody;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.handler.codec.http.DefaultHttpContent;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

@Internal
public final class ImmediateByteBody
extends ManagedBody<ByteBuf>
implements ByteBody {
    private final boolean empty;

    ImmediateByteBody(ByteBuf buf) {
        super(buf);
        this.empty = !buf.isReadable();
    }

    @Override
    void release(ByteBuf value) {
        value.release();
    }

    @Override
    public MultiObjectBody processMulti(HttpContentProcessor processor) throws Throwable {
        ByteBuf data = (ByteBuf)this.prepareClaim();
        Object item = processor.processSingle(data);
        if (item != null) {
            return this.next(new ImmediateSingleObjectBody(item));
        }
        return this.next(this.processMultiImpl(processor, data));
    }

    @NotNull
    private ImmediateMultiObjectBody processMultiImpl(HttpContentProcessor processor, ByteBuf data) throws Throwable {
        ArrayList<Object> out = new ArrayList<Object>(1);
        if (data.isReadable()) {
            processor.add(new DefaultHttpContent(data), out);
        } else {
            data.release();
        }
        processor.complete(out);
        return new ImmediateMultiObjectBody((List<?>)out);
    }

    public ImmediateSingleObjectBody processSingle(HttpContentProcessor processor, Charset defaultCharset, ByteBufAllocator alloc) throws Throwable {
        return this.next(this.processMultiImpl(processor, (ByteBuf)this.prepareClaim()).single(defaultCharset, alloc));
    }

    @Override
    public ExecutionFlow<ImmediateByteBody> buffer(ByteBufAllocator alloc) {
        return ExecutionFlow.just(this);
    }

    public boolean empty() {
        return this.empty;
    }
}

