/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty.body;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.execution.DelayedExecutionFlow;
import io.micronaut.core.execution.ExecutionFlow;
import io.micronaut.http.server.netty.HttpContentProcessor;
import io.micronaut.http.server.netty.HttpContentProcessorAsReactiveProcessor;
import io.micronaut.http.server.netty.body.ByteBody;
import io.micronaut.http.server.netty.body.HttpBody;
import io.micronaut.http.server.netty.body.ImmediateByteBody;
import io.micronaut.http.server.netty.body.ManagedBody;
import io.micronaut.http.server.netty.body.MultiObjectBody;
import io.micronaut.http.server.netty.body.StreamingMultiObjectBody;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.CompositeByteBuf;
import io.netty.handler.codec.http.HttpContent;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

@Internal
public final class StreamingByteBody
extends ManagedBody<Publisher<HttpContent>>
implements ByteBody {
    StreamingByteBody(Publisher<HttpContent> publisher) {
        super(publisher);
    }

    @Override
    public MultiObjectBody processMulti(HttpContentProcessor processor) {
        return this.next(new StreamingMultiObjectBody(HttpContentProcessorAsReactiveProcessor.asPublisher(processor, (Publisher)this.prepareClaim())));
    }

    @Override
    public ExecutionFlow<ImmediateByteBody> buffer(ByteBufAllocator alloc) {
        IntermediateBuffering intermediateBuffering = new IntermediateBuffering(alloc);
        ((Publisher)this.prepareClaim()).subscribe(intermediateBuffering);
        this.next(intermediateBuffering);
        return intermediateBuffering.completion;
    }

    @Override
    void release(Publisher<HttpContent> value) {
    }

    private static final class IntermediateBuffering
    implements Subscriber<HttpContent>,
    HttpBody {
        private final DelayedExecutionFlow<ImmediateByteBody> completion = DelayedExecutionFlow.create();
        private final Lock lock = new ReentrantLock();
        private final ByteBufAllocator alloc;
        private Subscription subscription;
        private boolean discarded = false;
        private CompositeByteBuf composite;
        private ByteBuf single;
        private ImmediateByteBody next;

        private IntermediateBuffering(ByteBufAllocator alloc) {
            this.alloc = alloc;
        }

        @Override
        public void onSubscribe(Subscription s) {
            s.request(Long.MAX_VALUE);
            this.subscription = s;
        }

        @Override
        public void onNext(HttpContent httpContent) {
            this.lock.lock();
            try {
                if (this.discarded) {
                    httpContent.release();
                    return;
                }
                if (this.composite != null) {
                    this.composite.addComponent(true, httpContent.content());
                } else if (this.single == null) {
                    this.single = httpContent.content();
                } else {
                    this.composite = this.alloc.compositeBuffer();
                    this.composite.addComponent(true, this.single);
                    this.composite.addComponent(true, httpContent.content());
                    this.single = null;
                }
            }
            finally {
                this.lock.unlock();
            }
        }

        @Override
        public void onError(Throwable t) {
            this.discard();
            try {
                this.completion.completeExceptionally(t);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }

        @Override
        public void onComplete() {
            this.lock.lock();
            try {
                this.discarded = true;
                this.next = new ImmediateByteBody(this.composite == null ? this.single : this.composite);
                this.single = null;
                this.composite = null;
            }
            finally {
                this.lock.unlock();
            }
            this.completion.complete(this.next);
        }

        private void discard() {
            this.lock.lock();
            try {
                this.discarded = true;
                if (this.composite != null) {
                    this.composite.release();
                    this.composite = null;
                }
                if (this.single != null) {
                    this.single.release();
                    this.single = null;
                }
            }
            finally {
                this.lock.unlock();
            }
            if (this.next != null) {
                this.next.release();
            }
            if (this.subscription != null) {
                this.subscription.cancel();
            }
        }

        @Override
        public void release() {
            this.discard();
        }

        @Override
        @Nullable
        public HttpBody next() {
            return this.next;
        }
    }
}

