/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty.decoders;

import io.micronaut.context.event.ApplicationEventPublisher;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.order.Ordered;
import io.micronaut.http.context.event.HttpRequestReceivedEvent;
import io.micronaut.http.netty.stream.StreamedHttpRequest;
import io.micronaut.http.server.HttpServerConfiguration;
import io.micronaut.http.server.netty.NettyHttpRequest;
import io.micronaut.http.server.netty.NettyHttpServer;
import io.micronaut.runtime.server.EmbeddedServer;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageDecoder;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.util.ReferenceCountUtil;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
@Internal
public class HttpRequestDecoder
extends MessageToMessageDecoder<HttpRequest>
implements Ordered {
    public static final String ID = "micronaut-http-decoder";
    private static final Logger LOG = LoggerFactory.getLogger(NettyHttpServer.class);
    private final EmbeddedServer embeddedServer;
    private final ConversionService conversionService;
    private final HttpServerConfiguration configuration;
    private final ApplicationEventPublisher<HttpRequestReceivedEvent> httpRequestReceivedEventPublisher;

    public HttpRequestDecoder(EmbeddedServer embeddedServer, ConversionService conversionService, HttpServerConfiguration configuration, ApplicationEventPublisher<HttpRequestReceivedEvent> httpRequestReceivedEventPublisher) {
        this.embeddedServer = embeddedServer;
        this.conversionService = conversionService;
        this.configuration = configuration;
        this.httpRequestReceivedEventPublisher = httpRequestReceivedEventPublisher;
    }

    @Override
    protected void decode(ChannelHandlerContext ctx, HttpRequest msg, List<Object> out) {
        block7: {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Server {}:{} Received Request: {} {}", this.embeddedServer.getHost(), this.embeddedServer.getPort(), msg.method(), msg.uri());
            }
            try {
                NettyHttpRequest request;
                block6: {
                    request = new NettyHttpRequest(msg, ctx, this.conversionService, this.configuration);
                    if (!this.httpRequestReceivedEventPublisher.isEmpty()) {
                        try {
                            ctx.executor().execute(() -> {
                                block2: {
                                    try {
                                        this.httpRequestReceivedEventPublisher.publishEvent(new HttpRequestReceivedEvent(request));
                                    }
                                    catch (Exception e) {
                                        if (!LOG.isErrorEnabled()) break block2;
                                        LOG.error("Error publishing Http request received event: " + e.getMessage(), e);
                                    }
                                }
                            });
                        }
                        catch (Exception e) {
                            if (!LOG.isErrorEnabled()) break block6;
                            LOG.error("Error publishing Http request received event: " + e.getMessage(), e);
                        }
                    }
                }
                out.add(request);
                ReferenceCountUtil.retain(msg);
            }
            catch (IllegalArgumentException e) {
                new NettyHttpRequest(new DefaultFullHttpRequest(msg.protocolVersion(), msg.method(), "/", Unpooled.EMPTY_BUFFER), ctx, this.conversionService, this.configuration);
                Throwable cause = e.getCause();
                ctx.fireExceptionCaught(cause != null ? cause : e);
                if (!(msg instanceof StreamedHttpRequest)) break block7;
                StreamedHttpRequest streamedHttpRequest = (StreamedHttpRequest)msg;
                streamedHttpRequest.closeIfNoSubscriber();
            }
        }
    }
}

