/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty.jackson;

import com.fasterxml.jackson.annotation.JsonView;
import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.async.publisher.Publishers;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.http.HttpAttributes;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.annotation.Filter;
import io.micronaut.http.filter.HttpServerFilter;
import io.micronaut.http.filter.ServerFilterChain;
import io.micronaut.http.filter.ServerFilterPhase;
import io.micronaut.http.server.netty.jackson.JsonViewCodecResolver;
import io.micronaut.json.JsonConfiguration;
import io.micronaut.json.codec.JsonMediaTypeCodec;
import io.micronaut.web.router.RouteInfo;
import jakarta.inject.Named;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

@Requirements(value={@Requires(beans={JsonConfiguration.class}), @Requires(classes={JsonView.class}), @Requires(property="jackson.json-view.enabled")})
@Filter(value={"/**"})
public class JsonViewServerFilter
implements HttpServerFilter {
    public static final String PROPERTY_JSON_VIEW_ENABLED = "jackson.json-view.enabled";
    private final JsonViewCodecResolver codecFactory;
    private final ExecutorService executorService;
    private final ConversionService conversionService;

    public JsonViewServerFilter(JsonViewCodecResolver jsonViewCodecResolver, @Named(value="blocking") ExecutorService executorService, ConversionService conversionService) {
        this.codecFactory = jsonViewCodecResolver;
        this.executorService = executorService;
        this.conversionService = conversionService;
    }

    @Override
    public Publisher<MutableHttpResponse<?>> doFilter(HttpRequest<?> request, ServerFilterChain chain) {
        Optional viewClass;
        RouteInfo routeInfo = request.getAttribute(HttpAttributes.ROUTE_INFO, RouteInfo.class).orElse(null);
        Publisher<MutableHttpResponse<?>> responsePublisher = chain.proceed(request);
        if (routeInfo != null && (viewClass = routeInfo.findAnnotation(JsonView.class).flatMap(AnnotationValue::classValue)).isPresent()) {
            return Flux.from(responsePublisher).switchMap(response -> {
                Optional optionalBody = response.getBody();
                if (optionalBody.isPresent()) {
                    Object body = optionalBody.get();
                    JsonMediaTypeCodec codec = this.codecFactory.resolveJsonViewCodec((Class)viewClass.get());
                    if (Publishers.isConvertibleToPublisher(body)) {
                        Publisher pub = Publishers.convertPublisher(this.conversionService, body, Publisher.class);
                        response.body(Flux.from(pub).map(o -> codec.encode(routeInfo.getBodyType(), o)).subscribeOn(Schedulers.fromExecutorService(this.executorService)));
                    } else {
                        return Mono.fromCallable(() -> {
                            byte[] encoded = codec.encode(routeInfo.getBodyType(), body);
                            response.body(encoded);
                            return response;
                        }).subscribeOn(Schedulers.fromExecutorService(this.executorService));
                    }
                }
                return Flux.just(response);
            });
        }
        return responsePublisher;
    }

    @Override
    public int getOrder() {
        return ServerFilterPhase.RENDERING.order();
    }
}

