/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty.types.files;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.util.SupplierUtil;
import io.micronaut.http.HttpMethod;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.MediaType;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.netty.NettyMutableHttpResponse;
import io.micronaut.http.server.netty.SmartHttpContentCompressor;
import io.micronaut.http.server.netty.types.NettyFileCustomizableResponseType;
import io.micronaut.http.server.types.CustomizableResponseTypeException;
import io.micronaut.http.server.types.files.FileCustomizableResponseType;
import io.micronaut.http.server.types.files.SystemFile;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.DefaultFileRegion;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.HttpChunkedInput;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.stream.ChunkedFile;
import io.netty.util.AttributeKey;
import io.netty.util.ResourceLeakDetector;
import io.netty.util.ResourceLeakDetectorFactory;
import io.netty.util.ResourceLeakTracker;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Optional;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class NettySystemFileCustomizableResponseType
extends SystemFile
implements NettyFileCustomizableResponseType {
    public static final Supplier<AttributeKey<SmartHttpContentCompressor>> ZERO_COPY_PREDICATE = SupplierUtil.memoized(() -> AttributeKey.newInstance("zero-copy-predicate"));
    private static final int LENGTH_8K = 8192;
    private static final String UNIT_BYTES = "bytes";
    private static final Logger LOG = LoggerFactory.getLogger(NettySystemFileCustomizableResponseType.class);
    protected Optional<FileCustomizableResponseType> delegate = Optional.empty();

    public NettySystemFileCustomizableResponseType(File file) {
        super(file);
        if (!file.canRead()) {
            throw new CustomizableResponseTypeException("Could not find file");
        }
    }

    public NettySystemFileCustomizableResponseType(SystemFile delegate) {
        this(delegate.getFile());
        this.delegate = Optional.of(delegate);
    }

    @Override
    public long getLastModified() {
        return this.delegate.map(FileCustomizableResponseType::getLastModified).orElse(super.getLastModified());
    }

    @Override
    public MediaType getMediaType() {
        return this.delegate.map(FileCustomizableResponseType::getMediaType).orElse(super.getMediaType());
    }

    @Override
    public void process(MutableHttpResponse response) {
        this.delegate.ifPresent(type -> type.process(response));
    }

    @Override
    public ChannelFuture write(HttpRequest<?> request, MutableHttpResponse<?> response, ChannelHandlerContext context) {
        if (response instanceof NettyMutableHttpResponse) {
            IntRange range;
            NettyMutableHttpResponse nettyResponse = (NettyMutableHttpResponse)response;
            long fileLength = this.getLength();
            String rangeHeader = (String)request.getHeaders().get("Range");
            long position = 0L;
            long contentLength = fileLength;
            if (rangeHeader != null && request.getMethod() == HttpMethod.GET && rangeHeader.startsWith(UNIT_BYTES) && response.status() == HttpStatus.OK && (range = NettySystemFileCustomizableResponseType.parseRangeHeader(rangeHeader, fileLength)) != null && range.firstPos < range.lastPos && range.firstPos < fileLength && range.lastPos < fileLength) {
                position = range.firstPos;
                contentLength = range.lastPos + 1L - range.firstPos;
                response.status(HttpStatus.PARTIAL_CONTENT);
                response.header("Content-Range", String.format("%s %d-%d/%d", UNIT_BYTES, range.firstPos, range.lastPos, fileLength));
            }
            response.header("Accept-Ranges", UNIT_BYTES);
            response.header("Content-Length", Long.toString(contentLength));
            DefaultHttpResponse finalResponse = new DefaultHttpResponse(nettyResponse.getNettyHttpVersion(), nettyResponse.getNettyHttpStatus(), nettyResponse.getNettyHeaders());
            context.write(finalResponse, context.voidPromise());
            FileHolder file = new FileHolder(this.getFile());
            SmartHttpContentCompressor predicate = context.channel().attr(ZERO_COPY_PREDICATE.get()).get();
            if (predicate != null && predicate.shouldSkip(finalResponse)) {
                context.write(new DefaultFileRegion(file.raf.getChannel(), position, contentLength), context.newProgressivePromise()).addListener(file);
                return context.writeAndFlush(LastHttpContent.EMPTY_LAST_CONTENT);
            }
            try {
                HttpChunkedInput chunkedInput = new HttpChunkedInput(new ChunkedFile(file.raf, position, contentLength, 8192));
                return context.writeAndFlush(chunkedInput, context.newProgressivePromise()).addListener(file);
            }
            catch (IOException e) {
                throw new CustomizableResponseTypeException("Could not read file", e);
            }
        }
        throw new IllegalArgumentException("Unsupported response type. Not a Netty response: " + response);
    }

    @Nullable
    private static IntRange parseRangeHeader(String value, long contentLength) {
        int equalsIdx = value.indexOf(61);
        if (equalsIdx < 0 || equalsIdx == value.length() - 1) {
            return null;
        }
        int minusIdx = value.indexOf(45, equalsIdx + 1);
        if (minusIdx < 0) {
            return null;
        }
        String from = value.substring(equalsIdx + 1, minusIdx).trim();
        String to = value.substring(minusIdx + 1).trim();
        try {
            long fromPosition = from.isEmpty() ? 0L : Long.parseLong(from);
            long toPosition = to.isEmpty() ? contentLength - 1L : Long.parseLong(to);
            return new IntRange(fromPosition, toPosition);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private static class IntRange {
        private final long firstPos;
        private final long lastPos;

        IntRange(long firstPos, long lastPos) {
            this.firstPos = firstPos;
            this.lastPos = lastPos;
        }
    }

    private static final class FileHolder
    implements ChannelFutureListener {
        private static final Supplier<ResourceLeakDetector<RandomAccessFile>> LEAK_DETECTOR = SupplierUtil.memoized(() -> ResourceLeakDetectorFactory.instance().newResourceLeakDetector(RandomAccessFile.class));
        final RandomAccessFile raf;
        final long length;
        private final ResourceLeakTracker<RandomAccessFile> tracker;
        private final File file;

        FileHolder(File file) {
            this.file = file;
            try {
                this.raf = new RandomAccessFile(file, "r");
            }
            catch (FileNotFoundException e) {
                throw new CustomizableResponseTypeException("Could not find file", e);
            }
            this.tracker = LEAK_DETECTOR.get().track(this.raf);
            try {
                this.length = this.raf.length();
            }
            catch (IOException e) {
                this.close();
                throw new CustomizableResponseTypeException("Could not determine file length", e);
            }
        }

        @Override
        public void operationComplete(@NonNull ChannelFuture future) throws Exception {
            this.close();
        }

        void close() {
            try {
                this.raf.close();
            }
            catch (IOException e) {
                LOG.warn("An error occurred closing the file reference: " + this.file.getAbsolutePath(), e);
            }
            if (this.tracker != null) {
                this.tracker.close(this.raf);
            }
        }
    }
}

