/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject;

import io.micronaut.context.Qualifier;
import io.micronaut.context.annotation.ConfigurationReader;
import io.micronaut.context.annotation.DefaultScope;
import io.micronaut.context.annotation.EachBean;
import io.micronaut.context.annotation.EachProperty;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.naming.Named;
import io.micronaut.core.reflect.ReflectionUtils;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.ArgumentCoercible;
import io.micronaut.inject.BeanType;
import io.micronaut.inject.ConstructorInjectionPoint;
import io.micronaut.inject.ExecutableMethod;
import io.micronaut.inject.FieldInjectionPoint;
import io.micronaut.inject.MethodInjectionPoint;
import io.micronaut.inject.QualifiedBeanType;
import jakarta.inject.Singleton;
import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;

public interface BeanDefinition<T>
extends QualifiedBeanType<T>,
Named,
BeanType<T>,
ArgumentCoercible<T> {
    default public Optional<Class<? extends Annotation>> getScope() {
        return Optional.empty();
    }

    default public Optional<String> getScopeName() {
        return Optional.empty();
    }

    default public boolean isSingleton() {
        String scopeName = this.getScopeName().orElse(null);
        if (scopeName != null && scopeName.equals("javax.inject.Singleton")) {
            return true;
        }
        return this.getAnnotationMetadata().stringValue(DefaultScope.class).map(t -> t.equals(Singleton.class.getName()) || t.equals("javax.inject.Singleton")).orElse(false);
    }

    default public Optional<Argument<?>> getContainerElement() {
        return Optional.empty();
    }

    @Override
    default public boolean isCandidateBean(@Nullable Argument<?> beanType) {
        if (beanType == null) {
            return false;
        }
        if (QualifiedBeanType.super.isCandidateBean(beanType)) {
            Optional<Argument<?>> containerElement;
            Argument[] typeArguments = beanType.getTypeParameters();
            int len = typeArguments.length;
            Class beanClass = beanType.getType();
            if (len == 0) {
                if (this.isContainerType()) {
                    if (this.getBeanType().isAssignableFrom(beanClass)) {
                        return true;
                    }
                    Optional<Argument<?>> containerElement2 = this.getContainerElement();
                    if (containerElement2.isPresent()) {
                        Class t = containerElement2.get().getType();
                        return beanType.isAssignableFrom(t) || beanClass == t;
                    }
                    return false;
                }
                return true;
            }
            Argument[] beanTypeParameters = !Iterable.class.isAssignableFrom(beanClass) ? ((containerElement = this.getContainerElement()).isPresent() ? containerElement.get().getTypeParameters() : this.getTypeArguments(beanClass).toArray(Argument.ZERO_ARGUMENTS)) : this.getTypeArguments(beanClass).toArray(Argument.ZERO_ARGUMENTS);
            if (len != beanTypeParameters.length) {
                return false;
            }
            for (int i = 0; i < beanTypeParameters.length; ++i) {
                Argument requestedParameter = typeArguments[i];
                Argument candidateParameter = beanTypeParameters[i];
                if (requestedParameter.isAssignableFrom(candidateParameter.getType()) || candidateParameter.isTypeVariable() && candidateParameter.isAssignableFrom(requestedParameter.getType())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    default public boolean isIterable() {
        return this.hasDeclaredStereotype((Class<? extends Annotation>)EachProperty.class) || this.hasDeclaredStereotype((Class<? extends Annotation>)EachBean.class);
    }

    default public boolean isConfigurationProperties() {
        return this.isIterable() || this.hasDeclaredStereotype((Class<? extends Annotation>)ConfigurationReader.class);
    }

    @Override
    public Class<T> getBeanType();

    default public Optional<Class<?>> getDeclaringType() {
        return Optional.empty();
    }

    default public ConstructorInjectionPoint<T> getConstructor() {
        return new ConstructorInjectionPoint<T>(){

            @Override
            public Argument<?>[] getArguments() {
                return Argument.ZERO_ARGUMENTS;
            }

            @Override
            public BeanDefinition<T> getDeclaringBean() {
                return BeanDefinition.this;
            }
        };
    }

    default public Collection<Class<?>> getRequiredComponents() {
        return Collections.emptyList();
    }

    default public Collection<MethodInjectionPoint<T, ?>> getInjectedMethods() {
        return Collections.emptyList();
    }

    default public Collection<FieldInjectionPoint<T, ?>> getInjectedFields() {
        return Collections.emptyList();
    }

    default public Collection<MethodInjectionPoint<T, ?>> getPostConstructMethods() {
        return Collections.emptyList();
    }

    default public Collection<MethodInjectionPoint<T, ?>> getPreDestroyMethods() {
        return Collections.emptyList();
    }

    @Override
    @NonNull
    default public String getName() {
        return this.getBeanType().getName();
    }

    default public <R> Optional<ExecutableMethod<T, R>> findMethod(String name, Class<?> ... argumentTypes) {
        return Optional.empty();
    }

    default public <R> Stream<ExecutableMethod<T, R>> findPossibleMethods(String name) {
        return Stream.empty();
    }

    default public Collection<ExecutableMethod<T, ?>> getExecutableMethods() {
        return Collections.emptyList();
    }

    @Override
    @NonNull
    default public Argument<T> asArgument() {
        return Argument.of(this.getBeanType(), this.getTypeParameters());
    }

    default public boolean isProxy() {
        return false;
    }

    @NonNull
    default public List<Argument<?>> getTypeArguments() {
        return this.getTypeArguments(this.getBeanType());
    }

    @NonNull
    default public List<Argument<?>> getTypeArguments(Class<?> type) {
        if (type == null) {
            return Collections.emptyList();
        }
        return this.getTypeArguments(type.getName());
    }

    @NonNull
    default public Class<?>[] getTypeParameters(@Nullable Class<?> type) {
        if (type == null) {
            return ReflectionUtils.EMPTY_CLASS_ARRAY;
        }
        List<Argument<?>> typeArguments = this.getTypeArguments(type);
        if (typeArguments.isEmpty()) {
            return ReflectionUtils.EMPTY_CLASS_ARRAY;
        }
        Class[] params = new Class[typeArguments.size()];
        int i = 0;
        for (Argument<?> argument : typeArguments) {
            params[i++] = argument.getType();
        }
        return params;
    }

    @NonNull
    default public Class<?>[] getTypeParameters() {
        return this.getTypeParameters(this.getBeanType());
    }

    @NonNull
    default public List<Argument<?>> getTypeArguments(String type) {
        return Collections.emptyList();
    }

    default public <R> ExecutableMethod<T, R> getRequiredMethod(String name, Class<?> ... argumentTypes) {
        return this.findMethod(name, argumentTypes).orElseThrow(() -> ReflectionUtils.newNoSuchMethodError(this.getBeanType(), name, argumentTypes));
    }

    default public boolean isAbstract() {
        return Modifier.isAbstract(this.getBeanType().getModifiers());
    }

    @Override
    default public Argument<T> getGenericBeanType() {
        return this.asArgument();
    }

    @Override
    @Nullable
    default public Qualifier<T> getDeclaredQualifier() {
        return QualifiedBeanType.super.getDeclaredQualifier();
    }

    @Override
    @Nullable
    default public Qualifier<T> resolveDynamicQualifier() {
        return QualifiedBeanType.super.resolveDynamicQualifier();
    }
}

