/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject;

import io.micronaut.context.BeanContext;
import io.micronaut.context.annotation.ConfigurationReader;
import io.micronaut.context.annotation.DefaultScope;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.inject.BeanDefinition;
import io.micronaut.inject.QualifiedBeanType;
import jakarta.inject.Singleton;
import java.lang.annotation.Annotation;

@Internal
public interface BeanDefinitionReference<T>
extends QualifiedBeanType<T> {
    public String getBeanDefinitionName();

    public BeanDefinition<T> load();

    default public BeanDefinition<T> load(BeanContext context) {
        return this.load();
    }

    default public boolean isContextScope() {
        return false;
    }

    public boolean isPresent();

    default public boolean isSingleton() {
        AnnotationMetadata am = this.getAnnotationMetadata();
        if (am.hasDeclaredStereotype("javax.inject.Singleton")) {
            return true;
        }
        if (!am.hasDeclaredStereotype("javax.inject.Scope") && am.hasDeclaredStereotype((Class<? extends Annotation>)DefaultScope.class)) {
            return am.stringValue(DefaultScope.class).map(t -> t.equals(Singleton.class.getName()) || t.equals("javax.inject.Singleton")).orElse(false);
        }
        return false;
    }

    default public boolean isConfigurationProperties() {
        return this.getAnnotationMetadata().hasDeclaredStereotype((Class<? extends Annotation>)ConfigurationReader.class);
    }

    default public boolean isProxiedBean() {
        return false;
    }

    default public boolean isProxyTarget() {
        return false;
    }
}

