/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject;

import io.micronaut.context.Qualifier;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationMetadataDelegate;
import io.micronaut.core.annotation.AnnotationSource;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.inject.BeanType;
import io.micronaut.inject.annotation.AnnotationMetadataHierarchy;
import io.micronaut.inject.qualifiers.Qualifiers;
import java.util.List;

public interface QualifiedBeanType<T>
extends BeanType<T>,
AnnotationMetadataDelegate {
    @Nullable
    default public Qualifier<T> getDeclaredQualifier() {
        List annotations;
        AnnotationSource annotationMetadata = this.getTargetAnnotationMetadata();
        if (annotationMetadata instanceof AnnotationMetadataHierarchy) {
            annotationMetadata = annotationMetadata.getDeclaredMetadata();
        }
        if (!(annotations = annotationMetadata.getAnnotationValuesByStereotype("javax.inject.Qualifier")).isEmpty()) {
            if (annotations.size() == 1) {
                AnnotationValue annotationValue = annotations.iterator().next();
                if (annotationValue.getAnnotationName().equals(Qualifier.PRIMARY)) {
                    return null;
                }
                return Qualifiers.byAnnotation((AnnotationMetadata)annotationMetadata, annotationValue);
            }
            Qualifier[] qualifiers = new Qualifier[annotations.size()];
            int i = 0;
            for (AnnotationValue annotationValue : annotations) {
                qualifiers[i++] = Qualifiers.byAnnotation((AnnotationMetadata)annotationMetadata, annotationValue);
            }
            return Qualifiers.byQualifiers(qualifiers);
        }
        Qualifier<T> qualifier = this.resolveDynamicQualifier();
        if (qualifier == null) {
            String name = annotationMetadata.stringValue("javax.inject.Named").orElse(null);
            qualifier = name != null ? Qualifiers.byAnnotation((AnnotationMetadata)annotationMetadata, name) : null;
        }
        return qualifier;
    }

    @Nullable
    default public Qualifier<T> resolveDynamicQualifier() {
        return null;
    }
}

