/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.jackson.core.env;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import io.micronaut.context.env.AbstractPropertySourceLoader;
import io.micronaut.jackson.core.tree.JsonNodeTreeCodec;
import io.micronaut.json.tree.JsonNode;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class JsonPropertySourceLoader
extends AbstractPropertySourceLoader {
    public static final String FILE_EXTENSION = "json";

    @Override
    public Set<String> getExtensions() {
        return Collections.singleton(FILE_EXTENSION);
    }

    @Override
    protected void processInput(String name, InputStream input, Map<String, Object> finalMap) throws IOException {
        Map<String, Object> map = this.readJsonAsMap(input);
        this.processMap(finalMap, map, "");
    }

    protected Map<String, Object> readJsonAsMap(InputStream input) throws IOException {
        return (Map)this.unwrap(this.readJsonAsObject(input));
    }

    private JsonNode readJsonAsObject(InputStream input) throws IOException {
        try (JsonParser parser = new JsonFactory().createParser(input);){
            JsonNode jsonNode = JsonNodeTreeCodec.getInstance().readTree(parser);
            return jsonNode;
        }
    }

    private Object unwrap(JsonNode value) {
        if (value.isNumber()) {
            return value.getNumberValue();
        }
        if (value.isNull()) {
            return null;
        }
        if (value.isBoolean()) {
            return value.getBooleanValue();
        }
        if (value.isArray()) {
            ArrayList unwrapped = new ArrayList();
            value.values().forEach(v -> unwrapped.add(this.unwrap((JsonNode)v)));
            return unwrapped;
        }
        if (value.isObject()) {
            LinkedHashMap unwrapped = new LinkedHashMap();
            value.entries().forEach(e -> unwrapped.put((String)e.getKey(), this.unwrap((JsonNode)e.getValue())));
            return unwrapped;
        }
        return value.getStringValue();
    }
}

