/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.management.health.indicator;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.micronaut.health.HealthStatus;
import io.micronaut.management.health.indicator.DefaultHealthResult;
import jakarta.validation.constraints.NotNull;
import java.lang.invoke.CallSite;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(as=DefaultHealthResult.class)
public interface HealthResult {
    public String getName();

    public HealthStatus getStatus();

    public Object getDetails();

    public static Builder builder(String name, HealthStatus status) {
        return new Builder(name, status);
    }

    public static Builder builder(String name) {
        return new Builder(name);
    }

    public static class Builder {
        private static final Logger LOG = LoggerFactory.getLogger(HealthResult.class);
        private final String name;
        private HealthStatus status;
        private Object details;

        Builder(String name, HealthStatus status) {
            this.name = name;
            this.status = status;
        }

        Builder(String name) {
            this.name = name;
        }

        public Builder status(HealthStatus status) {
            this.status = status;
            return this;
        }

        public Builder exception(@NotNull Throwable ex) {
            HashMap<String, CallSite> error = new HashMap<String, CallSite>(1);
            String message = ex.getClass().getName() + ": " + ex.getMessage();
            error.put("error", (CallSite)((Object)message));
            if (LOG.isErrorEnabled()) {
                LOG.error("Health indicator [" + this.name + "] reported exception: " + message, ex);
            }
            return this.details(error);
        }

        public Builder details(Object details) {
            this.details = details;
            return this;
        }

        public HealthResult build() {
            return new DefaultHealthResult(this.name, this.status != null ? this.status : HealthStatus.UNKNOWN, this.details);
        }
    }
}

