/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.serializers;

import io.micronaut.core.type.Argument;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.serde.Encoder;
import io.micronaut.serde.Serializer;
import io.micronaut.serde.exceptions.SerdeException;
import io.micronaut.serde.util.CustomizableSerializer;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.util.Optional;

@Singleton
class OptionalSerializer<T>
implements CustomizableSerializer<Optional<T>> {
    OptionalSerializer() {
    }

    @Override
    public Serializer<Optional<T>> createSpecific(Serializer.EncoderContext encoderContext, Argument<? extends Optional<T>> type) throws SerdeException {
        Object[] generics = type.getTypeParameters();
        if (ArrayUtils.isEmpty(generics)) {
            throw new SerdeException("Serializing raw optionals is for type: " + type);
        }
        Object[] generics1 = type.getTypeParameters();
        if (ArrayUtils.isEmpty(generics1)) {
            throw new SerdeException("Serializing raw optionals is not supported for type: " + type);
        }
        Object generic = generics1[0];
        final Serializer componentSerializer = encoderContext.findSerializer(generic).createSpecific(encoderContext, generic);
        return new Serializer<Optional<T>>(){

            @Override
            public void serialize(Encoder encoder, Serializer.EncoderContext context, Argument<? extends Optional<T>> type, Optional<T> value) throws IOException {
                Object[] generics1 = type.getTypeParameters();
                if (ArrayUtils.isEmpty(generics1)) {
                    throw new SerdeException("Serializing raw optionals is not supported for type: " + type);
                }
                Object generic = generics1[0];
                Object o = value.orElse(null);
                if (o != null) {
                    componentSerializer.serialize(encoder, context, generic, o);
                } else {
                    encoder.encodeNull();
                }
            }

            @Override
            public boolean isEmpty(Serializer.EncoderContext context, Optional<T> value) {
                Optional o = value;
                if (value != null && o.isPresent()) {
                    return componentSerializer.isEmpty(context, o.get());
                }
                return true;
            }

            @Override
            public boolean isAbsent(Serializer.EncoderContext context, Optional<T> value) {
                return value == null || !value.isPresent();
            }
        };
    }
}

