/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.web.router;

import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationMetadataProvider;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.ReturnType;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.MediaType;
import io.micronaut.http.annotation.Body;
import io.micronaut.scheduling.executor.ThreadSelection;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutorService;

public interface RouteInfo<R>
extends AnnotationMetadataProvider {
    public static final List<MediaType> DEFAULT_PRODUCES = Collections.singletonList(MediaType.APPLICATION_JSON_TYPE);

    public ReturnType<? extends R> getReturnType();

    public Argument<?> getBodyType();

    public Optional<Argument<?>> getBodyArgument();

    @Internal
    default public Optional<Argument<?>> getFullBodyArgument() {
        return this.getBodyArgument().filter(argument -> {
            AnnotationMetadata annotationMetadata = argument.getAnnotationMetadata();
            if (annotationMetadata.hasAnnotation(Body.class)) {
                return annotationMetadata.stringValue(Body.class).isEmpty();
            }
            return false;
        });
    }

    public Class<?> getDeclaringType();

    public List<MediaType> getProduces();

    public List<MediaType> getConsumes();

    public boolean doesConsume(@Nullable MediaType var1);

    public boolean doesProduce(@Nullable Collection<MediaType> var1);

    public boolean doesProduce(@Nullable MediaType var1);

    public boolean explicitlyConsumes(@Nullable MediaType var1);

    public boolean explicitlyProduces(@Nullable MediaType var1);

    public boolean isSuspended();

    public boolean isReactive();

    public boolean isSingleResult();

    public boolean isSpecifiedSingle();

    public boolean isCompletable();

    public boolean isAsync();

    public boolean isAsyncOrReactive();

    public boolean isVoid();

    public boolean isErrorRoute();

    @NonNull
    public HttpStatus findStatus(HttpStatus var1);

    public boolean isWebSocketRoute();

    public boolean isPermitsRequestBody();

    @Nullable
    public ExecutorService getExecutor(@Nullable ThreadSelection var1);

    public boolean needsRequestBody();
}

