/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.containers.wait.strategy;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URI;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509ExtendedTrustManager;
import org.rnorth.ducttape.TimeoutException;
import org.rnorth.ducttape.unreliables.Unreliables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.ContainerLaunchException;
import org.testcontainers.containers.wait.strategy.AbstractWaitStrategy;
import org.testcontainers.shaded.com.google.common.base.Strings;
import org.testcontainers.shaded.com.google.common.io.BaseEncoding;

public class HttpWaitStrategy
extends AbstractWaitStrategy {
    private static final Logger log = LoggerFactory.getLogger(HttpWaitStrategy.class);
    private static final String HEADER_AUTHORIZATION = "Authorization";
    private static final String AUTH_BASIC = "Basic ";
    private String path = "/";
    private String method = "GET";
    private Set<Integer> statusCodes = new HashSet<Integer>();
    private boolean tlsEnabled;
    private String username;
    private String password;
    private final Map<String, String> headers = new HashMap<String, String>();
    private Predicate<String> responsePredicate;
    private Predicate<Integer> statusCodePredicate = null;
    private Optional<Integer> livenessPort = Optional.empty();
    private Duration readTimeout = Duration.ofSeconds(1L);
    private boolean allowInsecure;

    public HttpWaitStrategy forStatusCode(int statusCode) {
        this.statusCodes.add(statusCode);
        return this;
    }

    public HttpWaitStrategy forStatusCodeMatching(Predicate<Integer> statusCodePredicate) {
        this.statusCodePredicate = statusCodePredicate;
        return this;
    }

    public HttpWaitStrategy forPath(String path) {
        this.path = path;
        return this;
    }

    public HttpWaitStrategy forPort(int port) {
        this.livenessPort = Optional.of(port);
        return this;
    }

    public HttpWaitStrategy usingTls() {
        this.tlsEnabled = true;
        return this;
    }

    public HttpWaitStrategy withMethod(String method) {
        this.method = method;
        return this;
    }

    public HttpWaitStrategy allowInsecure() {
        this.allowInsecure = true;
        return this;
    }

    public HttpWaitStrategy withBasicCredentials(String username, String password) {
        this.username = username;
        this.password = password;
        return this;
    }

    public HttpWaitStrategy withHeader(String name, String value) {
        this.headers.put(name, value);
        return this;
    }

    public HttpWaitStrategy withHeaders(Map<String, String> headers) {
        this.headers.putAll(headers);
        return this;
    }

    public HttpWaitStrategy withReadTimeout(Duration timeout) {
        if (timeout.toMillis() < 1L) {
            throw new IllegalArgumentException("you cannot specify a value smaller than 1 ms");
        }
        this.readTimeout = timeout;
        return this;
    }

    public HttpWaitStrategy forResponsePredicate(Predicate<String> responsePredicate) {
        this.responsePredicate = responsePredicate;
        return this;
    }

    @Override
    protected void waitUntilReady() {
        String containerName = this.waitStrategyTarget.getContainerInfo().getName();
        Integer livenessCheckPort = this.livenessPort.map(this.waitStrategyTarget::getMappedPort).orElseGet(() -> {
            Set<Integer> livenessCheckPorts = this.getLivenessCheckPorts();
            if (livenessCheckPorts == null || livenessCheckPorts.isEmpty()) {
                log.warn("{}: No exposed ports or mapped ports - cannot wait for status", (Object)containerName);
                return -1;
            }
            return livenessCheckPorts.iterator().next();
        });
        if (null == livenessCheckPort || -1 == livenessCheckPort) {
            return;
        }
        URI rawUri = this.buildLivenessUri(livenessCheckPort);
        String uri = rawUri.toString();
        try {
            int originalPort = this.waitStrategyTarget.getExposedPorts().stream().filter(exposedPort -> rawUri.getPort() == this.waitStrategyTarget.getMappedPort((int)exposedPort).intValue()).findFirst().orElseThrow(() -> new IllegalStateException("Target port " + rawUri.getPort() + " is not exposed"));
            log.info("{}: Waiting for {} seconds for URL: {} (where port {} maps to container port {})", containerName, this.startupTimeout.getSeconds(), uri, rawUri.getPort(), originalPort);
        }
        catch (RuntimeException e) {
            log.warn("Unexpected error occurred - will proceed to try to wait anyway", e);
        }
        try {
            Unreliables.retryUntilSuccess((int)this.startupTimeout.getSeconds(), TimeUnit.SECONDS, () -> {
                this.getRateLimiter().doWhenReady(() -> {
                    try {
                        HttpURLConnection connection = this.openConnection(uri);
                        connection.setReadTimeout(Math.toIntExact(this.readTimeout.toMillis()));
                        if (!Strings.isNullOrEmpty(this.username)) {
                            connection.setRequestProperty(HEADER_AUTHORIZATION, this.buildAuthString(this.username, this.password));
                            connection.setUseCaches(false);
                        }
                        this.headers.forEach(connection::setRequestProperty);
                        connection.setRequestMethod(this.method);
                        connection.connect();
                        log.trace("Get response code {}", (Object)connection.getResponseCode());
                        Predicate<Integer> predicate = this.statusCodes.isEmpty() && this.statusCodePredicate == null ? responseCode -> 200 == responseCode : (!this.statusCodes.isEmpty() && this.statusCodePredicate == null ? responseCode -> this.statusCodes.contains(responseCode) : (this.statusCodes.isEmpty() ? this.statusCodePredicate : this.statusCodePredicate.or(responseCode -> this.statusCodes.contains(responseCode))));
                        if (!predicate.test(connection.getResponseCode())) {
                            throw new RuntimeException(String.format("HTTP response code was: %s", connection.getResponseCode()));
                        }
                        if (this.responsePredicate != null) {
                            String responseBody = this.getResponseBody(connection);
                            log.trace("Get response {}", (Object)responseBody);
                            if (!this.responsePredicate.test(responseBody)) {
                                throw new RuntimeException(String.format("Response: %s did not match predicate", responseBody));
                            }
                        }
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                });
                return true;
            });
        }
        catch (TimeoutException e) {
            throw new ContainerLaunchException(String.format("Timed out waiting for URL to be accessible (%s should return HTTP %s)", uri, this.statusCodes.isEmpty() ? Integer.valueOf(200) : this.statusCodes), e);
        }
    }

    private HttpURLConnection openConnection(String uri) throws IOException, MalformedURLException {
        if (this.tlsEnabled) {
            HttpsURLConnection connection = (HttpsURLConnection)new URL(uri).openConnection();
            if (this.allowInsecure) {
                TrustManager[] trustAllCerts = new TrustManager[]{new X509ExtendedTrustManager(){

                    @Override
                    public X509Certificate[] getAcceptedIssuers() {
                        return new X509Certificate[0];
                    }

                    @Override
                    public void checkClientTrusted(X509Certificate[] certs, String authType) {
                    }

                    @Override
                    public void checkServerTrusted(X509Certificate[] certs, String authType) {
                    }

                    @Override
                    public void checkClientTrusted(X509Certificate[] chain, String authType, Socket socket) {
                    }

                    @Override
                    public void checkServerTrusted(X509Certificate[] chain, String authType, Socket socket) {
                    }

                    @Override
                    public void checkClientTrusted(X509Certificate[] chain, String authType, SSLEngine engine) {
                    }

                    @Override
                    public void checkServerTrusted(X509Certificate[] chain, String authType, SSLEngine engine) {
                    }
                }};
                try {
                    SSLContext sc = SSLContext.getInstance("SSL");
                    sc.init(new KeyManager[0], trustAllCerts, new SecureRandom());
                    connection.setSSLSocketFactory(sc.getSocketFactory());
                }
                catch (KeyManagementException | NoSuchAlgorithmException ex) {
                    throw new IOException("Unable to create custom SSL factory instance", ex);
                }
            }
            return connection;
        }
        return (HttpURLConnection)new URL(uri).openConnection();
    }

    private URI buildLivenessUri(int livenessCheckPort) {
        String scheme = (this.tlsEnabled ? "https" : "http") + "://";
        String host = this.waitStrategyTarget.getHost();
        String portSuffix = this.tlsEnabled && 443 == livenessCheckPort || !this.tlsEnabled && 80 == livenessCheckPort ? "" : ":" + livenessCheckPort;
        return URI.create(scheme + host + portSuffix + this.path);
    }

    private String buildAuthString(String username, String password) {
        return AUTH_BASIC + BaseEncoding.base64().encode((username + ":" + password).getBytes());
    }

    private String getResponseBody(HttpURLConnection connection) throws IOException {
        String line;
        BufferedReader reader = 200 <= connection.getResponseCode() && connection.getResponseCode() <= 299 ? new BufferedReader(new InputStreamReader(connection.getInputStream())) : new BufferedReader(new InputStreamReader(connection.getErrorStream()));
        StringBuilder builder = new StringBuilder();
        while ((line = reader.readLine()) != null) {
            builder.append(line);
        }
        return builder.toString();
    }
}

