/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.aop.chain;

import io.micronaut.aop.Adapter;
import io.micronaut.aop.MethodInterceptor;
import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.context.BeanContext;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.util.StringUtils;
import io.micronaut.inject.ExecutableMethod;
import io.micronaut.inject.ExecutionHandle;
import io.micronaut.inject.qualifiers.Qualifiers;

@Internal
final class AdapterIntroduction
implements MethodInterceptor<Object, Object> {
    private final ExecutionHandle<?, ?> executionHandle;

    AdapterIntroduction(BeanContext beanContext, ExecutableMethod<?, ?> method) {
        Class<?>[] methodArgumentTypes;
        Class beanType = method.classValue(Adapter.class, "adaptedBean").orElse(null);
        if (beanType == null) {
            throw new IllegalStateException("No bean type to adapt found in Adapter configuration for method: " + method);
        }
        String beanMethod = method.stringValue(Adapter.class, "adaptedMethod").orElse(null);
        if (StringUtils.isEmpty(beanMethod)) {
            throw new IllegalStateException("No bean method to adapt found in Adapter configuration for method: " + method);
        }
        String beanQualifier = method.stringValue(Adapter.class, "adaptedQualifier").orElse(null);
        Class<T>[] argumentTypes = method.classValues(Adapter.class, "adaptedArgumentTypes");
        Class<Object>[] arguments = argumentTypes.length == (methodArgumentTypes = method.getArgumentTypes()).length ? argumentTypes : methodArgumentTypes;
        this.executionHandle = StringUtils.isNotEmpty(beanQualifier) ? (ExecutionHandle)beanContext.findExecutionHandle(beanType, Qualifiers.byName(beanQualifier), beanMethod, arguments).orElseThrow(() -> new IllegalStateException("Cannot adapt method [" + method + "]. Target method [" + beanMethod + "] not found on bean " + beanType)) : (ExecutionHandle)beanContext.findExecutionHandle(beanType, beanMethod, (Class<?>[])arguments).orElseThrow(() -> new IllegalStateException("Cannot adapt method [" + method + "]. Target method [" + beanMethod + "] not found on bean " + beanType));
    }

    @Override
    @Nullable
    public Object intercept(MethodInvocationContext<Object, Object> context) {
        return this.executionHandle.invoke(context.getParameterValues());
    }
}

