/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.context;

import io.micronaut.core.annotation.NonNull;
import jakarta.inject.Provider;

public class ProviderUtils {
    public static <T> Provider<T> memoized(Provider<T> delegate) {
        return new MemoizingProvider<T>(delegate);
    }

    private static final class MemoizingProvider<T>
    implements Provider<T> {
        private Provider<T> actual;
        private Provider<T> delegate = this::initialize;
        private boolean initialized;

        MemoizingProvider(@NonNull Provider<T> actual) {
            this.actual = actual;
        }

        @Override
        public T get() {
            return this.delegate.get();
        }

        private synchronized T initialize() {
            if (!this.initialized) {
                Object value = this.actual.get();
                this.delegate = () -> value;
                this.initialized = true;
                this.actual = null;
            }
            return this.delegate.get();
        }

        public String toString() {
            if (this.initialized) {
                return "Provider of " + this.delegate.get();
            }
            return "ProviderUtils.memoized(" + this.actual + ")";
        }
    }
}

