/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.async.propagation;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.propagation.PropagatedContext;
import io.micronaut.core.propagation.PropagatedContextElement;
import java.util.Optional;
import java.util.stream.Stream;
import reactor.util.context.Context;
import reactor.util.context.ContextView;

@Internal
public final class ReactorPropagation {
    private static final String PROPAGATED_CONTEXT_REACTOR_CONTEXT_VIEW_KEY = "micronaut.propagated.context";

    private ReactorPropagation() {
    }

    @NonNull
    public static Context addPropagatedContext(@NonNull Context context, @NonNull PropagatedContext propagatedContext) {
        return context.put(PROPAGATED_CONTEXT_REACTOR_CONTEXT_VIEW_KEY, propagatedContext);
    }

    @NonNull
    public static Context addContextElement(@NonNull Context context, @NonNull PropagatedContextElement contextElement) {
        return ReactorPropagation.addPropagatedContext(context, ReactorPropagation.findPropagatedContext(context).orElse(PropagatedContext.getOrEmpty()).plus(contextElement));
    }

    public static <E extends PropagatedContextElement> Optional<E> findContextElement(@NonNull ContextView contextView, @NonNull Class<E> contextElementType) {
        return ReactorPropagation.findPropagatedContext(contextView).flatMap(ctx -> ctx.find(contextElementType));
    }

    public static <E extends PropagatedContextElement> Stream<E> findAllContextElements(@NonNull ContextView contextView, @NonNull Class<E> contextElementType) {
        return ReactorPropagation.findPropagatedContext(contextView).stream().flatMap(ctx -> ctx.findAll(contextElementType));
    }

    public static Optional<PropagatedContext> findPropagatedContext(@NonNull ContextView contextView) {
        return contextView.getOrEmpty(PROPAGATED_CONTEXT_REACTOR_CONTEXT_VIEW_KEY).map(ctx -> (PropagatedContext)ctx);
    }
}

