/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.propagation;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.propagation.PropagatedContextElement;
import io.micronaut.core.propagation.PropagatedContextImpl;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import java.util.stream.Stream;

public interface PropagatedContext {
    @NonNull
    public static PropagatedContext newContext(@NonNull PropagatedContextElement element) {
        return PropagatedContextImpl.newContext(element);
    }

    @NonNull
    public static PropagatedContext getOrEmpty() {
        return PropagatedContextImpl.getOrEmpty();
    }

    @NonNull
    public static PropagatedContext get() {
        return PropagatedContextImpl.get();
    }

    @NonNull
    public static Optional<PropagatedContext> find() {
        return PropagatedContextImpl.find();
    }

    @NonNull
    public static Runnable wrapCurrent(@NonNull Runnable runnable) {
        return PropagatedContext.find().map(ctx -> ctx.wrap(runnable)).orElse(runnable);
    }

    @NonNull
    public static <V> Callable<V> wrapCurrent(@NonNull Callable<V> callable) {
        return PropagatedContext.find().map(ctx -> ctx.wrap(callable)).orElse(callable);
    }

    @NonNull
    public static <V> Supplier<V> wrapCurrent(@NonNull Supplier<V> supplier) {
        return PropagatedContext.find().map(ctx -> ctx.wrap(supplier)).orElse(supplier);
    }

    public static boolean exists() {
        return PropagatedContextImpl.exists();
    }

    @NonNull
    public PropagatedContext plus(@NonNull PropagatedContextElement var1);

    @NonNull
    public PropagatedContext minus(@NonNull PropagatedContextElement var1);

    @NonNull
    public PropagatedContext replace(@NonNull PropagatedContextElement var1, @NonNull PropagatedContextElement var2);

    public <T extends PropagatedContextElement> Optional<T> find(@NonNull Class<T> var1);

    public <T extends PropagatedContextElement> Stream<T> findAll(@NonNull Class<T> var1);

    public <T extends PropagatedContextElement> T get(@NonNull Class<T> var1);

    public List<PropagatedContextElement> getAllElements();

    @NonNull
    public Scope propagate();

    @NonNull
    default public Runnable wrap(@NonNull Runnable runnable) {
        PropagatedContext propagatedContext = this;
        return () -> {
            try (Scope ignore = propagatedContext.propagate();){
                runnable.run();
            }
        };
    }

    @NonNull
    default public <V> Callable<V> wrap(@NonNull Callable<V> callable) {
        PropagatedContext propagatedContext = this;
        return () -> {
            try (Scope ignore = propagatedContext.propagate();){
                Object v = callable.call();
                return v;
            }
        };
    }

    @NonNull
    default public <V> Supplier<V> wrap(@NonNull Supplier<V> supplier) {
        PropagatedContext propagatedContext = this;
        return () -> {
            try (Scope ignore = propagatedContext.propagate();){
                Object t = supplier.get();
                return t;
            }
        };
    }

    @NonNull
    default public <V> V propagate(@NonNull Supplier<V> supplier) {
        PropagatedContext propagatedContext = this;
        try (Scope ignore = propagatedContext.propagate();){
            V v = supplier.get();
            return v;
        }
    }

    public static interface Scope
    extends AutoCloseable {
        @Override
        public void close();
    }
}

