/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.propagation;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.propagation.PropagatedContext;
import io.micronaut.core.propagation.PropagatedContextElement;
import io.micronaut.core.propagation.ThreadPropagatedContextElement;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.stream.Stream;

@Internal
final class PropagatedContextImpl
implements PropagatedContext {
    private static final ThreadLocal<PropagatedContextImpl> THREAD_CONTEXT = new ThreadLocal<PropagatedContextImpl>(){

        public String toString() {
            return "Micronaut Propagation Context";
        }
    };
    private static final PropagatedContext.Scope CLEANUP = THREAD_CONTEXT::remove;
    private static final PropagatedContextImpl EMPTY = new PropagatedContextImpl(Collections.emptyList());
    private final List<PropagatedContextElement> elements;
    private final boolean containsThreadElements;

    private PropagatedContextImpl(List<PropagatedContextElement> elements) {
        this.elements = elements;
        boolean containsThreadElements = false;
        for (PropagatedContextElement element : elements) {
            if (!(element instanceof ThreadPropagatedContextElement)) continue;
            containsThreadElements = true;
            break;
        }
        this.containsThreadElements = containsThreadElements;
    }

    public static PropagatedContextImpl newContext(PropagatedContextElement element) {
        return new PropagatedContextImpl(Collections.singletonList(element));
    }

    public static boolean exists() {
        PropagatedContextImpl propagatedContext = THREAD_CONTEXT.get();
        if (propagatedContext == null) {
            return false;
        }
        return !propagatedContext.elements.isEmpty();
    }

    public static PropagatedContextImpl get() {
        PropagatedContextImpl propagatedContext = THREAD_CONTEXT.get();
        if (propagatedContext == null) {
            throw new IllegalStateException("No active propagation context!");
        }
        return propagatedContext;
    }

    public static Optional<PropagatedContext> find() {
        return Optional.ofNullable((PropagatedContext)THREAD_CONTEXT.get());
    }

    @NonNull
    public static PropagatedContextImpl getOrEmpty() {
        PropagatedContextImpl propagatedContext = THREAD_CONTEXT.get();
        if (propagatedContext == null) {
            return EMPTY;
        }
        return propagatedContext;
    }

    @Override
    public PropagatedContextImpl plus(PropagatedContextElement element) {
        ArrayList<PropagatedContextElement> newElements = new ArrayList<PropagatedContextElement>(this.elements.size() + 1);
        newElements.addAll(this.elements);
        newElements.add(element);
        return new PropagatedContextImpl(Collections.unmodifiableList(newElements));
    }

    @Override
    public PropagatedContextImpl minus(PropagatedContextElement element) {
        ArrayList<PropagatedContextElement> newElements = new ArrayList<PropagatedContextElement>(this.elements);
        if (!newElements.remove(element)) {
            throw new NoSuchElementException("Element is not contained in the current context!");
        }
        return new PropagatedContextImpl(Collections.unmodifiableList(newElements));
    }

    @Override
    public PropagatedContext replace(PropagatedContextElement oldElement, PropagatedContextElement newElement) {
        ArrayList<PropagatedContextElement> newElements = new ArrayList<PropagatedContextElement>(this.elements);
        int index = newElements.indexOf(oldElement);
        if (index < 0) {
            throw new NoSuchElementException("Element is not contained in the current context!");
        }
        newElements.set(index, newElement);
        return new PropagatedContextImpl(Collections.unmodifiableList(newElements));
    }

    @Override
    public <T extends PropagatedContextElement> Optional<T> find(Class<T> elementType) {
        return Optional.ofNullable(this.findElement(elementType));
    }

    @Override
    public <T extends PropagatedContextElement> Stream<T> findAll(Class<T> elementType) {
        ArrayList<PropagatedContextElement> reverseElements = new ArrayList<PropagatedContextElement>(this.elements);
        Collections.reverse(reverseElements);
        return reverseElements.stream().filter(elementType::isInstance).map(elementType::cast);
    }

    @Override
    public <T extends PropagatedContextElement> T get(Class<T> elementType) {
        T element = this.findElement(elementType);
        if (element == null) {
            throw new NoSuchElementException();
        }
        return element;
    }

    private <T extends PropagatedContextElement> T findElement(Class<T> elementType) {
        ListIterator<PropagatedContextElement> listIterator = this.elements.listIterator(this.elements.size());
        while (listIterator.hasPrevious()) {
            PropagatedContextElement element = listIterator.previous();
            if (!elementType.isInstance(element)) continue;
            return (T)element;
        }
        return null;
    }

    @Override
    public List<PropagatedContextElement> getAllElements() {
        return this.elements;
    }

    @Override
    public PropagatedContext.Scope propagate() {
        PropagatedContext.Scope restore;
        PropagatedContextImpl prevCtx = THREAD_CONTEXT.get();
        PropagatedContext.Scope scope = restore = prevCtx == null ? CLEANUP : () -> THREAD_CONTEXT.set(prevCtx);
        if (prevCtx == this || this.elements.isEmpty()) {
            return restore;
        }
        PropagatedContextImpl ctx = this;
        THREAD_CONTEXT.set(ctx);
        if (this.containsThreadElements) {
            List<Map.Entry<ThreadPropagatedContextElement<Object>, Object>> threadState = ctx.updateThreadState();
            return () -> {
                ctx.restoreState(threadState);
                if (prevCtx == null) {
                    THREAD_CONTEXT.remove();
                } else {
                    THREAD_CONTEXT.set(prevCtx);
                }
            };
        }
        return restore;
    }

    private List<Map.Entry<ThreadPropagatedContextElement<Object>, Object>> updateThreadState() {
        ArrayList<Map.Entry<ThreadPropagatedContextElement<Object>, Object>> threadState = new ArrayList<Map.Entry<ThreadPropagatedContextElement<Object>, Object>>(this.elements.size());
        for (PropagatedContextElement element : this.elements) {
            if (!(element instanceof ThreadPropagatedContextElement)) continue;
            ThreadPropagatedContextElement threadPropagatedContextElement = (ThreadPropagatedContextElement)element;
            Object state = threadPropagatedContextElement.updateThreadContext();
            threadState.add(new AbstractMap.SimpleEntry(threadPropagatedContextElement, state));
        }
        return threadState;
    }

    private void restoreState(List<Map.Entry<ThreadPropagatedContextElement<Object>, Object>> threadState) {
        for (Map.Entry<ThreadPropagatedContextElement<Object>, Object> e : threadState) {
            ThreadPropagatedContextElement<Object> threadPropagatedContextElement = e.getKey();
            threadPropagatedContextElement.restoreThreadContext(e.getValue());
        }
    }
}

