/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.reactive.execution;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.execution.ExecutionFlow;
import io.micronaut.core.execution.ImperativeExecutionFlow;
import io.micronaut.http.reactive.execution.ReactiveExecutionFlow;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscription;
import reactor.core.CoreSubscriber;
import reactor.core.Fuseable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Sinks;
import reactor.util.context.Context;
import reactor.util.context.ContextView;

@Internal
final class ReactorExecutionFlowImpl
implements ReactiveExecutionFlow<Object> {
    private Mono<Object> value;

    <K> ReactorExecutionFlowImpl(Publisher<K> value) {
        Mono<Object> mono;
        if (value instanceof Flux) {
            Flux flux = (Flux)value;
            mono = flux.next();
        } else {
            mono = Mono.from(value);
        }
        this(mono);
    }

    <K> ReactorExecutionFlowImpl(Mono<K> value) {
        this.value = value;
    }

    @Override
    public <R> ExecutionFlow<R> flatMap(Function<? super Object, ? extends ExecutionFlow<? extends R>> transformer) {
        this.value = this.value.flatMap((? super T value) -> ReactorExecutionFlowImpl.toMono((ExecutionFlow)transformer.apply(value)));
        return this;
    }

    @Override
    public <R> ExecutionFlow<R> then(Supplier<? extends ExecutionFlow<? extends R>> supplier) {
        this.value = this.value.then(Mono.fromSupplier(supplier).flatMap(ReactorExecutionFlowImpl::toMono));
        return this;
    }

    @Override
    public <R> ExecutionFlow<R> map(Function<? super Object, ? extends R> function) {
        this.value = this.value.map(function);
        return this;
    }

    @Override
    public ExecutionFlow<Object> onErrorResume(Function<? super Throwable, ? extends ExecutionFlow<?>> fallback) {
        this.value = this.value.onErrorResume((? super Throwable throwable) -> ReactorExecutionFlowImpl.toMono((ExecutionFlow)fallback.apply((Throwable)throwable)));
        return this;
    }

    @Override
    public ExecutionFlow<Object> putInContext(String key, Object value) {
        this.value = this.value.contextWrite(context -> context.put(key, value));
        return this;
    }

    @Override
    public void onComplete(final BiConsumer<? super Object, Throwable> fn) {
        this.value.subscribe(new CoreSubscriber<Object>(){
            Subscription subscription;
            Object value;

            @Override
            public Context currentContext() {
                if (fn instanceof ReactiveConsumer) {
                    ReactiveConsumer reactiveConsumer = (ReactiveConsumer)fn;
                    return Context.of(reactiveConsumer.contextView);
                }
                return CoreSubscriber.super.currentContext();
            }

            @Override
            public void onSubscribe(Subscription s) {
                this.subscription = s;
                s.request(1L);
            }

            @Override
            public void onNext(Object v) {
                this.value = v;
                this.subscription.request(1L);
            }

            @Override
            public void onError(Throwable t) {
                fn.accept(null, t);
            }

            @Override
            public void onComplete() {
                fn.accept(this.value, null);
            }
        });
    }

    @Override
    @Nullable
    public ImperativeExecutionFlow<Object> tryComplete() {
        Mono<Object> mono = this.value;
        if (mono instanceof Fuseable.ScalarCallable) {
            Fuseable.ScalarCallable callable = (Fuseable.ScalarCallable)((Object)mono);
            try {
                return (ImperativeExecutionFlow)ExecutionFlow.just(callable.call());
            }
            catch (Exception e) {
                return (ImperativeExecutionFlow)ExecutionFlow.error(e);
            }
        }
        return null;
    }

    static <R> Mono<Object> toMono(ExecutionFlow<R> next) {
        if (next instanceof ReactorExecutionFlowImpl) {
            ReactorExecutionFlowImpl reactiveFlowImpl = (ReactorExecutionFlowImpl)next;
            return reactiveFlowImpl.value;
        }
        if (next instanceof ImperativeExecutionFlow) {
            ImperativeExecutionFlow imperativeFlow = (ImperativeExecutionFlow)next;
            Mono<Object> m = imperativeFlow.getError() != null ? Mono.error(imperativeFlow.getError()) : (imperativeFlow.getValue() != null ? Mono.just(imperativeFlow.getValue()) : Mono.empty());
            Map<String, Object> context = imperativeFlow.getContext();
            if (!context.isEmpty()) {
                m = m.contextWrite(ctx -> {
                    for (Map.Entry e : context.entrySet()) {
                        ctx = ctx.put(e.getKey(), e.getValue());
                    }
                    return ctx;
                });
            }
            return m;
        }
        return Mono.deferContextual(contextView -> {
            final Sinks.One sink = Sinks.one();
            ReactiveConsumer reactiveConsumer = new ReactiveConsumer((ContextView)contextView){

                @Override
                public void accept(Object o, Throwable throwable) {
                    if (throwable != null) {
                        sink.tryEmitError(throwable);
                    } else {
                        sink.tryEmitValue(o);
                    }
                }
            };
            next.onComplete(reactiveConsumer);
            return sink.asMono();
        });
    }

    static <R> Mono<Object> toMono(Supplier<ExecutionFlow<R>> next) {
        return Mono.defer(() -> ReactorExecutionFlowImpl.toMono((ExecutionFlow)next.get()));
    }

    @Override
    public Publisher<Object> toPublisher() {
        return this.value;
    }

    @Override
    public CompletableFuture<Object> toCompletableFuture() {
        return this.value.toFuture();
    }

    private static abstract class ReactiveConsumer
    implements BiConsumer<Object, Throwable> {
        private final ContextView contextView;

        private ReactiveConsumer(ContextView contextView) {
            this.contextView = contextView;
        }
    }
}

