/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.serdes;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.type.Argument;
import io.micronaut.serde.Decoder;
import io.micronaut.serde.Deserializer;
import io.micronaut.serde.Encoder;
import io.micronaut.serde.Serializer;
import io.micronaut.serde.config.SerdeConfiguration;
import io.micronaut.serde.support.serdes.TemporalSerde;
import java.io.IOException;
import java.time.DateTimeException;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.Optional;

public abstract class DefaultFormattedTemporalSerde<T extends TemporalAccessor>
implements TemporalSerde<T> {
    private final DateTimeFormatter stringFormatter;

    protected DefaultFormattedTemporalSerde(@NonNull SerdeConfiguration configuration, @NonNull DateTimeFormatter defaultStringFormatter) {
        this.stringFormatter = DefaultFormattedTemporalSerde.createFormatter(configuration).orElse(defaultStringFormatter);
    }

    @Override
    public final void serialize(Encoder encoder, Serializer.EncoderContext context, Argument<? extends T> type, T value) throws IOException {
        this.serialize0(encoder, value);
    }

    void serialize0(Encoder encoder, T value) throws IOException {
        encoder.encodeString(this.stringFormatter.format((TemporalAccessor)value));
    }

    @Override
    public final T deserialize(Decoder decoder, Deserializer.DecoderContext decoderContext, Argument<? super T> type) throws IOException {
        String text = decoder.decodeString();
        try {
            return (T)((TemporalAccessor)this.stringFormatter.parse((CharSequence)text, this.query()));
        }
        catch (DateTimeException e) {
            return this.deserializeFallback(e, text);
        }
    }

    T deserializeFallback(DateTimeException exc, String s) {
        throw exc;
    }

    @NonNull
    private static Optional<DateTimeFormatter> createFormatter(@NonNull SerdeConfiguration configuration) {
        return configuration.getDateFormat().map(pattern -> configuration.getLocale().map(locale -> DateTimeFormatter.ofPattern(pattern, locale)).orElseGet(() -> DateTimeFormatter.ofPattern(pattern))).map(formatter -> configuration.getTimeZone().map(tz -> formatter.withZone(tz.toZoneId())).orElse((DateTimeFormatter)formatter));
    }
}

