/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.utility;

import com.github.dockerjava.api.model.AuthConfig;
import org.jetbrains.annotations.NotNull;
import org.testcontainers.shaded.com.google.common.base.MoreObjects;
import org.testcontainers.shaded.com.google.common.base.Strings;

public final class AuthConfigUtil {
    public static String toSafeString(AuthConfig authConfig) {
        if (authConfig == null) {
            return "null";
        }
        return MoreObjects.toStringHelper(authConfig).add("username", authConfig.getUsername()).add("password", AuthConfigUtil.obfuscated(authConfig.getPassword())).add("auth", AuthConfigUtil.obfuscated(authConfig.getAuth())).add("email", authConfig.getEmail()).add("registryAddress", authConfig.getRegistryAddress()).add("registryToken", AuthConfigUtil.obfuscated(authConfig.getRegistrytoken())).toString();
    }

    @NotNull
    private static String obfuscated(String value) {
        return Strings.isNullOrEmpty(value) ? "blank" : "hidden non-blank value";
    }

    private AuthConfigUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

