/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.utility;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Stream;
import java.util.zip.Checksum;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.DockerClientFactory;
import org.testcontainers.images.builder.Transferable;
import org.testcontainers.shaded.com.google.common.base.Charsets;
import org.testcontainers.shaded.org.apache.commons.io.FileUtils;
import org.testcontainers.shaded.org.apache.commons.lang3.SystemUtils;
import org.testcontainers.utility.Base58;
import org.testcontainers.utility.PathUtils;

public class MountableFile
implements Transferable {
    private static final Logger log = LoggerFactory.getLogger(MountableFile.class);
    private static final String TESTCONTAINERS_TMP_DIR_PREFIX = ".testcontainers-tmp-";
    private static final String OS_MAC_TMP_DIR = "/tmp";
    private static final int BASE_FILE_MODE = 32768;
    private static final int BASE_DIR_MODE = 16384;
    private final String path;
    private final Integer forcedFileMode;
    private final AtomicReference<Object> resolvedPath = new AtomicReference();
    private final AtomicReference<Object> filesystemPath = new AtomicReference();
    private String resourcePath;

    public static MountableFile forClasspathResource(@NotNull String resourceName) {
        return MountableFile.forClasspathResource(resourceName, null);
    }

    public static MountableFile forHostPath(@NotNull String path) {
        return MountableFile.forHostPath(path, null);
    }

    public static MountableFile forHostPath(Path path) {
        return MountableFile.forHostPath(path, null);
    }

    public static MountableFile forClasspathResource(@NotNull String resourceName, Integer mode) {
        return new MountableFile(MountableFile.getClasspathResource(resourceName, new HashSet<ClassLoader>()).toString(), mode);
    }

    public static MountableFile forHostPath(@NotNull String path, Integer mode) {
        return MountableFile.forHostPath(Paths.get(path, new String[0]), mode);
    }

    public static MountableFile forHostPath(Path path, Integer mode) {
        return new MountableFile(path.toAbsolutePath().toString(), mode);
    }

    @NotNull
    private static URL getClasspathResource(@NotNull String resourcePath, @NotNull Set<ClassLoader> classLoaders) {
        HashSet<ClassLoader> classLoadersToSearch = new HashSet<ClassLoader>(classLoaders);
        classLoadersToSearch.add(Thread.currentThread().getContextClassLoader());
        classLoadersToSearch.add(ClassLoader.getSystemClassLoader());
        classLoadersToSearch.add(MountableFile.class.getClassLoader());
        for (ClassLoader classLoader : classLoadersToSearch) {
            if (classLoader == null) continue;
            URL resource = classLoader.getResource(resourcePath);
            if (resource != null) {
                return resource;
            }
            if (!resourcePath.startsWith("/") || (resource = classLoader.getResource(resourcePath.replaceFirst("/", ""))) == null) continue;
            return resource;
        }
        throw new IllegalArgumentException("Resource with path " + resourcePath + " could not be found on any of these classloaders: " + classLoadersToSearch);
    }

    private static String unencodeResourceURIToFilePath(@NotNull String resource) {
        try {
            return URLDecoder.decode(resource.replaceAll("\\+", "%2B"), Charsets.UTF_8.name()).replaceFirst("jar:", "").replaceFirst("file:", "").replaceAll("!.*", "");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }

    private String resolvePath() {
        String result = this.getResourcePath();
        if (SystemUtils.IS_OS_WINDOWS && result.startsWith("/")) {
            result = result.substring(1);
        }
        return result;
    }

    private String resolveFilesystemPath() {
        String result = this.getResourcePath();
        if (SystemUtils.IS_OS_WINDOWS && result.startsWith("/")) {
            result = PathUtils.createMinGWPath(result).substring(1);
        }
        return result;
    }

    private String getResourcePath() {
        this.resourcePath = this.path.contains(".jar!") ? this.extractClassPathResourceToTempLocation(this.path) : MountableFile.unencodeResourceURIToFilePath(this.path);
        return this.resourcePath;
    }

    private String extractClassPathResourceToTempLocation(String hostPath) {
        File tmpLocation = this.createTempDirectory();
        tmpLocation.delete();
        String urldecodedJarPath = MountableFile.unencodeResourceURIToFilePath(hostPath);
        String internalPath = hostPath.replaceAll("[^!]*!/", "");
        try (JarFile jarFile = new JarFile(urldecodedJarPath);){
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                String name = entry.getName();
                if (!name.startsWith(internalPath)) continue;
                log.debug("Copying classpath resource(s) from {} to {} to permit Docker to bind", (Object)hostPath, (Object)tmpLocation);
                this.copyFromJarToLocation(jarFile, entry, internalPath, tmpLocation);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to process JAR file when extracting classpath resource: " + hostPath, e);
        }
        this.deleteOnExit(tmpLocation.toPath());
        try {
            return tmpLocation.getCanonicalPath();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private File createTempDirectory() {
        try {
            if (SystemUtils.IS_OS_MAC) {
                return Files.createTempDirectory(Paths.get(OS_MAC_TMP_DIR, new String[0]), TESTCONTAINERS_TMP_DIR_PREFIX, new FileAttribute[0]).toFile();
            }
            return Files.createTempDirectory(TESTCONTAINERS_TMP_DIR_PREFIX, new FileAttribute[0]).toFile();
        }
        catch (IOException e) {
            return new File(TESTCONTAINERS_TMP_DIR_PREFIX + Base58.randomString(5));
        }
    }

    private void copyFromJarToLocation(JarFile jarFile, JarEntry entry, String fromRoot, File toRoot) throws IOException {
        String destinationName = entry.getName().replaceFirst(fromRoot, "");
        File newFile = new File(toRoot, destinationName);
        log.debug("Copying resource {} from JAR file {}", (Object)fromRoot, (Object)jarFile.getName());
        if (!entry.isDirectory()) {
            Path parent = newFile.getAbsoluteFile().toPath().getParent();
            parent.toFile().mkdirs();
            newFile.deleteOnExit();
            try (InputStream is = jarFile.getInputStream(entry);){
                Files.copy(is, newFile.toPath(), new CopyOption[0]);
            }
            catch (IOException e) {
                log.error("Failed to extract classpath resource " + entry.getName() + " from JAR file " + jarFile.getName(), e);
                throw e;
            }
        }
    }

    private void deleteOnExit(Path path) {
        Runtime.getRuntime().addShutdownHook(new Thread(DockerClientFactory.TESTCONTAINERS_THREAD_GROUP, () -> PathUtils.recursiveDeleteDir(path)));
    }

    @Override
    public void transferTo(TarArchiveOutputStream outputStream, String destinationPathInTar) {
        this.recursiveTar(destinationPathInTar, this.getResolvedPath(), this.getResolvedPath(), outputStream);
    }

    private void recursiveTar(String entryFilename, String rootPath, String itemPath, TarArchiveOutputStream tarArchive) {
        try {
            File sourceFile = new File(itemPath).getCanonicalFile();
            File sourceRootFile = new File(rootPath).getCanonicalFile();
            String relativePathToSourceFile = sourceRootFile.toPath().relativize(sourceFile.toPath()).toFile().toString();
            String tarEntryFilename = relativePathToSourceFile.isEmpty() ? entryFilename : entryFilename + "/" + relativePathToSourceFile;
            TarArchiveEntry tarEntry = new TarArchiveEntry(sourceFile, tarEntryFilename.replaceAll("^/", ""));
            tarEntry.setMode(this.getUnixFileMode(itemPath));
            tarArchive.putArchiveEntry(tarEntry);
            if (sourceFile.isFile()) {
                Files.copy(sourceFile.toPath(), tarArchive);
            }
            tarArchive.closeArchiveEntry();
            File[] children = sourceFile.listFiles();
            if (children != null) {
                for (File child : children) {
                    this.recursiveTar(entryFilename, sourceRootFile.getCanonicalPath(), child.getCanonicalPath(), tarArchive);
                }
            }
        }
        catch (IOException e) {
            log.error("Error when copying TAR file entry: {}", (Object)itemPath, (Object)e);
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public long getSize() {
        File file = new File(this.getResolvedPath());
        if (file.isFile()) {
            return file.length();
        }
        return 0L;
    }

    @Override
    public String getDescription() {
        return this.getResolvedPath();
    }

    @Override
    public void updateChecksum(Checksum checksum) {
        File file = new File(this.getResolvedPath());
        this.checksumFile(file, checksum);
    }

    private void checksumFile(File file, Checksum checksum) {
        block15: {
            Path path = file.toPath();
            checksum.update(MountableFile.getUnixFileMode(path));
            if (file.isDirectory()) {
                try (Stream<Path> stream = Files.walk(path, new FileVisitOption[0]);){
                    stream.filter(it -> it != path).forEach(it -> this.checksumFile(it.toFile(), checksum));
                    break block15;
                }
            }
            FileUtils.checksum(file, checksum);
        }
    }

    @Override
    public int getFileMode() {
        return this.getUnixFileMode(this.getResolvedPath());
    }

    private int getUnixFileMode(String pathAsString) {
        Path path = Paths.get(pathAsString, new String[0]);
        if (this.forcedFileMode != null) {
            return this.getModeValue(path);
        }
        return MountableFile.getUnixFileMode(path);
    }

    public static int getUnixFileMode(Path path) {
        try {
            int unixMode = (Integer)Files.readAttributes(path, "unix:mode", new LinkOption[0]).get("mode");
            if ("OS/390".equals(SystemUtils.OS_NAME) || "z/OS".equals(SystemUtils.OS_NAME) || "zOS".equals(SystemUtils.OS_NAME)) {
                unixMode = (int)((long)unixMode & 0x1FFFFFL);
                unixMode |= Files.isDirectory(path, new LinkOption[0]) ? 16384 : 32768;
            }
            return unixMode;
        }
        catch (IOException | UnsupportedOperationException e) {
            int mode = 33188;
            if (Files.isDirectory(path, new LinkOption[0])) {
                mode = 16877;
            } else if (Files.isExecutable(path)) {
                mode |= 0x49;
            }
            return mode;
        }
    }

    private int getModeValue(Path path) {
        int result = Files.isDirectory(path, new LinkOption[0]) ? 16384 : 32768;
        return result | this.forcedFileMode;
    }

    MountableFile(String path, Integer forcedFileMode) {
        this.path = path;
        this.forcedFileMode = forcedFileMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getResolvedPath() {
        Object value = this.resolvedPath.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = this.resolvedPath;
            synchronized (atomicReference) {
                value = this.resolvedPath.get();
                if (value == null) {
                    String actualValue = this.resolvePath();
                    value = actualValue == null ? this.resolvedPath : actualValue;
                    this.resolvedPath.set(value);
                }
            }
        }
        return (String)(value == this.resolvedPath ? null : value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getFilesystemPath() {
        Object value = this.filesystemPath.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = this.filesystemPath;
            synchronized (atomicReference) {
                value = this.filesystemPath.get();
                if (value == null) {
                    String actualValue = this.resolveFilesystemPath();
                    value = actualValue == null ? this.filesystemPath : actualValue;
                    this.filesystemPath.set(value);
                }
            }
        }
        return (String)(value == this.filesystemPath ? null : value);
    }
}

