/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.context.expressions;

import io.micronaut.context.ApplicationContext;
import io.micronaut.context.BeanContext;
import io.micronaut.context.BeanRegistration;
import io.micronaut.context.BeanResolutionContext;
import io.micronaut.context.DefaultBeanContext;
import io.micronaut.context.DefaultBeanResolutionContext;
import io.micronaut.context.exceptions.ExpressionEvaluationException;
import io.micronaut.context.expressions.ConfigurableExpressionEvaluationContext;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.type.Argument;
import io.micronaut.inject.BeanDefinition;
import io.micronaut.inject.BeanIdentifier;

@Internal
public final class DefaultExpressionEvaluationContext
implements ConfigurableExpressionEvaluationContext {
    private final Object thisObject;
    private final Object[] args;
    private final BeanContext beanContext;
    private final BeanDefinition<?> owningBean;
    private BeanResolutionContext resolutionContext;

    public DefaultExpressionEvaluationContext() {
        this(null, null, null, null);
    }

    public DefaultExpressionEvaluationContext(@Nullable Object thisObject, @Nullable Object[] args, @Nullable BeanContext beanContext, @Nullable BeanDefinition<?> owningBean) {
        this.thisObject = thisObject;
        this.args = args;
        this.beanContext = beanContext;
        this.owningBean = owningBean;
    }

    @Override
    public ConfigurableExpressionEvaluationContext withArguments(Object thisObject, Object[] args) {
        DefaultExpressionEvaluationContext evaluationContext = new DefaultExpressionEvaluationContext(thisObject, args, this.beanContext, this.owningBean);
        evaluationContext.resolutionContext = this.resolutionContext;
        return evaluationContext;
    }

    @Override
    public ConfigurableExpressionEvaluationContext withOwningBean(BeanDefinition<?> beanDefinition) {
        DefaultExpressionEvaluationContext evaluationContext = new DefaultExpressionEvaluationContext(this.thisObject, this.args, this.beanContext, beanDefinition);
        evaluationContext.resolutionContext = this.resolutionContext;
        return evaluationContext;
    }

    @Override
    public ConfigurableExpressionEvaluationContext withBeanContext(BeanContext beanContext) {
        DefaultExpressionEvaluationContext evaluationContext = new DefaultExpressionEvaluationContext(this.thisObject, this.args, beanContext, this.owningBean);
        evaluationContext.resolutionContext = this.resolutionContext;
        return evaluationContext;
    }

    @Override
    public Object getThis() {
        if (this.thisObject == null) {
            throw new ExpressionEvaluationException("Current resolve 'this' within expression context. Expressions that resolve 'this' should be executed in a non-static context.");
        }
        return this.thisObject;
    }

    @Override
    public Object getArgument(int index) {
        if (this.args == null || this.args.length == 0 || this.args.length < index) {
            throw new ExpressionEvaluationException("Can not obtain argument at index [" + index + "] since arguments are not provided");
        }
        return this.args[index];
    }

    @Override
    public String getProperty(String name) {
        BeanContext beanContext;
        if (this.beanContext == null || !((beanContext = this.beanContext) instanceof ApplicationContext)) {
            throw new ExpressionEvaluationException("Can not obtain environment property [" + name + "] since application context is not set");
        }
        ApplicationContext applicationContext = (ApplicationContext)beanContext;
        return applicationContext.getProperty(name, String.class).orElse(null);
    }

    @Override
    public <T> T getBean(Class<T> type) {
        if (this.beanContext == null) {
            throw new ExpressionEvaluationException("Can not obtain bean of type [" + type + "] since bean context is not set");
        }
        BeanContext beanContext = this.beanContext;
        if (beanContext instanceof DefaultBeanContext) {
            DefaultBeanContext defaultBeanContext = (DefaultBeanContext)beanContext;
            if (this.resolutionContext == null && this.owningBean != null) {
                this.resolutionContext = new DefaultBeanResolutionContext((BeanContext)defaultBeanContext, this.owningBean);
            }
            if (this.resolutionContext != null) {
                BeanIdentifier identifier = BeanIdentifier.of(type.getName());
                BeanRegistration existing = this.resolutionContext.getInFlightBean(identifier);
                if (existing != null) {
                    return existing.getBean();
                }
                Argument<T> t = Argument.of(type);
                try (BeanResolutionContext.Path ignored = this.resolutionContext.getPath().pushAnnotationResolve(this.owningBean, t);){
                    BeanRegistration<T> beanRegistration = defaultBeanContext.getBeanRegistration(this.resolutionContext, t, null);
                    this.resolutionContext.addInFlightBean(identifier, beanRegistration);
                    T t2 = beanRegistration.getBean();
                    return t2;
                }
            }
        }
        return this.beanContext.getBean(type);
    }

    @Override
    public void close() throws Exception {
        if (this.resolutionContext != null) {
            this.resolutionContext.close();
            this.resolutionContext = null;
        }
    }
}

