/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.util;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;

@Internal
public final class CopyOnWriteMap<K, V>
extends AbstractMap<K, V>
implements ConcurrentMap<K, V> {
    static final int EVICTION_BATCH = 16;
    private static final Map EMPTY = new HashMap();
    private final int maxSizeWithEvictionMargin;
    private volatile Map<? extends K, ? extends V> actual = EMPTY;

    public CopyOnWriteMap(int maxSize) {
        int maxSizeWithEvictionMargin = maxSize + 16;
        if (maxSizeWithEvictionMargin < 0) {
            maxSizeWithEvictionMargin = Integer.MAX_VALUE;
        }
        this.maxSizeWithEvictionMargin = maxSizeWithEvictionMargin;
    }

    @Override
    @NonNull
    public Set<Map.Entry<K, V>> entrySet() {
        return new EntrySet();
    }

    @Override
    public V get(Object key) {
        return this.actual.get(key);
    }

    @Override
    public V getOrDefault(Object key, V defaultValue) {
        return this.actual.getOrDefault(key, defaultValue);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.actual.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.actual.containsValue(value);
    }

    @Override
    public int size() {
        return this.actual.size();
    }

    @Override
    public synchronized void clear() {
        this.actual = EMPTY;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        this.update(map -> {
            map.putAll(m);
            return null;
        });
    }

    @Override
    public V remove(Object key) {
        return (V)this.update(m -> m.remove(key));
    }

    @Override
    public int hashCode() {
        return this.actual.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        return this.actual.equals(o);
    }

    @Override
    public String toString() {
        return this.actual.toString();
    }

    @Override
    public void forEach(BiConsumer<? super K, ? super V> action) {
        this.actual.forEach(action);
    }

    private synchronized <R> R update(Function<Map<K, V>, R> updater) {
        HashMap<K, V> next = new HashMap<K, V>(this.actual);
        R ret = updater.apply(next);
        int newSize = next.size();
        if (newSize >= this.maxSizeWithEvictionMargin) {
            CopyOnWriteMap.evict(next, 16);
        }
        this.actual = next;
        return ret;
    }

    public static void evict(Map<?, ?> map, int numToEvict) {
        int size = map.size();
        BitSet toRemove = new BitSet(size);
        for (int i = 0; i < numToEvict; ++i) {
            CopyOnWriteMap.setUnset(toRemove, ThreadLocalRandom.current().nextInt(size - i));
        }
        Iterator<Map.Entry<?, ?>> iterator = map.entrySet().iterator();
        for (int i = 0; i < size; ++i) {
            iterator.next();
            if (!toRemove.get(i)) continue;
            iterator.remove();
        }
    }

    static void setUnset(BitSet set, int index) {
        int nextI;
        int i = 0;
        while ((nextI = set.nextSetBit(i)) != -1 && nextI <= index) {
            i = nextI + 1;
            ++index;
        }
        set.set(index);
    }

    @Override
    public V put(K key, V value) {
        return (V)this.update(m -> m.put(key, value));
    }

    @Override
    public boolean remove(@NonNull Object key, Object value) {
        return this.update(m -> m.remove(key, value));
    }

    @Override
    public boolean replace(@NonNull K key, @NonNull V oldValue, @NonNull V newValue) {
        return this.update(m -> m.replace(key, oldValue, newValue));
    }

    @Override
    public void replaceAll(BiFunction<? super K, ? super V, ? extends V> function) {
        this.update(m -> {
            m.replaceAll(function);
            return null;
        });
    }

    @Override
    public V computeIfAbsent(K key, @NonNull Function<? super K, ? extends V> mappingFunction) {
        V present = this.get(key);
        if (present != null) {
            return present;
        }
        return (V)this.update(m -> m.computeIfAbsent(key, mappingFunction));
    }

    @Override
    public V computeIfPresent(K key, @NonNull BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        return (V)this.update(m -> m.computeIfPresent(key, remappingFunction));
    }

    @Override
    public V compute(K key, @NonNull BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        return (V)this.update(m -> m.compute(key, remappingFunction));
    }

    @Override
    public V merge(K key, @NonNull V value, @NonNull BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        return (V)this.update(m -> m.merge(key, value, remappingFunction));
    }

    @Override
    public V putIfAbsent(@NonNull K key, V value) {
        return (V)this.update(m -> m.putIfAbsent(key, value));
    }

    @Override
    public V replace(@NonNull K key, @NonNull V value) {
        return (V)this.update(m -> m.replace(key, value));
    }

    private class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntrySetIterator();
        }

        @Override
        public int size() {
            return CopyOnWriteMap.this.actual.size();
        }
    }

    private class EntryImpl
    implements Map.Entry<K, V> {
        private final Map.Entry<? extends K, ? extends V> entry;

        public EntryImpl(Map.Entry<? extends K, ? extends V> entry) {
            this.entry = entry;
        }

        @Override
        public K getKey() {
            return this.entry.getKey();
        }

        @Override
        public V getValue() {
            return this.entry.getValue();
        }

        @Override
        public V setValue(V value) {
            return CopyOnWriteMap.this.put(this.entry.getKey(), value);
        }
    }

    private class EntrySetIterator
    implements Iterator<Map.Entry<K, V>> {
        final Iterator<? extends Map.Entry<? extends K, ? extends V>> itr;
        K lastKey;

        private EntrySetIterator() {
            this.itr = CopyOnWriteMap.this.actual.entrySet().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.itr.hasNext();
        }

        @Override
        public Map.Entry<K, V> next() {
            Map.Entry e = this.itr.next();
            this.lastKey = e.getKey();
            return new EntryImpl(e);
        }

        @Override
        public void remove() {
            CopyOnWriteMap.this.remove(this.lastKey);
        }
    }
}

