/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty;

import io.micronaut.core.annotation.Internal;
import io.micronaut.http.exceptions.ContentLengthExceededException;
import io.micronaut.http.server.HttpServerConfiguration;
import io.micronaut.http.server.netty.HttpContentProcessor;
import io.micronaut.http.server.netty.NettyHttpRequest;
import io.netty.buffer.ByteBufHolder;
import io.netty.util.ReferenceCountUtil;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicLong;

@Internal
public abstract class AbstractHttpContentProcessor
implements HttpContentProcessor {
    protected final NettyHttpRequest<?> nettyHttpRequest;
    protected final long advertisedLength;
    protected final long requestMaxSize;
    protected final AtomicLong receivedLength = new AtomicLong();
    protected final HttpServerConfiguration configuration;

    public AbstractHttpContentProcessor(NettyHttpRequest<?> nettyHttpRequest, HttpServerConfiguration configuration) {
        this.nettyHttpRequest = nettyHttpRequest;
        this.advertisedLength = nettyHttpRequest.getContentLength();
        this.requestMaxSize = configuration.getMaxRequestSize();
        this.configuration = configuration;
    }

    protected abstract void onData(ByteBufHolder var1, Collection<Object> var2) throws Throwable;

    @Override
    public void add(ByteBufHolder message, Collection<Object> out) throws Throwable {
        long receivedLength = this.receivedLength.addAndGet(message.content().readableBytes());
        ReferenceCountUtil.touch(message);
        if (this.advertisedLength > this.requestMaxSize) {
            this.fireExceedsLength(this.advertisedLength, this.requestMaxSize, message);
        } else if (receivedLength > this.requestMaxSize) {
            this.fireExceedsLength(receivedLength, this.requestMaxSize, message);
        } else {
            this.onData(message, out);
        }
    }

    protected void fireExceedsLength(long receivedLength, long expected, ByteBufHolder message) {
        message.release();
        throw new ContentLengthExceededException(expected, receivedLength);
    }
}

