/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject.annotation;

import io.micronaut.context.BeanContext;
import io.micronaut.context.BeanContextConfigurable;
import io.micronaut.context.BeanDefinitionAware;
import io.micronaut.context.expressions.ConfigurableExpressionEvaluationContext;
import io.micronaut.context.expressions.DefaultExpressionEvaluationContext;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.inject.BeanDefinition;
import io.micronaut.inject.annotation.EvaluatedAnnotationValue;
import io.micronaut.inject.annotation.MappingAnnotationMetadataDelegate;
import java.lang.annotation.Annotation;

public final class EvaluatedAnnotationMetadata
extends MappingAnnotationMetadataDelegate
implements BeanContextConfigurable,
BeanDefinitionAware {
    private final AnnotationMetadata delegateAnnotationMetadata;
    private ConfigurableExpressionEvaluationContext evaluationContext;

    private EvaluatedAnnotationMetadata(AnnotationMetadata targetMetadata, ConfigurableExpressionEvaluationContext evaluationContext) {
        this.delegateAnnotationMetadata = targetMetadata;
        this.evaluationContext = evaluationContext;
    }

    public EvaluatedAnnotationMetadata withArguments(@Nullable Object thisObject, Object[] args) {
        return new EvaluatedAnnotationMetadata(this.delegateAnnotationMetadata, this.evaluationContext.withArguments(thisObject, args));
    }

    @Override
    public void configure(BeanContext context) {
        this.evaluationContext = this.evaluationContext.withBeanContext(context);
    }

    @Override
    public void setBeanDefinition(BeanDefinition<?> beanDefinition) {
        this.evaluationContext = this.evaluationContext.withOwningBean(beanDefinition);
    }

    public static AnnotationMetadata wrapIfNecessary(AnnotationMetadata targetMetadata) {
        if (targetMetadata == null) {
            return null;
        }
        if (targetMetadata instanceof EvaluatedAnnotationMetadata) {
            return targetMetadata;
        }
        if (targetMetadata.hasEvaluatedExpressions()) {
            return new EvaluatedAnnotationMetadata(targetMetadata, new DefaultExpressionEvaluationContext());
        }
        return targetMetadata;
    }

    @Override
    public boolean hasEvaluatedExpressions() {
        return true;
    }

    @Override
    public AnnotationMetadata getAnnotationMetadata() {
        return this.delegateAnnotationMetadata;
    }

    @Override
    public <T extends Annotation> AnnotationValue<T> mapAnnotationValue(AnnotationValue<T> av) {
        return new EvaluatedAnnotationValue<T>(av, this.evaluationContext);
    }
}

