/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.management.endpoint.info.impl;

import io.micronaut.context.annotation.Requires;
import io.micronaut.context.env.EmptyPropertySource;
import io.micronaut.context.env.PropertySource;
import io.micronaut.context.env.PropertySourcePropertyResolver;
import io.micronaut.core.convert.format.MapFormat;
import io.micronaut.core.naming.conventions.StringConvention;
import io.micronaut.management.endpoint.info.InfoAggregator;
import io.micronaut.management.endpoint.info.InfoEndpoint;
import io.micronaut.management.endpoint.info.InfoSource;
import jakarta.inject.Singleton;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Map;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Singleton
@Requires(beans={InfoEndpoint.class})
public class ReactiveInfoAggregator
implements InfoAggregator<Map<String, Object>> {
    @Override
    public Publisher<Map<String, Object>> aggregate(InfoSource[] sources) {
        return this.aggregateResults(sources).collectList().map(list -> {
            PropertySourcePropertyResolver resolver = new PropertySourcePropertyResolver();
            list.stream().sorted((e1, e2) -> Integer.compare((Integer)e2.getKey(), (Integer)e1.getKey())).forEach(entry -> resolver.addPropertySource((PropertySource)entry.getValue()));
            return resolver.getAllProperties(StringConvention.RAW, MapFormat.MapTransformation.NESTED);
        }).flux();
    }

    protected Flux<Map.Entry<Integer, PropertySource>> aggregateResults(InfoSource[] sources) {
        ArrayList<Flux<Map.Entry>> publishers = new ArrayList<Flux<Map.Entry>>(sources.length);
        for (int i = 0; i < sources.length; ++i) {
            int index = i;
            Mono<Map.Entry> single = Mono.from(sources[i].getSource()).defaultIfEmpty(new EmptyPropertySource()).map(source -> new AbstractMap.SimpleEntry<Integer, PropertySource>(index, (PropertySource)source));
            publishers.add(single.flux());
        }
        return Flux.merge(publishers);
    }
}

