/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.serializers;

import io.micronaut.core.type.Argument;
import io.micronaut.serde.Serializer;
import io.micronaut.serde.exceptions.SerdeException;
import io.micronaut.serde.support.serializers.CustomizedIterableSerializer;
import io.micronaut.serde.support.serializers.RuntimeValueIterableSerializer;
import io.micronaut.serde.support.serializers.StringIterableSerializer;
import io.micronaut.serde.util.CustomizableSerializer;
import jakarta.inject.Singleton;

@Singleton
final class IterableSerializer<T>
implements CustomizableSerializer<Iterable<T>> {
    IterableSerializer() {
    }

    @Override
    public Serializer<Iterable<T>> createSpecific(Serializer.EncoderContext context, Argument<? extends Iterable<T>> type) throws SerdeException {
        Argument[] generics = type.getTypeParameters();
        if (generics.length > 0) {
            Argument generic = generics[0];
            if (generic.getType() == String.class) {
                return StringIterableSerializer.INSTANCE;
            }
            Serializer componentSerializer = context.findSerializer(generic).createSpecific(context, generic);
            return new CustomizedIterableSerializer(generic, componentSerializer);
        }
        return new RuntimeValueIterableSerializer();
    }
}

