/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.containers;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.model.Container;
import java.io.File;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.NonNull;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.DockerClientFactory;
import org.testcontainers.containers.ComposeServiceWaitStrategyTarget;
import org.testcontainers.containers.ContainerLaunchException;
import org.testcontainers.containers.ContainerState;
import org.testcontainers.containers.ContainerisedDockerCompose;
import org.testcontainers.containers.DockerCompose;
import org.testcontainers.containers.DockerComposeFiles;
import org.testcontainers.containers.FailureDetectingExternalResource;
import org.testcontainers.containers.FutureContainer;
import org.testcontainers.containers.LocalDockerCompose;
import org.testcontainers.containers.SocatContainer;
import org.testcontainers.containers.output.OutputFrame;
import org.testcontainers.containers.output.Slf4jLogConsumer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitAllStrategy;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.images.RemoteDockerImage;
import org.testcontainers.lifecycle.Startable;
import org.testcontainers.shaded.com.google.common.annotations.VisibleForTesting;
import org.testcontainers.shaded.com.google.common.base.Preconditions;
import org.testcontainers.shaded.com.google.common.base.Strings;
import org.testcontainers.shaded.com.google.common.collect.Sets;
import org.testcontainers.utility.Base58;
import org.testcontainers.utility.DockerImageName;
import org.testcontainers.utility.ImageNameSubstitutor;
import org.testcontainers.utility.LogUtils;
import org.testcontainers.utility.ResourceReaper;

public class DockerComposeContainer<SELF extends DockerComposeContainer<SELF>>
extends FailureDetectingExternalResource
implements Startable {
    private static final Logger log = LoggerFactory.getLogger(DockerComposeContainer.class);
    private final String identifier;
    private final List<File> composeFiles;
    private DockerComposeFiles dockerComposeFiles;
    private final Map<String, Integer> scalingPreferences = new HashMap<String, Integer>();
    private DockerClient dockerClient;
    private boolean localCompose;
    private boolean pull = true;
    private boolean build = false;
    private Set<String> options = new HashSet<String>();
    private boolean tailChildContainers;
    private String project;
    private final AtomicInteger nextAmbassadorPort = new AtomicInteger(2000);
    private final Map<String, Map<Integer, Integer>> ambassadorPortMappings = new ConcurrentHashMap<String, Map<Integer, Integer>>();
    private final Map<String, ComposeServiceWaitStrategyTarget> serviceInstanceMap = new ConcurrentHashMap<String, ComposeServiceWaitStrategyTarget>();
    private final Map<String, WaitAllStrategy> waitStrategyMap = new ConcurrentHashMap<String, WaitAllStrategy>();
    private Duration startupTimeout = Duration.ofMinutes(30L);
    private final SocatContainer ambassadorContainer = new SocatContainer();
    private final Map<String, List<Consumer<OutputFrame>>> logConsumers = new ConcurrentHashMap<String, List<Consumer<OutputFrame>>>();
    private static final Object MUTEX = new Object();
    private List<String> services = new ArrayList<String>();
    private Map<String, String> env = new HashMap<String, String>();
    private RemoveImages removeImages;
    private boolean removeVolumes = true;

    @Deprecated
    public DockerComposeContainer(File composeFile, String identifier) {
        this(identifier, composeFile);
    }

    public DockerComposeContainer(File ... composeFiles) {
        this(Arrays.asList(composeFiles));
    }

    public DockerComposeContainer(List<File> composeFiles) {
        this(Base58.randomString(6).toLowerCase(), composeFiles);
    }

    public DockerComposeContainer(String identifier, File ... composeFiles) {
        this(identifier, Arrays.asList(composeFiles));
    }

    public DockerComposeContainer(String identifier, List<File> composeFiles) {
        this.composeFiles = composeFiles;
        this.dockerComposeFiles = new DockerComposeFiles(composeFiles);
        this.identifier = identifier.toLowerCase();
        this.project = this.randomProjectId();
        this.dockerClient = DockerClientFactory.lazyClient();
    }

    @Override
    @Deprecated
    public Statement apply(Statement base, Description description) {
        return super.apply(base, description);
    }

    @Override
    @Deprecated
    public void starting(Description description) {
        this.start();
    }

    @Override
    @Deprecated
    protected void succeeded(Description description) {
    }

    @Override
    @Deprecated
    protected void failed(Throwable e, Description description) {
    }

    @Override
    @Deprecated
    public void finished(Description description) {
        this.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        Object object = MUTEX;
        synchronized (object) {
            this.registerContainersForShutdown();
            if (this.pull) {
                try {
                    this.pullImages();
                }
                catch (ContainerLaunchException e) {
                    log.warn("Exception while pulling images, using local images if available", e);
                }
            }
            this.createServices();
            this.startAmbassadorContainers();
            this.waitUntilServiceStarted();
        }
    }

    private void pullImages() {
        this.dockerComposeFiles.getDependencyImages().forEach(imageName -> {
            try {
                log.info("Preemptively checking local images for '{}', referenced via a compose file or transitive Dockerfile. If not available, it will be pulled.", imageName);
                new RemoteDockerImage(DockerImageName.parse(imageName)).withImageNameSubstitutor(ImageNameSubstitutor.noop()).get();
            }
            catch (Exception e) {
                log.warn("Unable to pre-fetch an image ({}) depended upon by Docker Compose build - startup will continue but may fail. Exception message was: {}", imageName, (Object)e.getMessage());
            }
        });
    }

    public SELF withServices(String ... services) {
        if (services == null) {
            throw new NullPointerException("services is marked non-null but is null");
        }
        this.services = Arrays.asList(services);
        return this.self();
    }

    private void createServices() {
        String serviceNameArgs = Stream.concat(this.services.stream(), this.scalingPreferences.keySet().stream()).distinct().collect(Collectors.joining(" "));
        String scalingOptions = this.scalingPreferences.entrySet().stream().map(entry -> "--scale " + (String)entry.getKey() + "=" + entry.getValue()).distinct().collect(Collectors.joining(" "));
        String command = this.optionsAsString() + "up -d";
        if (this.build) {
            command = command + " --build";
        }
        if (!Strings.isNullOrEmpty(scalingOptions)) {
            command = command + " " + scalingOptions;
        }
        if (!Strings.isNullOrEmpty(serviceNameArgs)) {
            command = command + " " + serviceNameArgs;
        }
        this.runWithCompose(command);
    }

    private String optionsAsString() {
        String optionsString = this.options.stream().collect(Collectors.joining(" "));
        if (optionsString.length() != 0) {
            return optionsString + " ";
        }
        return "";
    }

    private void waitUntilServiceStarted() {
        this.listChildContainers().forEach(this::createServiceInstance);
        Set<String> servicesToWaitFor = this.waitStrategyMap.keySet();
        Set<String> instantiatedServices = this.serviceInstanceMap.keySet();
        Sets.SetView<String> missingServiceInstances = Sets.difference(servicesToWaitFor, instantiatedServices);
        if (!missingServiceInstances.isEmpty()) {
            throw new IllegalStateException("Services named " + missingServiceInstances + " do not exist, but wait conditions have been defined for them. This might mean that you misspelled the service name when defining the wait condition.");
        }
        this.serviceInstanceMap.forEach(this::waitUntilServiceStarted);
    }

    private void createServiceInstance(Container container) {
        String serviceName = this.getServiceNameFromContainer(container);
        ComposeServiceWaitStrategyTarget containerInstance = new ComposeServiceWaitStrategyTarget(this.dockerClient, container, this.ambassadorContainer, this.ambassadorPortMappings.getOrDefault(serviceName, new HashMap()));
        String containerId = containerInstance.getContainerId();
        if (this.tailChildContainers) {
            this.followLogs(containerId, new Slf4jLogConsumer(log).withPrefix(container.getNames()[0]));
        }
        this.logConsumers.getOrDefault(serviceName, Collections.emptyList()).forEach(consumer -> this.followLogs(containerId, (Consumer<OutputFrame>)consumer));
        this.serviceInstanceMap.putIfAbsent(serviceName, containerInstance);
    }

    private void waitUntilServiceStarted(String serviceName, ComposeServiceWaitStrategyTarget serviceInstance) {
        WaitAllStrategy waitAllStrategy = this.waitStrategyMap.get(serviceName);
        if (waitAllStrategy != null) {
            waitAllStrategy.waitUntilReady(serviceInstance);
        }
    }

    private String getServiceNameFromContainer(Container container) {
        String containerName = container.getLabels().get("com.docker.compose.service");
        String containerNumber = container.getLabels().get("com.docker.compose.container-number");
        return String.format("%s_%s", containerName, containerNumber);
    }

    private void runWithCompose(String cmd) {
        Preconditions.checkNotNull(this.composeFiles);
        Preconditions.checkArgument(!this.composeFiles.isEmpty(), "No docker compose file have been provided");
        DockerCompose dockerCompose = this.localCompose ? new LocalDockerCompose(this.composeFiles, this.project) : new ContainerisedDockerCompose(this.composeFiles, this.project);
        dockerCompose.withCommand(cmd).withEnv(this.env).invoke();
    }

    private void registerContainersForShutdown() {
        ResourceReaper.instance().registerLabelsFilterForCleanup(Collections.singletonMap("com.docker.compose.project", this.project));
    }

    @VisibleForTesting
    List<Container> listChildContainers() {
        return ((List)this.dockerClient.listContainersCmd().withShowAll(true).exec()).stream().filter(container -> Arrays.stream(container.getNames()).anyMatch(name -> name.startsWith("/" + this.project))).collect(Collectors.toList());
    }

    private void startAmbassadorContainers() {
        if (!this.ambassadorPortMappings.isEmpty()) {
            this.ambassadorContainer.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        Object object = MUTEX;
        synchronized (object) {
            try {
                this.ambassadorContainer.stop();
                String cmd = "down";
                if (this.removeVolumes) {
                    cmd = cmd + " -v";
                }
                if (this.removeImages != null) {
                    cmd = cmd + " --rmi " + this.removeImages.dockerRemoveImagesType();
                }
                this.runWithCompose(cmd);
            }
            finally {
                this.project = this.randomProjectId();
            }
        }
    }

    public SELF withExposedService(String serviceName, int servicePort) {
        return this.withExposedService(serviceName, servicePort, Wait.defaultWaitStrategy());
    }

    public DockerComposeContainer withExposedService(String serviceName, int instance, int servicePort) {
        return this.withExposedService(serviceName + "_" + instance, servicePort);
    }

    public DockerComposeContainer withExposedService(String serviceName, int instance, int servicePort, WaitStrategy waitStrategy) {
        return this.withExposedService(serviceName + "_" + instance, servicePort, waitStrategy);
    }

    public SELF withExposedService(String serviceName, int servicePort, @NonNull WaitStrategy waitStrategy) {
        if (waitStrategy == null) {
            throw new NullPointerException("waitStrategy is marked non-null but is null");
        }
        String serviceInstanceName = this.getServiceInstanceName(serviceName);
        int ambassadorPort = this.nextAmbassadorPort.getAndIncrement();
        this.ambassadorPortMappings.computeIfAbsent(serviceInstanceName, __ -> new ConcurrentHashMap()).put(servicePort, ambassadorPort);
        this.ambassadorContainer.withTarget(ambassadorPort, serviceInstanceName, servicePort);
        this.ambassadorContainer.addLink(new FutureContainer(this.project + "_" + serviceInstanceName), serviceInstanceName);
        this.addWaitStrategy(serviceInstanceName, waitStrategy);
        return this.self();
    }

    private String getServiceInstanceName(String serviceName) {
        String serviceInstanceName = serviceName;
        if (!serviceInstanceName.matches(".*_[0-9]+")) {
            serviceInstanceName = serviceInstanceName + "_1";
        }
        return serviceInstanceName;
    }

    private void addWaitStrategy(String serviceInstanceName, @NonNull WaitStrategy waitStrategy) {
        if (waitStrategy == null) {
            throw new NullPointerException("waitStrategy is marked non-null but is null");
        }
        WaitAllStrategy waitAllStrategy = this.waitStrategyMap.computeIfAbsent(serviceInstanceName, __ -> new WaitAllStrategy(WaitAllStrategy.Mode.WITH_MAXIMUM_OUTER_TIMEOUT).withStartupTimeout(this.startupTimeout));
        waitAllStrategy.withStrategy(waitStrategy);
    }

    public SELF waitingFor(String serviceName, @NonNull WaitStrategy waitStrategy) {
        if (waitStrategy == null) {
            throw new NullPointerException("waitStrategy is marked non-null but is null");
        }
        String serviceInstanceName = this.getServiceInstanceName(serviceName);
        this.addWaitStrategy(serviceInstanceName, waitStrategy);
        return this.self();
    }

    public String getServiceHost(String serviceName, Integer servicePort) {
        return this.ambassadorContainer.getHost();
    }

    public Integer getServicePort(String serviceName, Integer servicePort) {
        Map<Integer, Integer> portMap = this.ambassadorPortMappings.get(this.getServiceInstanceName(serviceName));
        if (portMap == null) {
            throw new IllegalArgumentException("Could not get a port for '" + serviceName + "'. Testcontainers does not have an exposed port configured for '" + serviceName + "'. To fix, please ensure that the service '" + serviceName + "' has ports exposed using .withExposedService(...)");
        }
        return this.ambassadorContainer.getMappedPort(portMap.get(servicePort));
    }

    public SELF withScaledService(String serviceBaseName, int numInstances) {
        this.scalingPreferences.put(serviceBaseName, numInstances);
        return this.self();
    }

    public SELF withEnv(String key, String value) {
        this.env.put(key, value);
        return this.self();
    }

    public SELF withEnv(Map<String, String> env) {
        env.forEach(this.env::put);
        return this.self();
    }

    public SELF withLocalCompose(boolean localCompose) {
        this.localCompose = localCompose;
        return this.self();
    }

    public SELF withPull(boolean pull) {
        this.pull = pull;
        return this.self();
    }

    public SELF withTailChildContainers(boolean tailChildContainers) {
        this.tailChildContainers = tailChildContainers;
        return this.self();
    }

    public SELF withLogConsumer(String serviceName, Consumer<OutputFrame> consumer) {
        String serviceInstanceName = this.getServiceInstanceName(serviceName);
        List consumers = this.logConsumers.getOrDefault(serviceInstanceName, new ArrayList());
        consumers.add(consumer);
        this.logConsumers.putIfAbsent(serviceInstanceName, consumers);
        return this.self();
    }

    public SELF withBuild(boolean build) {
        this.build = build;
        return this.self();
    }

    public SELF withOptions(String ... options) {
        this.options = new HashSet<String>(Arrays.asList(options));
        return this.self();
    }

    public SELF withRemoveImages(RemoveImages removeImages) {
        this.removeImages = removeImages;
        return this.self();
    }

    public SELF withRemoveVolumes(boolean removeVolumes) {
        this.removeVolumes = removeVolumes;
        return this.self();
    }

    public SELF withStartupTimeout(Duration startupTimeout) {
        this.startupTimeout = startupTimeout;
        return this.self();
    }

    public Optional<ContainerState> getContainerByServiceName(String serviceName) {
        String serviceInstantName = this.getServiceInstanceName(serviceName);
        return Optional.ofNullable(this.serviceInstanceMap.get(serviceInstantName));
    }

    private void followLogs(String containerId, Consumer<OutputFrame> consumer) {
        LogUtils.followOutput(this.dockerClient, containerId, consumer);
    }

    private SELF self() {
        return (SELF)this;
    }

    private String randomProjectId() {
        return this.identifier + Base58.randomString(6).toLowerCase();
    }

    public static enum RemoveImages {
        ALL("all"),
        LOCAL("local");

        private final String dockerRemoveImagesType;

        private RemoveImages(String dockerRemoveImagesType) {
            this.dockerRemoveImagesType = dockerRemoveImagesType;
        }

        public String dockerRemoveImagesType() {
            return this.dockerRemoveImagesType;
        }
    }
}

