/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.containers;

import java.io.File;
import java.io.FileInputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.images.ParsedDockerfile;
import org.testcontainers.shaded.com.google.common.annotations.VisibleForTesting;
import org.testcontainers.shaded.com.google.common.collect.Sets;
import org.testcontainers.shaded.org.apache.commons.io.FileUtils;
import org.testcontainers.shaded.org.yaml.snakeyaml.Yaml;

class ParsedDockerComposeFile {
    private static final Logger log = LoggerFactory.getLogger(ParsedDockerComposeFile.class);
    private final Map<String, Object> composeFileContent;
    private final String composeFileName;
    private final File composeFile;
    private Map<String, Set<String>> serviceNameToImageNames = new HashMap<String, Set<String>>();

    ParsedDockerComposeFile(File composeFile) {
        Yaml yaml = new Yaml();
        try (FileInputStream fileInputStream = FileUtils.openInputStream(composeFile);){
            this.composeFileContent = (Map)yaml.load(fileInputStream);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to parse YAML file from " + composeFile.getAbsolutePath(), e);
        }
        this.composeFileName = composeFile.getAbsolutePath();
        this.composeFile = composeFile;
        this.parseAndValidate();
    }

    @VisibleForTesting
    ParsedDockerComposeFile(Map<String, Object> testContent) {
        this.composeFileContent = testContent;
        this.composeFileName = "";
        this.composeFile = new File(".");
        this.parseAndValidate();
    }

    private void parseAndValidate() {
        Map servicesMap;
        if (this.composeFileContent.containsKey("version")) {
            Object servicesElement;
            if ("2.0".equals(this.composeFileContent.get("version"))) {
                log.warn("Testcontainers may not be able to clean up networks spawned using Docker Compose v2.0 files. Please see https://github.com/testcontainers/moby-ryuk/issues/2, and specify 'version: \"2.1\"' or higher in {}", (Object)this.composeFileName);
            }
            if ((servicesElement = this.composeFileContent.get("services")) == null) {
                log.debug("Compose file {} has an unknown format: 'version' is set but 'services' is not defined", (Object)this.composeFileName);
                return;
            }
            if (!(servicesElement instanceof Map)) {
                log.debug("Compose file {} has an unknown format: 'services' is not Map", (Object)this.composeFileName);
                return;
            }
            servicesMap = (Map)servicesElement;
        } else {
            servicesMap = this.composeFileContent;
        }
        for (Map.Entry<String, Object> entry : servicesMap.entrySet()) {
            String serviceName = entry.getKey();
            Object serviceDefinition = entry.getValue();
            if (!(serviceDefinition instanceof Map)) {
                log.debug("Compose file {} has an unknown format: service '{}' is not Map", (Object)this.composeFileName, (Object)serviceName);
                break;
            }
            Map serviceDefinitionMap = (Map)serviceDefinition;
            this.validateNoContainerNameSpecified(serviceName, serviceDefinitionMap);
            this.findServiceImageName(serviceName, serviceDefinitionMap);
            this.findImageNamesInDockerfile(serviceName, serviceDefinitionMap);
        }
    }

    private void validateNoContainerNameSpecified(String serviceName, Map serviceDefinitionMap) {
        if (serviceDefinitionMap.containsKey("container_name")) {
            throw new IllegalStateException(String.format("Compose file %s has 'container_name' property set for service '%s' but this property is not supported by Testcontainers, consider removing it", this.composeFileName, serviceName));
        }
    }

    private void findServiceImageName(String serviceName, Map serviceDefinitionMap) {
        if (serviceDefinitionMap.containsKey("image") && serviceDefinitionMap.get("image") instanceof String) {
            String imageName = (String)serviceDefinitionMap.get("image");
            log.debug("Resolved dependency image for Docker Compose in {}: {}", (Object)this.composeFileName, (Object)imageName);
            this.serviceNameToImageNames.put(serviceName, Sets.newHashSet(imageName));
        }
    }

    private void findImageNamesInDockerfile(String serviceName, Map serviceDefinitionMap) {
        Set<String> resolvedImageNames;
        Object buildNode = serviceDefinitionMap.get("build");
        Path dockerfilePath = null;
        if (buildNode instanceof Map) {
            Map buildElement = (Map)buildNode;
            Object dockerfileRelativePath = buildElement.get("dockerfile");
            Object contextRelativePath = buildElement.get("context");
            if (dockerfileRelativePath instanceof String && contextRelativePath instanceof String) {
                dockerfilePath = this.composeFile.getAbsoluteFile().getParentFile().toPath().resolve((String)contextRelativePath).resolve((String)dockerfileRelativePath).normalize();
            }
        } else if (buildNode instanceof String) {
            dockerfilePath = this.composeFile.getAbsoluteFile().getParentFile().toPath().resolve((String)buildNode).resolve("./Dockerfile").normalize();
        }
        if (dockerfilePath != null && Files.exists(dockerfilePath, new LinkOption[0]) && !(resolvedImageNames = new ParsedDockerfile(dockerfilePath).getDependencyImageNames()).isEmpty()) {
            log.debug("Resolved Dockerfile dependency images for Docker Compose in {} -> {}: {}", this.composeFileName, dockerfilePath, resolvedImageNames);
            this.serviceNameToImageNames.put(serviceName, resolvedImageNames);
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ParsedDockerComposeFile)) {
            return false;
        }
        ParsedDockerComposeFile other = (ParsedDockerComposeFile)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<String, Object> this$composeFileContent = this.composeFileContent;
        Map<String, Object> other$composeFileContent = other.composeFileContent;
        if (this$composeFileContent == null ? other$composeFileContent != null : !((Object)this$composeFileContent).equals(other$composeFileContent)) {
            return false;
        }
        String this$composeFileName = this.composeFileName;
        String other$composeFileName = other.composeFileName;
        if (this$composeFileName == null ? other$composeFileName != null : !this$composeFileName.equals(other$composeFileName)) {
            return false;
        }
        File this$composeFile = this.composeFile;
        File other$composeFile = other.composeFile;
        if (this$composeFile == null ? other$composeFile != null : !((Object)this$composeFile).equals(other$composeFile)) {
            return false;
        }
        Map<String, Set<String>> this$serviceNameToImageNames = this.getServiceNameToImageNames();
        Map<String, Set<String>> other$serviceNameToImageNames = other.getServiceNameToImageNames();
        return !(this$serviceNameToImageNames == null ? other$serviceNameToImageNames != null : !((Object)this$serviceNameToImageNames).equals(other$serviceNameToImageNames));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ParsedDockerComposeFile;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, Object> $composeFileContent = this.composeFileContent;
        result = result * 59 + ($composeFileContent == null ? 43 : ((Object)$composeFileContent).hashCode());
        String $composeFileName = this.composeFileName;
        result = result * 59 + ($composeFileName == null ? 43 : $composeFileName.hashCode());
        File $composeFile = this.composeFile;
        result = result * 59 + ($composeFile == null ? 43 : ((Object)$composeFile).hashCode());
        Map<String, Set<String>> $serviceNameToImageNames = this.getServiceNameToImageNames();
        result = result * 59 + ($serviceNameToImageNames == null ? 43 : ((Object)$serviceNameToImageNames).hashCode());
        return result;
    }

    public Map<String, Set<String>> getServiceNameToImageNames() {
        return this.serviceNameToImageNames;
    }
}

