/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.context;

import io.micronaut.context.AbstractBeanContextConditional;
import io.micronaut.context.AbstractBeanResolutionContext;
import io.micronaut.context.AnnotationProcessorListener;
import io.micronaut.context.ApplicationContext;
import io.micronaut.context.BeanContext;
import io.micronaut.context.BeanContextConfiguration;
import io.micronaut.context.BeanDefinitionDelegate;
import io.micronaut.context.BeanDefinitionRegistry;
import io.micronaut.context.BeanDisposingRegistration;
import io.micronaut.context.BeanLocator;
import io.micronaut.context.BeanRegistration;
import io.micronaut.context.BeanResolutionContext;
import io.micronaut.context.DefaultCustomScopeRegistry;
import io.micronaut.context.DisabledBean;
import io.micronaut.context.ExecutionHandleLocator;
import io.micronaut.context.InitializableBeanContext;
import io.micronaut.context.LifeCycle;
import io.micronaut.context.Qualifier;
import io.micronaut.context.RuntimeBeanDefinition;
import io.micronaut.context.SingletonScope;
import io.micronaut.context.annotation.ConfigurationReader;
import io.micronaut.context.annotation.Context;
import io.micronaut.context.annotation.DefaultImplementation;
import io.micronaut.context.annotation.Executable;
import io.micronaut.context.annotation.Infrastructure;
import io.micronaut.context.annotation.Parallel;
import io.micronaut.context.annotation.Primary;
import io.micronaut.context.annotation.Prototype;
import io.micronaut.context.annotation.Replaces;
import io.micronaut.context.annotation.Secondary;
import io.micronaut.context.condition.ConditionContext;
import io.micronaut.context.condition.Failure;
import io.micronaut.context.env.CachedEnvironment;
import io.micronaut.context.env.PropertyPlaceholderResolver;
import io.micronaut.context.event.ApplicationEventListener;
import io.micronaut.context.event.ApplicationEventPublisher;
import io.micronaut.context.event.BeanCreatedEvent;
import io.micronaut.context.event.BeanCreatedEventListener;
import io.micronaut.context.event.BeanDestroyedEvent;
import io.micronaut.context.event.BeanDestroyedEventListener;
import io.micronaut.context.event.BeanInitializedEventListener;
import io.micronaut.context.event.BeanPreDestroyEvent;
import io.micronaut.context.event.BeanPreDestroyEventListener;
import io.micronaut.context.event.ShutdownEvent;
import io.micronaut.context.event.StartupEvent;
import io.micronaut.context.exceptions.BeanContextException;
import io.micronaut.context.exceptions.BeanCreationException;
import io.micronaut.context.exceptions.BeanDestructionException;
import io.micronaut.context.exceptions.BeanInstantiationException;
import io.micronaut.context.exceptions.ConfigurationException;
import io.micronaut.context.exceptions.DependencyInjectionException;
import io.micronaut.context.exceptions.DisabledBeanException;
import io.micronaut.context.exceptions.NoSuchBeanException;
import io.micronaut.context.exceptions.NonUniqueBeanException;
import io.micronaut.context.processor.AnnotationProcessor;
import io.micronaut.context.processor.ExecutableMethodProcessor;
import io.micronaut.context.scope.BeanCreationContext;
import io.micronaut.context.scope.CreatedBean;
import io.micronaut.context.scope.CustomScope;
import io.micronaut.context.scope.CustomScopeRegistry;
import io.micronaut.core.annotation.AnnotationClassValue;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationMetadataProvider;
import io.micronaut.core.annotation.AnnotationMetadataResolver;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Indexes;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.annotation.Order;
import io.micronaut.core.convert.MutableConversionService;
import io.micronaut.core.convert.TypeConverter;
import io.micronaut.core.convert.TypeConverterRegistrar;
import io.micronaut.core.convert.value.MutableConvertibleValues;
import io.micronaut.core.io.ResourceLoader;
import io.micronaut.core.io.scan.ClassPathResourceLoader;
import io.micronaut.core.io.service.SoftServiceLoader;
import io.micronaut.core.naming.NameResolver;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.core.naming.Named;
import io.micronaut.core.order.OrderUtil;
import io.micronaut.core.order.Ordered;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.ReturnType;
import io.micronaut.core.type.UnsafeExecutable;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.core.util.clhm.ConcurrentLinkedHashMap;
import io.micronaut.core.value.PropertyResolver;
import io.micronaut.core.value.ValueResolver;
import io.micronaut.inject.AdvisedBeanType;
import io.micronaut.inject.BeanConfiguration;
import io.micronaut.inject.BeanDefinition;
import io.micronaut.inject.BeanDefinitionMethodReference;
import io.micronaut.inject.BeanDefinitionReference;
import io.micronaut.inject.BeanIdentifier;
import io.micronaut.inject.BeanType;
import io.micronaut.inject.DisposableBeanDefinition;
import io.micronaut.inject.ExecutableMethod;
import io.micronaut.inject.InitializingBeanDefinition;
import io.micronaut.inject.InjectableBeanDefinition;
import io.micronaut.inject.InjectionPoint;
import io.micronaut.inject.InstantiatableBeanDefinition;
import io.micronaut.inject.MethodExecutionHandle;
import io.micronaut.inject.ParametrizedInstantiatableBeanDefinition;
import io.micronaut.inject.ProxyBeanDefinition;
import io.micronaut.inject.QualifiedBeanType;
import io.micronaut.inject.UnsafeExecutionHandle;
import io.micronaut.inject.ValidatedBeanDefinition;
import io.micronaut.inject.provider.AbstractProviderDefinition;
import io.micronaut.inject.proxy.InterceptedBeanProxy;
import io.micronaut.inject.qualifiers.AnyQualifier;
import io.micronaut.inject.qualifiers.Qualified;
import io.micronaut.inject.qualifiers.Qualifiers;
import io.micronaut.inject.validation.BeanDefinitionValidator;
import jakarta.inject.Singleton;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultBeanContext
implements InitializableBeanContext {
    protected static final Logger LOG = LoggerFactory.getLogger(DefaultBeanContext.class);
    protected static final Logger LOG_LIFECYCLE = LoggerFactory.getLogger(DefaultBeanContext.class.getPackage().getName() + ".lifecycle");
    private static final String SCOPED_PROXY_ANN = "io.micronaut.runtime.context.scope.ScopedProxy";
    private static final String INTRODUCTION_TYPE = "io.micronaut.aop.Introduction";
    private static final String ADAPTER_TYPE = "io.micronaut.aop.Adapter";
    private static final String PARALLEL_TYPE = Parallel.class.getName();
    private static final String INDEXES_TYPE = Indexes.class.getName();
    private static final String REPLACES_ANN = Replaces.class.getName();
    private static final Comparator<BeanRegistration<?>> BEAN_REGISTRATION_COMPARATOR = (o1, o2) -> {
        int order1 = OrderUtil.getOrder(o1.getBeanDefinition(), o1.getBean());
        int order2 = OrderUtil.getOrder(o2.getBeanDefinition(), o2.getBean());
        return Integer.compare(order1, order2);
    };
    private static final String MSG_COULD_NOT_BE_LOADED = "] could not be loaded: ";
    public static final String MSG_BEAN_DEFINITION = "Bean definition [";
    protected final AtomicBoolean running = new AtomicBoolean(false);
    protected final AtomicBoolean initializing = new AtomicBoolean(false);
    protected final AtomicBoolean terminating = new AtomicBoolean(false);
    final Map<BeanIdentifier, BeanRegistration<?>> singlesInCreation = new ConcurrentHashMap(5);
    private final SingletonScope singletonScope = new SingletonScope();
    private final BeanContextConfiguration beanContextConfiguration;
    private final Collection<BeanDefinitionProducer> beanDefinitionsClasses = new CopyOnWriteArrayList<BeanDefinitionProducer>();
    private final Collection<BeanDefinitionProducer> proxyTargetBeans = new CopyOnWriteArrayList<BeanDefinitionProducer>();
    private final Map<BeanKey<?>, BeanDefinitionProducer> disabledBeans = new ConcurrentHashMap(20);
    private final Map<String, List<String>> disabledConfigurations = new ConcurrentHashMap<String, List<String>>(5);
    private final Map<String, BeanConfiguration> beanConfigurations = new HashMap<String, BeanConfiguration>(10);
    private final Map<BeanKey, Boolean> containsBeanCache = new ConcurrentHashMap<BeanKey, Boolean>(30);
    private final Map<CharSequence, Object> attributes = Collections.synchronizedMap(new HashMap(5));
    private final Map<BeanKey, CollectionHolder> singletonBeanRegistrations = new ConcurrentHashMap<BeanKey, CollectionHolder>(50);
    private final Map<BeanCandidateKey, Optional<BeanDefinition>> beanConcreteCandidateCache = new ConcurrentLinkedHashMap.Builder().maximumWeightedCapacity(30L).build();
    private final Map<BeanCandidateKey, Optional<BeanDefinition>> beanProxyTargetCache = new ConcurrentLinkedHashMap.Builder().maximumWeightedCapacity(30L).build();
    private final Map<Argument, Collection<BeanDefinition>> beanCandidateCache = new ConcurrentLinkedHashMap.Builder().maximumWeightedCapacity(30L).build();
    private final Map<Class<?>, Collection<BeanDefinitionProducer>> beanIndex = new ConcurrentHashMap(12);
    private final ClassLoader classLoader;
    private final Set<Class<?>> thisInterfaces = CollectionUtils.setOf(BeanDefinitionRegistry.class, BeanContext.class, AnnotationMetadataResolver.class, BeanLocator.class, ExecutionHandleLocator.class, ApplicationContext.class, PropertyResolver.class, ValueResolver.class, PropertyPlaceholderResolver.class);
    private final Set<Class<?>> indexedTypes = CollectionUtils.setOf(ResourceLoader.class, TypeConverter.class, TypeConverterRegistrar.class, ApplicationEventListener.class, BeanCreatedEventListener.class, BeanInitializedEventListener.class);
    private final CustomScopeRegistry customScopeRegistry;
    private final String[] eagerInitStereotypes;
    private final boolean eagerInitStereotypesPresent;
    private final boolean eagerInitSingletons;
    private BeanDefinitionValidator beanValidator;
    private List<BeanDefinitionReference> beanDefinitionReferences;
    private List<BeanConfiguration> beanConfigurationsList;
    List<Map.Entry<Class<?>, ListenersSupplier<BeanInitializedEventListener>>> beanInitializedEventListeners;
    private List<Map.Entry<Class<?>, ListenersSupplier<BeanCreatedEventListener>>> beanCreationEventListeners;
    private List<Map.Entry<Class<?>, ListenersSupplier<BeanPreDestroyEventListener>>> beanPreDestroyEventListeners;
    private List<Map.Entry<Class<?>, ListenersSupplier<BeanDestroyedEventListener>>> beanDestroyedEventListeners;
    @Nullable
    private MutableConversionService conversionService;

    public DefaultBeanContext() {
        this(BeanContext.class.getClassLoader());
    }

    public DefaultBeanContext(final @NonNull ClassLoader classLoader) {
        this(new BeanContextConfiguration(){

            @Override
            @NonNull
            public ClassLoader getClassLoader() {
                ArgumentUtils.requireNonNull("classLoader", classLoader);
                return classLoader;
            }
        });
    }

    public DefaultBeanContext(final @NonNull ClassPathResourceLoader resourceLoader) {
        this(new BeanContextConfiguration(){

            @Override
            @NonNull
            public ClassLoader getClassLoader() {
                ArgumentUtils.requireNonNull("resourceLoader", resourceLoader);
                return resourceLoader.getClassLoader();
            }
        });
    }

    public DefaultBeanContext(@NonNull BeanContextConfiguration contextConfiguration) {
        ArgumentUtils.requireNonNull("contextConfiguration", contextConfiguration);
        System.setProperty("micronaut.classloader.logging", "true");
        this.classLoader = contextConfiguration.getClassLoader();
        this.customScopeRegistry = Objects.requireNonNull(this.createCustomScopeRegistry(), "Scope registry cannot be null");
        Set<Class<? extends Annotation>> eagerInitAnnotated = contextConfiguration.getEagerInitAnnotated();
        ArrayList<String> configuredEagerSingletonAnnotations = new ArrayList<String>(eagerInitAnnotated.size());
        for (Class<? extends Annotation> ann : eagerInitAnnotated) {
            configuredEagerSingletonAnnotations.add(ann.getName());
        }
        this.eagerInitStereotypes = configuredEagerSingletonAnnotations.toArray(new String[0]);
        this.eagerInitStereotypesPresent = !configuredEagerSingletonAnnotations.isEmpty();
        this.eagerInitSingletons = this.eagerInitStereotypesPresent && (configuredEagerSingletonAnnotations.contains("jakarta.inject.Singleton") || configuredEagerSingletonAnnotations.contains(Singleton.class.getName()));
        this.beanContextConfiguration = contextConfiguration;
    }

    @NonNull
    protected CustomScopeRegistry createCustomScopeRegistry() {
        return new DefaultCustomScopeRegistry(this);
    }

    @Internal
    @NonNull
    CustomScopeRegistry getCustomScopeRegistry() {
        return this.customScopeRegistry;
    }

    @Override
    public boolean isRunning() {
        return this.running.get() && !this.initializing.get();
    }

    @Override
    public synchronized BeanContext start() {
        if (!this.isRunning()) {
            if (this.initializing.compareAndSet(false, true)) {
                String activeConfigurations;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Starting BeanContext");
                }
                this.registerConversionService();
                this.finalizeConfiguration();
                if (LOG.isDebugEnabled() && StringUtils.isNotEmpty(activeConfigurations = this.beanConfigurations.values().stream().filter(config -> config.isEnabled(this)).map(BeanConfiguration::getName).collect(Collectors.joining(",")))) {
                    LOG.debug("Loaded active configurations: {}", (Object)activeConfigurations);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("BeanContext Started.");
                }
                this.publishEvent(new StartupEvent(this));
            }
            this.running.set(true);
            this.initializing.set(false);
        }
        return this;
    }

    protected void registerConversionService() {
        this.conversionService = MutableConversionService.create();
        this.registerSingleton(MutableConversionService.class, this.conversionService, (Qualifier)null, false);
    }

    @Internal
    <C extends AnnotationMetadataProvider> void trackDisabledComponent(@NonNull ConditionContext<C> conditionContext) {
        C component = conditionContext.getComponent();
        List<String> reasons = conditionContext.getFailures().stream().map(Failure::getMessage).toList();
        if (component instanceof QualifiedBeanType) {
            QualifiedBeanType beanType = (QualifiedBeanType)component;
            try {
                Argument argument = beanType.getGenericBeanType();
                Qualifier declaredQualifier = beanType.getDeclaredQualifier();
                this.disabledBeans.put(new BeanKey(argument, declaredQualifier), new BeanDefinitionProducer(new DisabledBean(argument, declaredQualifier, reasons)));
            }
            catch (Exception | NoClassDefFoundError throwable) {}
        } else if (component instanceof BeanConfiguration) {
            BeanConfiguration configuration = (BeanConfiguration)component;
            this.disabledConfigurations.put(configuration.getName(), reasons);
        }
    }

    @Override
    public synchronized BeanContext stop() {
        if (this.terminating.compareAndSet(false, true) && this.isRunning()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Stopping BeanContext");
            }
            this.publishEvent(new ShutdownEvent(this));
            this.attributes.clear();
            List<BeanRegistration> objects = this.topologicalSort(this.singletonScope.getBeanRegistrations());
            Map<Boolean, List<BeanRegistration>> result = objects.stream().collect(Collectors.groupingBy(br -> br.bean != null && (br.bean instanceof BeanPreDestroyEventListener || br.bean instanceof BeanDestroyedEventListener)));
            List<BeanRegistration> listeners = result.get(true);
            if (listeners != null) {
                objects.clear();
                objects.addAll((Collection<BeanRegistration>)result.get(false));
                objects.addAll(listeners);
            }
            HashSet<Integer> processed = new HashSet<Integer>();
            for (BeanRegistration beanRegistration : objects) {
                Object bean = beanRegistration.bean;
                int sysId = System.identityHashCode(bean);
                if (processed.contains(sysId)) continue;
                if (LOG_LIFECYCLE.isDebugEnabled()) {
                    LOG_LIFECYCLE.debug("Destroying bean [{}] with identifier [{}]", bean, (Object)beanRegistration.identifier);
                }
                processed.add(sysId);
                try {
                    this.destroyBean(beanRegistration);
                }
                catch (BeanDestructionException e) {
                    if (!LOG.isErrorEnabled()) continue;
                    LOG.error(e.getMessage(), e);
                }
            }
            this.singlesInCreation.clear();
            this.singletonBeanRegistrations.clear();
            this.beanConcreteCandidateCache.clear();
            this.beanCandidateCache.clear();
            this.beanProxyTargetCache.clear();
            this.containsBeanCache.clear();
            this.beanConfigurations.clear();
            this.disabledConfigurations.clear();
            this.singletonScope.clear();
            this.beanDefinitionsClasses.clear();
            this.disabledBeans.clear();
            this.proxyTargetBeans.clear();
            this.attributes.clear();
            this.beanIndex.clear();
            this.beanConfigurationsList = null;
            this.beanDefinitionReferences = null;
            this.beanInitializedEventListeners = null;
            this.beanCreationEventListeners = null;
            this.beanPreDestroyEventListeners = null;
            this.beanDestroyedEventListeners = null;
            this.conversionService = null;
            this.terminating.set(false);
            this.running.set(false);
        }
        return this;
    }

    @Override
    @NonNull
    public AnnotationMetadata resolveMetadata(Class<?> type) {
        if (type == null) {
            return AnnotationMetadata.EMPTY_METADATA;
        }
        return this.findBeanDefinitionInternal(Argument.of(type), null).map(AnnotationMetadataProvider::getAnnotationMetadata).orElse(AnnotationMetadata.EMPTY_METADATA);
    }

    @Override
    public <T> Optional<T> refreshBean(@Nullable BeanIdentifier identifier) {
        if (identifier == null) {
            return Optional.empty();
        }
        BeanRegistration<BeanIdentifier> beanRegistration = this.singletonScope.findBeanRegistration(identifier);
        if (beanRegistration != null) {
            this.refreshBean(beanRegistration);
            return Optional.of(beanRegistration.bean);
        }
        return Optional.empty();
    }

    @Override
    public <T> void refreshBean(@NonNull BeanRegistration<T> beanRegistration) {
        BeanDefinition<T> definition;
        Objects.requireNonNull(beanRegistration, "BeanRegistration cannot be null");
        Object bean = beanRegistration.bean;
        if (bean != null && (definition = beanRegistration.definition()) instanceof InjectableBeanDefinition) {
            InjectableBeanDefinition injectableBeanDefinition = (InjectableBeanDefinition)definition;
            injectableBeanDefinition.inject(this, bean);
        }
    }

    @Override
    public Collection<BeanRegistration<?>> getActiveBeanRegistrations(Qualifier<?> qualifier) {
        if (qualifier == null) {
            return Collections.emptyList();
        }
        return this.singletonScope.getBeanRegistrations(qualifier);
    }

    @Override
    public <T> Collection<BeanRegistration<T>> getActiveBeanRegistrations(Class<T> beanType) {
        if (beanType == null) {
            return Collections.emptyList();
        }
        return this.singletonScope.getBeanRegistrations(beanType);
    }

    @Override
    public <T> Collection<BeanRegistration<T>> getBeanRegistrations(Class<T> beanType) {
        if (beanType == null) {
            return Collections.emptyList();
        }
        return this.getBeanRegistrations(null, Argument.of(beanType), null);
    }

    @Override
    public <T> BeanRegistration<T> getBeanRegistration(Class<T> beanType, Qualifier<T> qualifier) {
        return this.getBeanRegistration(null, Argument.of(beanType), qualifier);
    }

    @Override
    public <T> Collection<BeanRegistration<T>> getBeanRegistrations(Class<T> beanType, Qualifier<T> qualifier) {
        if (beanType == null) {
            return Collections.emptyList();
        }
        return this.getBeanRegistrations(null, Argument.of(beanType), null);
    }

    @Override
    public <T> Collection<BeanRegistration<T>> getBeanRegistrations(Argument<T> beanType, Qualifier<T> qualifier) {
        return this.getBeanRegistrations(null, Objects.requireNonNull(beanType, "Bean type cannot be null"), qualifier);
    }

    @Override
    public <T> BeanRegistration<T> getBeanRegistration(Argument<T> beanType, Qualifier<T> qualifier) {
        return this.getBeanRegistration(null, Objects.requireNonNull(beanType, "Bean type cannot be null"), qualifier);
    }

    @Override
    public <T> BeanRegistration<T> getBeanRegistration(BeanDefinition<T> beanDefinition) {
        return this.resolveBeanRegistration(null, beanDefinition);
    }

    @Override
    public <T> Optional<BeanRegistration<T>> findBeanRegistration(T bean) {
        if (bean == null) {
            return Optional.empty();
        }
        BeanRegistration<T> beanRegistration = this.singletonScope.findBeanRegistration(bean);
        if (beanRegistration != null) {
            return Optional.of(beanRegistration);
        }
        return this.customScopeRegistry.findBeanRegistration(bean);
    }

    @Override
    public <T, R> Optional<MethodExecutionHandle<T, R>> findExecutionHandle(Class<T> beanType, String method, Class<?> ... arguments) {
        return this.findExecutionHandle(beanType, null, method, arguments);
    }

    @Override
    public MethodExecutionHandle<?, Object> createExecutionHandle(BeanDefinition<?> beanDefinition, ExecutableMethod<Object, ?> method) {
        if (method instanceof UnsafeExecutable) {
            return new BeanContextUnsafeExecutionHandle(method, beanDefinition, (UnsafeExecutable)((Object)method));
        }
        return new BeanContextExecutionHandle(method, beanDefinition);
    }

    @Override
    public <T, R> Optional<MethodExecutionHandle<T, R>> findExecutionHandle(Class<T> beanType, Qualifier<?> q, String method, Class<?> ... arguments) {
        Qualifier<?> qualifier = q;
        Optional<BeanDefinition<T>> foundBean = this.findBeanDefinition(beanType, qualifier);
        if (foundBean.isEmpty()) {
            return Optional.empty();
        }
        BeanDefinition<T> beanDefinition = foundBean.get();
        Optional foundMethod = beanDefinition.findMethod(method, arguments);
        if (foundMethod.isEmpty()) {
            foundMethod = beanDefinition.findPossibleMethods(method).findFirst().filter(m -> {
                Class<?>[] argTypes = m.getArgumentTypes();
                if (argTypes.length == arguments.length) {
                    for (int i = 0; i < argTypes.length; ++i) {
                        if (arguments[i].isAssignableFrom(argTypes[i])) continue;
                        return false;
                    }
                    return true;
                }
                return false;
            });
        }
        return foundMethod.map(executableMethod -> new BeanExecutionHandle(this, beanType, qualifier, executableMethod));
    }

    @Override
    public <T, R> Optional<ExecutableMethod<T, R>> findExecutableMethod(Class<T> beanType, String method, Class<?>[] arguments) {
        if (beanType == null) {
            return Optional.empty();
        }
        Collection<BeanDefinition<T>> definitions = this.getBeanDefinitions(beanType);
        if (definitions.isEmpty()) {
            return Optional.empty();
        }
        BeanDefinition<T> beanDefinition = definitions.iterator().next();
        Optional foundMethod = beanDefinition.findMethod(method, arguments);
        if (foundMethod.isPresent()) {
            return foundMethod;
        }
        return beanDefinition.findPossibleMethods(method).findFirst();
    }

    @Override
    public <T, R> Optional<MethodExecutionHandle<T, R>> findExecutionHandle(T bean, String method, Class<?>[] arguments) {
        Optional<BeanDefinition<?>> foundBean;
        if (bean != null && (foundBean = this.findBeanDefinition(bean.getClass())).isPresent()) {
            BeanDefinition<?> beanDefinition = foundBean.get();
            Optional foundMethod = beanDefinition.findMethod(method, arguments);
            if (foundMethod.isPresent()) {
                return foundMethod.map(executableMethod -> new ObjectExecutionHandle(bean, executableMethod));
            }
            return beanDefinition.findPossibleMethods(method).findFirst().map(executableMethod -> new ObjectExecutionHandle(bean, executableMethod));
        }
        return Optional.empty();
    }

    @Override
    public <T> BeanContext registerSingleton(@NonNull Class<T> type, @NonNull T singleton, Qualifier<T> qualifier, boolean inject) {
        BeanDefinition beanDefinition;
        this.purgeCacheForBeanInstance(singleton);
        if (inject && this.running.get()) {
            beanDefinition = this.findConcreteCandidate(null, Argument.of(type), qualifier, false).orElse(null);
            if (beanDefinition == null) {
                this.purgeCacheForBeanInstance(singleton);
            }
        } else {
            beanDefinition = null;
        }
        if (beanDefinition != null && !(beanDefinition instanceof RuntimeBeanDefinition) && beanDefinition.getBeanType().isInstance(singleton)) {
            try (BeanResolutionContext context = this.newResolutionContext(beanDefinition, null);){
                if (inject) {
                    this.doInjectAndInitialize(context, singleton, beanDefinition);
                }
                BeanKey key = new BeanKey(beanDefinition.asArgument(), qualifier);
                this.singletonScope.registerSingletonBean(BeanRegistration.of(this, key, beanDefinition, singleton), qualifier);
            }
        } else {
            RuntimeBeanDefinition<Object> runtimeBeanDefinition = RuntimeBeanDefinition.builder(type, () -> singleton).singleton(true).qualifier(qualifier).build();
            BeanRegistration<Object> registration = BeanRegistration.of(this, new BeanKey<Object>(runtimeBeanDefinition, qualifier), runtimeBeanDefinition, singleton);
            this.singletonScope.registerSingletonBean(registration, qualifier);
            this.registerBeanDefinition(runtimeBeanDefinition);
        }
        return this;
    }

    private <T> void purgeCacheForBeanInstance(T singleton) {
        this.beanCandidateCache.entrySet().removeIf(entry -> ((Argument)entry.getKey()).isInstance(singleton));
        this.beanConcreteCandidateCache.entrySet().removeIf(entry -> ((BeanCandidateKey)entry.getKey()).beanType.isInstance(singleton));
        this.singletonBeanRegistrations.entrySet().removeIf(entry -> ((BeanKey)entry.getKey()).beanType.isInstance(singleton));
        this.containsBeanCache.entrySet().removeIf(entry -> ((BeanKey)entry.getKey()).beanType.isInstance(singleton));
    }

    @NonNull
    final BeanResolutionContext newResolutionContext(BeanDefinition<?> beanDefinition, @Nullable BeanResolutionContext currentContext) {
        if (currentContext == null) {
            return new SingletonBeanResolutionContext(beanDefinition);
        }
        return currentContext;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    public BeanDefinitionValidator getBeanValidator() {
        if (this.beanValidator == null) {
            this.beanValidator = this.findBean(BeanDefinitionValidator.class).orElse(BeanDefinitionValidator.DEFAULT);
        }
        return this.beanValidator;
    }

    @Override
    public Optional<BeanConfiguration> findBeanConfiguration(String configurationName) {
        BeanConfiguration configuration = this.beanConfigurations.get(configurationName);
        if (configuration != null) {
            return Optional.of(configuration);
        }
        return Optional.empty();
    }

    @Override
    public <T> BeanDefinition<T> getBeanDefinition(Argument<T> beanType, Qualifier<T> qualifier) {
        return this.findBeanDefinition(beanType, qualifier).orElseThrow(() -> this.newNoSuchBeanException(null, beanType, qualifier, null));
    }

    @Override
    public <T> Optional<BeanDefinition<T>> findBeanDefinition(Argument<T> beanType, Qualifier<T> qualifier) {
        BeanDefinition<T> beanDefinition = this.singletonScope.findCachedSingletonBeanDefinition(beanType, qualifier);
        if (beanDefinition != null) {
            return Optional.of(beanDefinition);
        }
        return this.findConcreteCandidate(null, beanType, qualifier, true);
    }

    private <T> Optional<BeanDefinition<T>> findBeanDefinitionInternal(Argument<T> beanType, Qualifier<T> qualifier) {
        return this.findConcreteCandidate(null, beanType, qualifier, false);
    }

    @Override
    public <T> Optional<BeanDefinition<T>> findBeanDefinition(Class<T> beanType, Qualifier<T> qualifier) {
        return this.findBeanDefinition(Argument.of(beanType), qualifier);
    }

    @Override
    public <T> Collection<BeanDefinition<T>> getBeanDefinitions(Class<T> beanType) {
        return this.getBeanDefinitions(Argument.of(beanType));
    }

    @Override
    public <T> Collection<BeanDefinition<T>> getBeanDefinitions(Argument<T> beanType) {
        Objects.requireNonNull(beanType, "Bean type cannot be null");
        Collection<BeanDefinition<T>> candidates = this.findBeanCandidatesInternal(null, beanType);
        return Collections.unmodifiableCollection(candidates);
    }

    @Override
    public <T> Collection<BeanDefinition<T>> getBeanDefinitions(Class<T> beanType, Qualifier<T> qualifier) {
        Objects.requireNonNull(beanType, "Bean type cannot be null");
        return this.getBeanDefinitions(Argument.of(beanType), qualifier);
    }

    @Override
    public <T> Collection<BeanDefinition<T>> getBeanDefinitions(Argument<T> beanType, Qualifier<T> qualifier) {
        Objects.requireNonNull(beanType, "Bean type cannot be null");
        Collection<BeanDefinition<T>> candidates = this.findBeanCandidatesInternal(null, beanType);
        if (qualifier != null) {
            candidates = qualifier.reduce(beanType.getType(), candidates.stream()).toList();
        }
        return Collections.unmodifiableCollection(candidates);
    }

    @Override
    public <T> boolean containsBean(@NonNull Class<T> beanType, Qualifier<T> qualifier) {
        return this.containsBean(Argument.of(beanType), qualifier);
    }

    @Override
    public <T> boolean containsBean(Argument<T> beanType, Qualifier<T> qualifier) {
        ArgumentUtils.requireNonNull("beanType", beanType);
        BeanKey<T> beanKey = new BeanKey<T>(beanType, qualifier);
        if (this.containsBeanCache.containsKey(beanKey)) {
            return this.containsBeanCache.get(beanKey);
        }
        boolean result = this.singletonScope.containsBean(beanType, qualifier) || this.isCandidatePresent(beanKey.beanType, qualifier);
        this.containsBeanCache.put(beanKey, result);
        return result;
    }

    @Override
    @NonNull
    public <T> T getBean(@NonNull Class<T> beanType, @Nullable Qualifier<T> qualifier) {
        Objects.requireNonNull(beanType, "Bean type cannot be null");
        return this.getBean(Argument.of(beanType), qualifier);
    }

    @Override
    @NonNull
    public <T> T getBean(@NonNull Class<T> beanType) {
        Objects.requireNonNull(beanType, "Bean type cannot be null");
        return this.getBean(Argument.of(beanType), null);
    }

    @Override
    @NonNull
    public <T> T getBean(@NonNull Argument<T> beanType, @Nullable Qualifier<T> qualifier) {
        Objects.requireNonNull(beanType, "Bean type cannot be null");
        try {
            return this.getBean(null, beanType, qualifier);
        }
        catch (DisabledBeanException e) {
            if (AbstractBeanContextConditional.ConditionLog.LOG.isDebugEnabled()) {
                AbstractBeanContextConditional.ConditionLog.LOG.debug("Bean of type [{}] disabled for reason: {}", (Object)beanType.getSimpleName(), (Object)e.getMessage());
            }
            throw this.newNoSuchBeanException(null, beanType, qualifier, "Bean of type [" + beanType.getTypeString(true) + "] disabled for reason: " + e.getMessage());
        }
    }

    @Override
    public <T> Optional<T> findBean(Class<T> beanType, Qualifier<T> qualifier) {
        return this.findBean(null, beanType, qualifier);
    }

    @Override
    public <T> Optional<T> findBean(Argument<T> beanType, Qualifier<T> qualifier) {
        return this.findBean(null, beanType, qualifier);
    }

    @Override
    public <T> Collection<T> getBeansOfType(Class<T> beanType) {
        return this.getBeansOfType(null, Argument.of(beanType));
    }

    @Override
    public <T> Collection<T> getBeansOfType(Class<T> beanType, Qualifier<T> qualifier) {
        return this.getBeansOfType(Argument.of(beanType), qualifier);
    }

    @Override
    public <T> Collection<T> getBeansOfType(Argument<T> beanType) {
        return this.getBeansOfType(null, beanType);
    }

    @Override
    public <T> Collection<T> getBeansOfType(Argument<T> beanType, Qualifier<T> qualifier) {
        return this.getBeansOfType(null, beanType, qualifier);
    }

    @Override
    public <T> Stream<T> streamOfType(Class<T> beanType, Qualifier<T> qualifier) {
        return this.streamOfType(null, beanType, qualifier);
    }

    @Override
    public <T> Stream<T> streamOfType(Argument<T> beanType, Qualifier<T> qualifier) {
        return this.streamOfType(null, beanType, qualifier);
    }

    @Override
    public <V> Map<String, V> mapOfType(Argument<V> beanType, Qualifier<V> qualifier) {
        return this.mapOfType(null, beanType, qualifier);
    }

    protected <T> Stream<T> streamOfType(BeanResolutionContext resolutionContext, Class<T> beanType, Qualifier<T> qualifier) {
        return this.streamOfType(resolutionContext, Argument.of(beanType), qualifier);
    }

    @NonNull
    protected <V> Map<String, V> mapOfType(@Nullable BeanResolutionContext resolutionContext, @NonNull Argument<V> beanType, @Nullable Qualifier<V> qualifier) {
        Qualifier<V> mapQualifier;
        Argument<Map<String, V>> mapType = Argument.mapOf(Argument.of(String.class), beanType);
        BeanDefinition existingBean = this.findBeanDefinitionInternal(mapType, mapQualifier = qualifier).orElse(null);
        if (existingBean != null) {
            return (Map)this.getBean(existingBean);
        }
        Collection<BeanRegistration<V>> beanRegistrations = this.getBeanRegistrations(resolutionContext, beanType, qualifier);
        if (beanRegistrations.isEmpty()) {
            return Collections.emptyMap();
        }
        try {
            return beanRegistrations.stream().collect(Collectors.toUnmodifiableMap(DefaultBeanContext::resolveKey, reg -> reg.bean));
        }
        catch (IllegalStateException e) {
            List<BeanDefinition> beanDefinitions = beanRegistrations.stream().map(reg -> reg.beanDefinition).toList();
            throw new DependencyInjectionException(resolutionContext, "Injecting a map of beans requires each bean to define a qualifier. Multiple beans were found missing a qualifier resulting in duplicate keys: " + e.getMessage(), (Throwable)new NonUniqueBeanException(beanType.getType(), beanDefinitions.iterator()));
        }
    }

    @NonNull
    private static String resolveKey(BeanRegistration<?> reg) {
        BeanDefinition definition = reg.beanDefinition;
        BeanIdentifier identifier = reg.identifier;
        if (definition instanceof NameResolver) {
            NameResolver resolver = (NameResolver)((Object)definition);
            return resolver.resolveName().orElse(identifier.getName());
        }
        String name = identifier.getName();
        if (name.equals(Primary.SIMPLE_NAME)) {
            Class candidateType = reg.beanDefinition.getBeanType();
            String candidateSimpleName = candidateType.getSimpleName();
            return NameUtils.decapitalize(candidateSimpleName);
        }
        return name;
    }

    @Internal
    public <T> Stream<T> streamOfType(BeanResolutionContext resolutionContext, Argument<T> beanType, Qualifier<T> qualifier) {
        Objects.requireNonNull(beanType, "Bean type cannot be null");
        return this.getBeanRegistrations(resolutionContext, beanType, qualifier).stream().map(BeanRegistration::getBean);
    }

    @Override
    @NonNull
    public <T> T inject(@NonNull T instance) {
        BeanDefinition<Object> beanDefinition;
        Objects.requireNonNull(instance, "Instance cannot be null");
        Collection<BeanDefinition<T>> candidates = this.findBeanCandidatesForInstance(instance);
        if (candidates.size() == 1) {
            beanDefinition = candidates.iterator().next();
        } else if (!candidates.isEmpty()) {
            Argument<?> t = Argument.of(instance.getClass());
            beanDefinition = this.lastChanceResolve(t, null, true, candidates);
        } else {
            beanDefinition = null;
        }
        if (beanDefinition != null && !(beanDefinition instanceof RuntimeBeanDefinition)) {
            try (BeanResolutionContext resolutionContext = this.newResolutionContext(beanDefinition, null);){
                BeanKey<Object> beanKey = new BeanKey<Object>(beanDefinition.getBeanType(), null, new Class[0]);
                resolutionContext.addInFlightBean(beanKey, new BeanRegistration<Object>(beanKey, beanDefinition, instance));
                this.doInjectAndInitialize(resolutionContext, instance, beanDefinition);
            }
        }
        return instance;
    }

    @Override
    @NonNull
    public <T> T createBean(@NonNull Class<T> beanType, @Nullable Qualifier<T> qualifier) {
        return this.createBean(null, beanType, qualifier);
    }

    @Override
    @NonNull
    public <T> T createBean(@NonNull Class<T> beanType, @Nullable Qualifier<T> qualifier, @Nullable Map<String, Object> argumentValues) {
        ArgumentUtils.requireNonNull("beanType", beanType);
        Optional<BeanDefinition<T>> candidate = this.findBeanDefinition(Argument.of(beanType), qualifier);
        if (candidate.isPresent()) {
            try (BeanResolutionContext resolutionContext = this.newResolutionContext(candidate.get(), null);){
                T t = this.doCreateBean(resolutionContext, candidate.get(), qualifier, argumentValues);
                return t;
            }
        }
        throw this.newNoSuchBeanException(null, Argument.of(beanType), qualifier, null);
    }

    @Override
    @NonNull
    public <T> T createBean(@NonNull Class<T> beanType, @Nullable Qualifier<T> qualifier, Object ... args) {
        ArgumentUtils.requireNonNull("beanType", beanType);
        Argument<T> beanArg = Argument.of(beanType);
        Optional<BeanDefinition<T>> candidate = this.findBeanDefinition(beanArg, qualifier);
        if (candidate.isPresent()) {
            BeanDefinition<T> definition = candidate.get();
            try (BeanResolutionContext resolutionContext = this.newResolutionContext(definition, null);){
                T t = this.doCreateBean(resolutionContext, definition, qualifier, args);
                return t;
            }
        }
        throw this.newNoSuchBeanException(null, Argument.of(beanType), qualifier, null);
    }

    @NonNull
    private <T> T doCreateBean(@NonNull BeanResolutionContext resolutionContext, @NonNull BeanDefinition<T> definition, @Nullable Qualifier<T> qualifier, Object ... args) {
        Map<String, Object> argumentValues = this.resolveArgumentValues(resolutionContext, definition, args);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Computed bean argument values: {}", (Object)argumentValues);
        }
        return this.doCreateBean(resolutionContext, definition, qualifier, argumentValues);
    }

    @NonNull
    private <T> Map<String, Object> resolveArgumentValues(BeanResolutionContext resolutionContext, BeanDefinition<T> definition, Object[] args) {
        if (!(definition instanceof ParametrizedInstantiatableBeanDefinition)) {
            return null;
        }
        ParametrizedInstantiatableBeanDefinition parametrizedInstantiatableBeanDefinition = (ParametrizedInstantiatableBeanDefinition)definition;
        Argument<Object>[] requiredArguments = parametrizedInstantiatableBeanDefinition.getRequiredArguments();
        if (LOG.isTraceEnabled()) {
            LOG.trace("Creating bean for parameters: {}", (Object)ArrayUtils.toString(args));
        }
        MutableConversionService conversionService = this.getConversionService();
        LinkedHashMap<String, Object> argumentValues = CollectionUtils.newLinkedHashMap(requiredArguments.length);
        BeanResolutionContext.Path currentPath = resolutionContext.getPath();
        for (int i = 0; i < requiredArguments.length; ++i) {
            Argument<Object> requiredArgument = requiredArguments[i];
            try (BeanResolutionContext.Path ignored = currentPath.pushConstructorResolve(definition, requiredArgument);){
                Class argumentType = requiredArgument.getType();
                if (args.length > i) {
                    Object val = args[i];
                    if (val != null) {
                        if (argumentType.isInstance(val) && !CollectionUtils.isIterableOrMap(argumentType)) {
                            argumentValues.put(requiredArgument.getName(), val);
                            continue;
                        }
                        argumentValues.put(requiredArgument.getName(), conversionService.convert(val, requiredArgument).orElseThrow(() -> new BeanInstantiationException(resolutionContext, "Invalid bean @Argument [" + requiredArgument + "]. Cannot convert object [" + val + "] to required type: " + argumentType)));
                        continue;
                    }
                    if (requiredArgument.isDeclaredNullable()) continue;
                    throw new BeanInstantiationException(resolutionContext, "Invalid bean @Argument [" + requiredArgument + "]. Argument cannot be null");
                }
                Optional existingBean = this.findBean(resolutionContext, argumentType, null);
                if (existingBean.isPresent()) {
                    argumentValues.put(requiredArgument.getName(), existingBean.get());
                    continue;
                }
                if (requiredArgument.isDeclaredNullable()) continue;
                throw new BeanInstantiationException(resolutionContext, "Invalid bean @Argument [" + requiredArgument + "]. No bean found for type: " + argumentType);
            }
        }
        return argumentValues;
    }

    @Override
    @Nullable
    public <T> T destroyBean(@NonNull Argument<T> beanType, Qualifier<T> qualifier) {
        ArgumentUtils.requireNonNull("beanType", beanType);
        return this.findBeanDefinition(beanType, qualifier).map(this::destroyBean).orElse(null);
    }

    @Override
    @NonNull
    public <T> T destroyBean(@NonNull T bean) {
        ArgumentUtils.requireNonNull("bean", bean);
        Optional<BeanRegistration<T>> beanRegistration = this.findBeanRegistration(bean);
        if (beanRegistration.isPresent()) {
            this.destroyBean(beanRegistration.get());
        } else {
            Optional<BeanDefinition<?>> beanDefinition = this.findBeanDefinition(bean.getClass());
            if (beanDefinition.isPresent()) {
                BeanDefinition<?> definition = beanDefinition.get();
                BeanKey key = new BeanKey(definition, definition.getDeclaredQualifier());
                this.destroyBean(BeanRegistration.of(this, key, definition, bean));
            }
        }
        return bean;
    }

    @Override
    @Nullable
    public <T> T destroyBean(@NonNull Class<T> beanType) {
        ArgumentUtils.requireNonNull("beanType", beanType);
        return this.destroyBean(Argument.of(beanType), null);
    }

    @Nullable
    private <T> T destroyBean(@NonNull BeanDefinition<T> beanDefinition) {
        BeanRegistration<T> beanRegistration;
        if (beanDefinition.isSingleton() && (beanRegistration = this.singletonScope.findBeanRegistration(beanDefinition)) != null) {
            this.destroyBean(beanRegistration);
            return beanRegistration.bean;
        }
        throw new IllegalArgumentException("Cannot destroy non-singleton bean using bean definition! Use 'destroyBean(BeanRegistration)` or `destroyBean(<BeanInstance>)`.");
    }

    @Override
    public <T> void destroyBean(@NonNull BeanRegistration<T> registration) {
        this.destroyBean(registration, false);
    }

    private <T> void destroyBean(@NonNull BeanRegistration<T> registration, boolean dependent) {
        BeanDefinition<T> definition;
        T beanToDestroy;
        block18: {
            if (LOG_LIFECYCLE.isDebugEnabled()) {
                LOG_LIFECYCLE.debug("Destroying bean [{}] with identifier [{}]", registration.bean, (Object)registration.identifier);
            }
            if (registration.beanDefinition instanceof ProxyBeanDefinition) {
                if (registration.bean instanceof InterceptedBeanProxy) {
                    this.destroyProxyTargetBean(registration, dependent);
                    return;
                }
                if (dependent && registration.beanDefinition.isSingleton()) {
                    return;
                }
            }
            beanToDestroy = registration.getBean();
            definition = registration.getBeanDefinition();
            if (beanToDestroy != null) {
                this.purgeCacheForBeanInstance(beanToDestroy);
                if (definition.isSingleton()) {
                    this.singletonScope.purgeCacheForBeanInstance(definition, beanToDestroy);
                }
            }
            beanToDestroy = this.triggerPreDestroyListeners(definition, beanToDestroy);
            if (definition instanceof DisposableBeanDefinition) {
                try {
                    ((DisposableBeanDefinition)definition).dispose(this, beanToDestroy);
                }
                catch (Exception e) {
                    if (!LOG.isWarnEnabled()) break block18;
                    LOG.warn("Error disposing bean [" + beanToDestroy + "]... Continuing...", e);
                }
            }
        }
        if (beanToDestroy instanceof LifeCycle) {
            LifeCycle cycle = (LifeCycle)beanToDestroy;
            try {
                cycle.stop();
            }
            catch (Exception e) {
                throw new BeanDestructionException(definition, (Throwable)e);
            }
        }
        if (registration instanceof BeanDisposingRegistration) {
            List<BeanRegistration<?>> dependents = ((BeanDisposingRegistration)registration).getDependents();
            if (CollectionUtils.isNotEmpty(dependents)) {
                ListIterator<BeanRegistration<?>> i = dependents.listIterator(dependents.size());
                while (i.hasPrevious()) {
                    this.destroyBean(i.previous(), true);
                }
            }
        } else {
            try {
                registration.close();
            }
            catch (Exception e) {
                throw new BeanDestructionException(definition, (Throwable)e);
            }
        }
        this.triggerBeanDestroyedListeners(definition, beanToDestroy);
    }

    @NonNull
    private <T> T triggerPreDestroyListeners(@NonNull BeanDefinition<T> beanDefinition, @NonNull T bean) {
        if (this.beanPreDestroyEventListeners == null) {
            this.beanPreDestroyEventListeners = this.loadListeners(BeanPreDestroyEventListener.class);
        }
        if (!this.beanPreDestroyEventListeners.isEmpty()) {
            Class<T> beanType = this.getBeanType(beanDefinition);
            for (Map.Entry<Class<?>, ListenersSupplier<BeanPreDestroyEventListener>> entry : this.beanPreDestroyEventListeners) {
                if (!entry.getKey().isAssignableFrom(beanType)) continue;
                BeanPreDestroyEvent<T> event = new BeanPreDestroyEvent<T>(this, beanDefinition, bean);
                for (BeanPreDestroyEventListener listener : entry.getValue().get(null)) {
                    try {
                        bean = Objects.requireNonNull(listener.onPreDestroy(event), "PreDestroy event listener illegally returned null: " + listener.getClass());
                    }
                    catch (Exception e) {
                        throw new BeanDestructionException(beanDefinition, (Throwable)e);
                    }
                }
            }
        }
        return bean;
    }

    private <T> void destroyProxyTargetBean(@NonNull BeanRegistration<T> registration, boolean dependent) {
        BeanDefinition proxyTargetBeanDefinition;
        Optional<CustomScope<?>> declaredScope;
        BeanDisposingRegistration disposingRegistration;
        Set<Object> destroyed = Collections.emptySet();
        if (registration instanceof BeanDisposingRegistration && (disposingRegistration = (BeanDisposingRegistration)registration).getDependents() != null) {
            destroyed = Collections.newSetFromMap(new IdentityHashMap());
            for (BeanRegistration<?> beanRegistration : disposingRegistration.getDependents()) {
                this.destroyBean(beanRegistration, true);
                destroyed.add(beanRegistration.bean);
            }
        }
        if ((declaredScope = this.customScopeRegistry.findDeclaredScope(proxyTargetBeanDefinition = this.findProxyTargetBeanDefinition(registration.beanDefinition).orElseThrow(() -> new IllegalStateException("Cannot find a proxy target bean definition for: " + registration.beanDefinition)))).isEmpty()) {
            InterceptedBeanProxy interceptedProxy;
            if (proxyTargetBeanDefinition.isSingleton()) {
                return;
            }
            if (registration.bean instanceof InterceptedBeanProxy && (interceptedProxy = (InterceptedBeanProxy)registration.bean).hasCachedInterceptedTarget()) {
                Object interceptedTarget = interceptedProxy.interceptedTarget();
                if (destroyed.contains(interceptedTarget)) {
                    return;
                }
                this.destroyBean(BeanRegistration.of(this, new BeanKey(proxyTargetBeanDefinition, proxyTargetBeanDefinition.getDeclaredQualifier()), proxyTargetBeanDefinition, interceptedTarget, registration instanceof BeanDisposingRegistration ? ((BeanDisposingRegistration)registration).getDependents() : null));
            }
            return;
        }
        CustomScope<?> customScope = declaredScope.get();
        if (dependent) {
            return;
        }
        Optional targetBeanRegistration = customScope.findBeanRegistration(proxyTargetBeanDefinition);
        if (targetBeanRegistration.isPresent()) {
            BeanRegistration targetRegistration = targetBeanRegistration.get();
            customScope.remove(targetRegistration.identifier);
        }
    }

    @NonNull
    private <T> void triggerBeanDestroyedListeners(@NonNull BeanDefinition<T> beanDefinition, @NonNull T bean) {
        if (this.beanDestroyedEventListeners == null) {
            this.beanDestroyedEventListeners = this.loadListeners(BeanDestroyedEventListener.class);
        }
        if (!this.beanDestroyedEventListeners.isEmpty()) {
            Class<T> beanType = this.getBeanType(beanDefinition);
            for (Map.Entry<Class<?>, ListenersSupplier<BeanDestroyedEventListener>> entry : this.beanDestroyedEventListeners) {
                if (!entry.getKey().isAssignableFrom(beanType)) continue;
                BeanDestroyedEvent<T> event = new BeanDestroyedEvent<T>(this, beanDefinition, bean);
                for (BeanDestroyedEventListener listener : entry.getValue().get(null)) {
                    try {
                        listener.onDestroyed(event);
                    }
                    catch (Exception e) {
                        throw new BeanDestructionException(beanDefinition, (Throwable)e);
                    }
                }
            }
        }
    }

    @NonNull
    private <T> Class<T> getBeanType(@NonNull BeanDefinition<T> beanDefinition) {
        if (beanDefinition instanceof ProxyBeanDefinition) {
            return ((ProxyBeanDefinition)beanDefinition).getTargetType();
        }
        return beanDefinition.getBeanType();
    }

    @Nullable
    protected <T> BeanRegistration<T> getActiveBeanRegistration(BeanDefinition<T> beanDefinition, Qualifier qualifier) {
        if (beanDefinition == null) {
            return null;
        }
        return this.singletonScope.findBeanRegistration(beanDefinition, qualifier);
    }

    @NonNull
    protected <T> T createBean(@Nullable BeanResolutionContext resolutionContext, @NonNull Class<T> beanType, @Nullable Qualifier<T> qualifier) {
        ArgumentUtils.requireNonNull("beanType", beanType);
        Optional<BeanDefinition<T>> concreteCandidate = this.findBeanDefinition(beanType, qualifier);
        if (concreteCandidate.isPresent()) {
            BeanDefinition<T> candidate = concreteCandidate.get();
            try (BeanResolutionContext context = this.newResolutionContext(candidate, resolutionContext);){
                T t = this.doCreateBean(context, candidate, qualifier);
                return t;
            }
        }
        throw this.newNoSuchBeanException(resolutionContext, Argument.of(beanType), qualifier, null);
    }

    @Internal
    @NonNull
    protected <T> T inject(@NonNull BeanResolutionContext resolutionContext, @Nullable BeanDefinition<?> requestingBeanDefinition, @NonNull T instance) {
        Class<?> beanType = instance.getClass();
        Optional<BeanDefinition<?>> concreteCandidate = this.findBeanDefinition(beanType, null);
        if (concreteCandidate.isPresent()) {
            BeanDefinition<?> definition = concreteCandidate.get();
            if (requestingBeanDefinition != null && requestingBeanDefinition.equals(definition)) {
                return instance;
            }
            this.doInjectAndInitialize(resolutionContext, instance, definition);
        }
        return instance;
    }

    @NonNull
    protected <T> Collection<T> getBeansOfType(@Nullable BeanResolutionContext resolutionContext, @NonNull Argument<T> beanType) {
        return this.getBeansOfType(resolutionContext, beanType, null);
    }

    @Internal
    @NonNull
    public <T> Collection<T> getBeansOfType(@Nullable BeanResolutionContext resolutionContext, @NonNull Argument<T> beanType, @Nullable Qualifier<T> qualifier) {
        Collection<BeanRegistration<T>> beanRegistrations = this.getBeanRegistrations(resolutionContext, beanType, qualifier);
        ArrayList<T> list = new ArrayList<T>(beanRegistrations.size());
        for (BeanRegistration<T> beanRegistration : beanRegistrations) {
            list.add(beanRegistration.getBean());
        }
        return list;
    }

    @Override
    @NonNull
    public <T> T getProxyTargetBean(@NonNull Class<T> beanType, @Nullable Qualifier<T> qualifier) {
        ArgumentUtils.requireNonNull("beanType", beanType);
        return this.getProxyTargetBean(null, Argument.of(beanType), qualifier);
    }

    @Override
    @NonNull
    public <T> T getProxyTargetBean(@NonNull Argument<T> beanType, @Nullable Qualifier<T> qualifier) {
        ArgumentUtils.requireNonNull("beanType", beanType);
        return this.getProxyTargetBean(null, beanType, qualifier);
    }

    @NonNull
    public <T> T getProxyTargetBean(@Nullable BeanResolutionContext resolutionContext, @NonNull Argument<T> beanType, @Nullable Qualifier<T> qualifier) {
        BeanDefinition<T> definition = this.getProxyTargetBeanDefinition(beanType, qualifier);
        return this.resolveBeanRegistration((BeanResolutionContext)resolutionContext, definition, beanType, qualifier).bean;
    }

    @Override
    @NonNull
    public <T, R> Optional<ExecutableMethod<T, R>> findProxyTargetMethod(@NonNull Class<T> beanType, @NonNull String method, @NonNull Class<?>[] arguments) {
        ArgumentUtils.requireNonNull("beanType", beanType);
        ArgumentUtils.requireNonNull("method", method);
        BeanDefinition<T> definition = this.getProxyTargetBeanDefinition(beanType, null);
        return definition.findMethod(method, arguments);
    }

    @Override
    @NonNull
    public <T, R> Optional<ExecutableMethod<T, R>> findProxyTargetMethod(@NonNull Class<T> beanType, Qualifier<T> qualifier, @NonNull String method, Class<?> ... arguments) {
        ArgumentUtils.requireNonNull("beanType", beanType);
        ArgumentUtils.requireNonNull("method", method);
        BeanDefinition<T> definition = this.getProxyTargetBeanDefinition(beanType, qualifier);
        return definition.findMethod(method, arguments);
    }

    @Override
    public <T, R> Optional<ExecutableMethod<T, R>> findProxyTargetMethod(@NonNull Argument<T> beanType, Qualifier<T> qualifier, @NonNull String method, Class<?> ... arguments) {
        ArgumentUtils.requireNonNull("beanType", beanType);
        ArgumentUtils.requireNonNull("method", method);
        BeanDefinition<T> definition = this.getProxyTargetBeanDefinition(beanType, qualifier);
        return definition.findMethod(method, arguments);
    }

    @Override
    @NonNull
    public <T> Optional<BeanDefinition<T>> findProxyTargetBeanDefinition(@NonNull Class<T> beanType, @Nullable Qualifier<T> qualifier) {
        return this.findProxyTargetBeanDefinition(Argument.of(beanType), qualifier);
    }

    @Override
    public <T> Optional<BeanDefinition<T>> findProxyTargetBeanDefinition(@NonNull Argument<T> beanType, @Nullable Qualifier<T> qualifier) {
        ArgumentUtils.requireNonNull("beanType", beanType);
        BeanCandidateKey<T> key = new BeanCandidateKey<T>(beanType, qualifier, true);
        Optional<BeanDefinition<T>> beanDefinition = this.beanProxyTargetCache.get(key);
        if (beanDefinition == null) {
            beanDefinition = this.findProxyTargetNoCache(null, beanType, qualifier);
            this.beanProxyTargetCache.put(key, beanDefinition);
        }
        return beanDefinition;
    }

    @Override
    @NonNull
    public Collection<BeanDefinition<?>> getBeanDefinitions(@Nullable Qualifier<Object> qualifier) {
        if (qualifier == null) {
            return Collections.emptyList();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Finding candidate beans for qualifier: {}", (Object)qualifier);
        }
        if (this.beanDefinitionsClasses.isEmpty()) {
            return Collections.emptyList();
        }
        Stream<BeanDefinitionReference> reduced = qualifier.reduce(Object.class, this.beanDefinitionsClasses.stream().filter(p -> p.isReferenceEnabled(this)).map(BeanDefinitionProducer::getReference));
        Stream<BeanDefinition> candidateStream = qualifier.reduce(Object.class, reduced.map(ref -> ref.load(this)).filter(candidate -> candidate.isEnabled(this)));
        Collection candidates = candidateStream.collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(candidates)) {
            this.filterReplacedBeans(null, candidates);
        }
        return candidates;
    }

    @Override
    @NonNull
    public Collection<BeanDefinition<?>> getAllBeanDefinitions() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Finding all bean definitions");
        }
        if (!this.beanDefinitionsClasses.isEmpty()) {
            return this.beanDefinitionsClasses.stream().filter(p -> p.isDefinitionEnabled(this)).map(p -> p.getDefinition(this)).collect(Collectors.toList());
        }
        return (Collection)((Object)Collections.emptyMap());
    }

    @Override
    public Collection<DisabledBean<?>> getDisabledBeans() {
        return this.disabledBeans.values().stream().map(producer -> (DisabledBean)producer.reference).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Override
    @NonNull
    public Collection<BeanDefinitionReference<?>> getBeanDefinitionReferences() {
        if (!this.beanDefinitionsClasses.isEmpty()) {
            List<BeanDefinitionReference<?>> refs = this.beanDefinitionsClasses.stream().filter(p -> p.isReferenceEnabled(this)).map(BeanDefinitionProducer::getReference).toList();
            return refs;
        }
        return Collections.emptyList();
    }

    @Override
    @NonNull
    public <B> BeanContext registerBeanDefinition(@NonNull RuntimeBeanDefinition<B> definition) {
        Objects.requireNonNull(definition, "Bean definition cannot be null");
        Class beanType = definition.getBeanType();
        BeanDefinitionProducer producer = new BeanDefinitionProducer(definition);
        this.beanDefinitionsClasses.add(producer);
        for (Class clazz : this.indexedTypes) {
            if (clazz != beanType && !clazz.isAssignableFrom(beanType)) continue;
            Collection<BeanDefinitionProducer> indexed = this.resolveTypeIndex(clazz);
            indexed.add(producer);
            break;
        }
        this.purgeCacheForBeanType(beanType);
        return this;
    }

    private <B> void purgeCacheForBeanType(Class<B> beanType) {
        this.beanCandidateCache.entrySet().removeIf(entry -> ((Argument)entry.getKey()).isAssignableFrom(beanType));
        this.beanConcreteCandidateCache.entrySet().removeIf(entry -> ((BeanCandidateKey)entry.getKey()).beanType.isAssignableFrom(beanType));
        this.singletonBeanRegistrations.entrySet().removeIf(entry -> ((BeanKey)entry.getKey()).beanType.isAssignableFrom(beanType));
        this.containsBeanCache.entrySet().removeIf(entry -> ((BeanKey)entry.getKey()).beanType.isAssignableFrom(beanType));
    }

    @Internal
    <B> void removeBeanDefinition(RuntimeBeanDefinition<B> definition) {
        Class beanType = definition.getBeanType();
        for (Class clazz : this.indexedTypes) {
            if (clazz != beanType && !clazz.isAssignableFrom(beanType)) continue;
            this.resolveTypeIndex(clazz).forEach(p -> p.disable(definition));
            break;
        }
        this.beanDefinitionsClasses.forEach(p -> p.disable(definition));
        this.purgeCacheForBeanType(definition.getBeanType());
    }

    @NonNull
    public <T> T getBean(@Nullable BeanResolutionContext resolutionContext, @NonNull Class<T> beanType) {
        ArgumentUtils.requireNonNull("beanType", beanType);
        return this.getBean(resolutionContext, Argument.of(beanType), null);
    }

    @Override
    @NonNull
    public <T> T getBean(@NonNull BeanDefinition<T> definition) {
        ArgumentUtils.requireNonNull("definition", definition);
        return this.resolveBeanRegistration(null, definition).bean;
    }

    @NonNull
    public <T> T getBean(@Nullable BeanResolutionContext resolutionContext, @NonNull Class<T> beanType, @Nullable Qualifier<T> qualifier) {
        return this.getBean(resolutionContext, Argument.of(beanType), qualifier);
    }

    @NonNull
    public <T> T getBean(@Nullable BeanResolutionContext resolutionContext, @NonNull Argument<T> beanType, @Nullable Qualifier<T> qualifier) {
        ArgumentUtils.requireNonNull("beanType", beanType);
        return this.resolveBeanRegistration((BeanResolutionContext)resolutionContext, beanType, qualifier, (boolean)true).bean;
    }

    @Internal
    @NonNull
    public <T> T getBean(@Nullable BeanResolutionContext resolutionContext, @NonNull BeanDefinition<T> beanDefinition, @NonNull Argument<T> beanType, @Nullable Qualifier<T> qualifier) {
        ArgumentUtils.requireNonNull("beanDefinition", beanDefinition);
        ArgumentUtils.requireNonNull("beanType", beanType);
        return this.resolveBeanRegistration((BeanResolutionContext)resolutionContext, beanDefinition, beanType, qualifier).bean;
    }

    @NonNull
    public <T> Optional<T> findBean(@Nullable BeanResolutionContext resolutionContext, @NonNull Class<T> beanType, @Nullable Qualifier<T> qualifier) {
        return this.findBean(resolutionContext, Argument.of(beanType), qualifier);
    }

    @Internal
    @NonNull
    public <T> Optional<T> findBean(@Nullable BeanResolutionContext resolutionContext, @NonNull Argument<T> beanType, @Nullable Qualifier<T> qualifier) {
        ArgumentUtils.requireNonNull("beanType", beanType);
        if (this.thisInterfaces.contains(beanType.getType())) {
            return Optional.of(this);
        }
        try {
            BeanRegistration<T> beanRegistration = this.resolveBeanRegistration(resolutionContext, beanType, qualifier, false);
            if (beanRegistration == null || beanRegistration.bean == null) {
                return Optional.empty();
            }
            return Optional.of(beanRegistration.bean);
        }
        catch (DisabledBeanException e) {
            if (AbstractBeanContextConditional.ConditionLog.LOG.isDebugEnabled()) {
                AbstractBeanContextConditional.ConditionLog.LOG.debug("Bean of type [{}] disabled for reason: {}", (Object)beanType.getSimpleName(), (Object)e.getMessage());
            }
            return Optional.empty();
        }
    }

    @Override
    public BeanContextConfiguration getContextConfiguration() {
        return this.beanContextConfiguration;
    }

    @Override
    public void publishEvent(@NonNull Object event) {
        if (event != null) {
            this.getBean(Argument.of(ApplicationEventPublisher.class, event.getClass())).publishEvent(event);
        }
    }

    @Override
    @NonNull
    public Future<Void> publishEventAsync(@NonNull Object event) {
        Objects.requireNonNull(event, "Event cannot be null");
        return this.getBean(Argument.of(ApplicationEventPublisher.class, event.getClass())).publishEventAsync(event);
    }

    @Override
    @NonNull
    public <T> Optional<BeanDefinition<T>> findProxyBeanDefinition(@NonNull Class<T> beanType, @Nullable Qualifier<T> qualifier) {
        ArgumentUtils.requireNonNull("beanType", beanType);
        return this.findProxyBeanDefinition(Argument.of(beanType), qualifier);
    }

    @Override
    @NonNull
    public <T> Optional<BeanDefinition<T>> findProxyBeanDefinition(@NonNull Argument<T> beanType, @Nullable Qualifier<T> qualifier) {
        ArgumentUtils.requireNonNull("beanType", beanType);
        for (BeanDefinition<T> beanDefinition : this.getBeanDefinitions(beanType, qualifier)) {
            if (!beanDefinition.isProxy()) continue;
            return Optional.of(beanDefinition);
        }
        return Optional.empty();
    }

    @Internal
    protected void invalidateCaches() {
        this.beanCandidateCache.clear();
        this.beanConcreteCandidateCache.clear();
        this.singletonBeanRegistrations.clear();
    }

    @NonNull
    protected List<BeanDefinitionReference> resolveBeanDefinitionReferences() {
        if (this.beanDefinitionReferences == null) {
            SoftServiceLoader<BeanDefinitionReference> definitions = SoftServiceLoader.load(BeanDefinitionReference.class, this.classLoader);
            this.beanDefinitionReferences = new ArrayList<BeanDefinitionReference>(300);
            definitions.collectAll(this.beanDefinitionReferences, BeanDefinitionReference::isPresent);
        }
        return this.beanDefinitionReferences;
    }

    @NonNull
    @Deprecated
    protected List<BeanDefinitionReference> resolveBeanDefinitionReferences(@Nullable Predicate<BeanDefinitionReference> predicate) {
        if (predicate != null) {
            List<BeanDefinitionReference> allRefs = this.resolveBeanDefinitionReferences();
            ArrayList<BeanDefinitionReference> newRefs = new ArrayList<BeanDefinitionReference>(allRefs.size());
            for (BeanDefinitionReference reference : allRefs) {
                if (!predicate.test(reference)) continue;
                newRefs.add(reference);
            }
            return newRefs;
        }
        return this.resolveBeanDefinitionReferences();
    }

    @NonNull
    protected Iterable<BeanConfiguration> resolveBeanConfigurations() {
        if (this.beanConfigurationsList == null) {
            SoftServiceLoader<BeanConfiguration> definitions = SoftServiceLoader.load(BeanConfiguration.class, this.classLoader);
            this.beanConfigurationsList = new ArrayList<BeanConfiguration>(300);
            definitions.collectAll(this.beanConfigurationsList, null);
        }
        return this.beanConfigurationsList;
    }

    protected void initializeEventListeners() {
        this.beanCreationEventListeners = this.loadListeners(BeanCreatedEventListener.class);
        this.beanCreationEventListeners.add(new AbstractMap.SimpleEntry<Class<AnnotationProcessor>, 3>(AnnotationProcessor.class, new ListenersSupplier<BeanCreatedEventListener>(){

            @Override
            public Iterable<BeanCreatedEventListener> get(BeanResolutionContext beanResolutionContext) {
                return Collections.singletonList(new AnnotationProcessorListener());
            }
        }));
        this.beanInitializedEventListeners = this.loadListeners(BeanInitializedEventListener.class);
    }

    @NonNull
    private <T extends EventListener> List<Map.Entry<Class<?>, ListenersSupplier<T>>> loadListeners(@NonNull Class<T> listenerType) {
        Map<Class<?>, List<BeanDefinition<T>>> typeToListener = this.getTypeToListenerMap(listenerType);
        if (typeToListener.isEmpty()) {
            return new ArrayList(1);
        }
        ArrayList eventToListeners = new ArrayList(typeToListener.size());
        for (final Map.Entry<Class<?>, List<BeanDefinition<T>>> e : typeToListener.entrySet()) {
            eventToListeners.add(new AbstractMap.SimpleEntry(e.getKey(), new ListenersSupplier<T>(){
                private volatile List<T> listeners;

                @Override
                public Iterable<T> get(BeanResolutionContext beanResolutionContext) {
                    if (this.listeners == null) {
                        List listenersDefinitions = (List)e.getValue();
                        ArrayList listeners = new ArrayList(listenersDefinitions.size());
                        for (BeanDefinition listenersDefinition : listenersDefinitions) {
                            EventListener listener;
                            if (beanResolutionContext == null) {
                                try (BeanResolutionContext context = DefaultBeanContext.this.newResolutionContext(listenersDefinition, null);){
                                    listener = (EventListener)DefaultBeanContext.this.resolveBeanRegistration((BeanResolutionContext)context, listenersDefinition).bean;
                                }
                            } else {
                                listener = (EventListener)DefaultBeanContext.this.resolveBeanRegistration((BeanResolutionContext)beanResolutionContext, listenersDefinition).bean;
                            }
                            listeners.add(listener);
                        }
                        OrderUtil.sort(listeners);
                        this.listeners = listeners;
                    }
                    return this.listeners;
                }
            }));
        }
        return eventToListeners;
    }

    @NonNull
    private <T extends EventListener> Map<Class<?>, List<BeanDefinition<T>>> getTypeToListenerMap(@NonNull Class<T> listenerType) {
        Collection<BeanDefinition<T>> beanDefinitions = this.getBeanDefinitions(listenerType);
        if (beanDefinitions.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<Class<?>, List<BeanDefinition<T>>> typeToListener = CollectionUtils.newHashMap(beanDefinitions.size());
        for (BeanDefinition<T> beanCreatedDefinition : beanDefinitions) {
            List<Argument<T>> typeArguments = beanCreatedDefinition.getTypeArguments(listenerType);
            Argument<Object> argument = CollectionUtils.last(typeArguments);
            if (argument == null) {
                argument = Argument.OBJECT_ARGUMENT;
            }
            typeToListener.computeIfAbsent(argument.getType(), aClass -> new ArrayList(10)).add(beanCreatedDefinition);
        }
        return typeToListener;
    }

    @Internal
    protected void initializeContext(@NonNull List<BeanDefinitionProducer> eagerInitBeans, @NonNull List<BeanDefinitionProducer> processedBeans, @NonNull List<BeanDefinitionProducer> parallelBeans) {
        if (CollectionUtils.isNotEmpty(eagerInitBeans)) {
            ArrayList<BeanDefinition<Object>> eagerInit = new ArrayList<BeanDefinition<Object>>(eagerInitBeans.size());
            for (BeanDefinitionProducer beanDefinitionProducer : eagerInitBeans) {
                try {
                    this.loadEagerBeans(beanDefinitionProducer, eagerInit);
                }
                catch (Throwable throwable) {
                    throw new BeanInstantiationException(MSG_BEAN_DEFINITION + beanDefinitionProducer.getReference().getName() + MSG_COULD_NOT_BE_LOADED + throwable.getMessage(), throwable);
                }
            }
            this.filterReplacedBeans(null, eagerInit);
            OrderUtil.sort(eagerInit);
            for (BeanDefinition beanDefinition : eagerInit) {
                try {
                    this.initializeEagerBean(beanDefinition);
                }
                catch (DisabledBeanException disabledBeanException) {
                    if (!AbstractBeanContextConditional.ConditionLog.LOG.isDebugEnabled()) continue;
                    AbstractBeanContextConditional.ConditionLog.LOG.debug("Bean of type [{}] disabled for reason: {}", (Object)beanDefinition.getBeanType().getSimpleName(), (Object)disabledBeanException.getMessage());
                }
                catch (Throwable throwable) {
                    throw new BeanInstantiationException(MSG_BEAN_DEFINITION + beanDefinition.getName() + MSG_COULD_NOT_BE_LOADED + throwable.getMessage(), throwable);
                }
            }
        }
        if (!processedBeans.isEmpty()) {
            ArrayList methodsToProcess = new ArrayList();
            for (BeanDefinitionProducer beanDefinitionProducer : processedBeans) {
                if (!beanDefinitionProducer.isDefinitionEnabled(this)) continue;
                BeanDefinition beanDefinition = beanDefinitionProducer.getDefinition(this);
                for (ExecutableMethod method : beanDefinition.getExecutableMethods()) {
                    if (!method.hasStereotype((Class<? extends Annotation>)((Class<Annotation>)Executable.class))) continue;
                    methodsToProcess.add(BeanDefinitionMethodReference.of(beanDefinition, method));
                }
            }
            HashMap byAnnotation = CollectionUtils.newHashMap(methodsToProcess.size());
            for (BeanDefinitionMethodReference beanDefinitionMethodReference : methodsToProcess) {
                List<Class<? extends Annotation>> annotations = beanDefinitionMethodReference.getAnnotationTypesByStereotype(Executable.class);
                for (Class clazz : annotations) {
                    ArrayList<BeanDefinitionMethodReference> references = (ArrayList<BeanDefinitionMethodReference>)byAnnotation.get(clazz);
                    if (references == null) {
                        references = new ArrayList<BeanDefinitionMethodReference>(10);
                        byAnnotation.put(clazz, references);
                    }
                    references.add(beanDefinitionMethodReference);
                }
            }
            for (Map.Entry entry : byAnnotation.entrySet()) {
                Class annotationType = (Class)entry.getKey();
                List methods = (List)entry.getValue();
                this.streamOfType(ExecutableMethodProcessor.class, Qualifiers.byTypeArguments(annotationType)).forEach(processor -> {
                    Object cycle;
                    if (processor instanceof LifeCycle) {
                        cycle = (LifeCycle)((Object)processor);
                        cycle.start();
                    }
                    for (BeanDefinitionMethodReference method : methods) {
                        BeanDefinition beanDefinition = method.getBeanDefinition();
                        if (beanDefinition.hasStereotype((Class<? extends Annotation>)((Class<Annotation>)((Class<? extends Annotation>)annotationType)))) continue;
                        if (method.hasDeclaredStereotype((Class<? extends Annotation>)Parallel.class)) {
                            ForkJoinPool.commonPool().execute(() -> {
                                block3: {
                                    try {
                                        processor.process((BeanDefinition<?>)beanDefinition, method);
                                    }
                                    catch (Throwable e) {
                                        Boolean shutdownOnError;
                                        if (LOG.isErrorEnabled()) {
                                            LOG.error("Error processing bean method " + beanDefinition + "." + method + " with processor (" + processor + "): " + e.getMessage(), e);
                                        }
                                        if (!(shutdownOnError = method.booleanValue(Parallel.class, "shutdownOnError").orElse(true)).booleanValue()) break block3;
                                        this.stop();
                                    }
                                }
                            });
                            continue;
                        }
                        processor.process((BeanDefinition<?>)beanDefinition, method);
                    }
                    if (processor instanceof LifeCycle) {
                        cycle = (LifeCycle)((Object)processor);
                        cycle.stop();
                    }
                });
            }
        }
        if (CollectionUtils.isNotEmpty(parallelBeans)) {
            this.processParallelBeans(parallelBeans);
        }
        ForkJoinPool.commonPool().execute(() -> this.beanDefinitionsClasses.forEach(p -> p.isReferenceEnabled(this)));
    }

    @NonNull
    protected <T> Collection<BeanDefinition<T>> findBeanCandidates(@Nullable BeanResolutionContext resolutionContext, @NonNull Argument<T> beanType, @Nullable BeanDefinition<?> filter) {
        Predicate<BeanDefinition<BeanDefinition<BeanDefinition<BeanDefinition<T>>>>> predicate = filter == null ? null : definition -> !definition.equals(filter);
        return this.findBeanCandidates(resolutionContext, beanType, true, predicate);
    }

    @NonNull
    protected <T> Collection<BeanDefinition<T>> findBeanCandidates(@Nullable BeanResolutionContext resolutionContext, @NonNull Argument<T> beanType, boolean collectIterables, Predicate<BeanDefinition<T>> predicate) {
        Collection<BeanDefinitionProducer> beanDefinitionsClasses;
        ArgumentUtils.requireNonNull("beanType", beanType);
        Class beanClass = beanType.getType();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Finding candidate beans for type: {}", (Object)beanType);
        }
        if (this.indexedTypes.contains(beanClass)) {
            beanDefinitionsClasses = this.beanIndex.get(beanClass);
            if (beanDefinitionsClasses == null) {
                beanDefinitionsClasses = Collections.emptyList();
            }
        } else {
            beanDefinitionsClasses = this.beanDefinitionsClasses;
        }
        return this.collectBeanCandidates(resolutionContext, beanType, collectIterables, predicate, beanDefinitionsClasses);
    }

    @NonNull
    private <T> Set<BeanDefinition<T>> collectBeanCandidates(BeanResolutionContext resolutionContext, Argument<T> beanType, boolean collectIterables, @Nullable Predicate<BeanDefinition<T>> predicate, Collection<BeanDefinitionProducer> beanDefinitionProducers) {
        Set<BeanDefinition<T>> candidates;
        if (!beanDefinitionProducers.isEmpty()) {
            candidates = new HashSet();
            for (BeanDefinitionProducer beanDefinitionProducer : beanDefinitionProducers) {
                BeanDefinition loadedBean;
                if (beanDefinitionProducer.isDisabled() || !beanDefinitionProducer.isReferenceCandidateBean(beanType) || !beanDefinitionProducer.isReferenceEnabled(this, resolutionContext) || !(loadedBean = beanDefinitionProducer.getDefinition(this)).isCandidateBean(beanType) || predicate != null && !predicate.test(loadedBean) || !beanDefinitionProducer.isDefinitionEnabled(this, resolutionContext)) continue;
                if (collectIterables && loadedBean.isConfigurationProperties()) {
                    this.collectIterableBeans(resolutionContext, loadedBean, candidates);
                    continue;
                }
                candidates.add(loadedBean);
            }
            if (!candidates.isEmpty()) {
                this.filterReplacedBeans(resolutionContext, candidates);
            }
        } else {
            candidates = Collections.emptySet();
        }
        if (LOG.isDebugEnabled()) {
            if (candidates.isEmpty()) {
                LOG.debug("No bean candidates found for type: {}", (Object)beanType);
            } else {
                for (BeanDefinition beanDefinition : candidates) {
                    LOG.debug("  {} {} {}", beanDefinition.getBeanType(), beanDefinition.getDeclaredQualifier(), beanDefinition);
                }
            }
        }
        return candidates;
    }

    protected <T> void collectIterableBeans(@Nullable BeanResolutionContext resolutionContext, @NonNull BeanDefinition<T> iterableBean, Set<BeanDefinition<T>> targetSet) {
    }

    @NonNull
    protected <T> Collection<BeanDefinition<T>> findBeanCandidatesForInstance(@NonNull T instance) {
        ArgumentUtils.requireNonNull("instance", instance);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Finding candidate beans for instance: {}", (Object)instance);
        }
        Collection<BeanDefinitionProducer> beanProducers = this.beanDefinitionsClasses;
        Class<?> beanClass = instance.getClass();
        Argument<?> beanType = Argument.of(beanClass);
        Collection<BeanDefinition<T>> beanDefinitions = this.beanCandidateCache.get(beanType);
        if (beanDefinitions != null) {
            return beanDefinitions;
        }
        if (!this.beanDefinitionsClasses.isEmpty()) {
            List<BeanDefinition<T>> candidates = new ArrayList<BeanDefinition<T>>();
            for (BeanDefinitionProducer producer : beanProducers) {
                BeanDefinition candidate2;
                BeanDefinitionReference reference;
                Class candidateType;
                if (producer.isDisabled() || !producer.isReferenceEnabled(this) || (candidateType = (reference = producer.getReference()).getBeanType()) == null || !candidateType.isInstance(instance) || !(candidate2 = reference.load(this)).isEnabled(this)) continue;
                candidates.add(candidate2);
            }
            if (candidates.size() > 1) {
                candidates = candidates.stream().filter(candidate -> candidate.getBeanType() == beanClass).collect(Collectors.toList());
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Resolved bean candidates {} for instance: {}", (Object)candidates, (Object)instance);
            }
            beanDefinitions = candidates;
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug("No bean candidates found for instance: {}", (Object)instance);
            }
            beanDefinitions = Collections.emptySet();
        }
        this.beanCandidateCache.put(beanType, beanDefinitions);
        return beanDefinitions;
    }

    protected synchronized void registerConfiguration(@NonNull BeanConfiguration configuration) {
        ArgumentUtils.requireNonNull("configuration", configuration);
        this.beanConfigurations.put(configuration.getName(), configuration);
    }

    @Internal
    @NonNull
    private <T> T doCreateBean(@NonNull BeanResolutionContext resolutionContext, @NonNull BeanDefinition<T> beanDefinition, @Nullable Qualifier<T> qualifier, @Nullable Map<String, Object> argumentValues) {
        if (!(beanDefinition instanceof InstantiatableBeanDefinition)) {
            throw new BeanInstantiationException("BeanDefinition doesn't support creating a new instance of the bean");
        }
        InstantiatableBeanDefinition instantiatableBeanDefinition = (InstantiatableBeanDefinition)beanDefinition;
        T bean = this.resolveByBeanFactory(resolutionContext, instantiatableBeanDefinition, qualifier, argumentValues);
        return this.postBeanCreated(resolutionContext, beanDefinition, qualifier, bean);
    }

    @Internal
    @NonNull
    private <T> T doCreateBean(@NonNull BeanResolutionContext resolutionContext, @NonNull BeanDefinition<T> beanDefinition, @Nullable Qualifier<T> qualifier) {
        return this.doCreateBean(resolutionContext, beanDefinition, qualifier, Collections.emptyMap());
    }

    @NonNull
    private <T> T resolveByBeanFactory(@NonNull BeanResolutionContext resolutionContext, @NonNull BeanDefinition<T> beanDefinition, @Nullable Qualifier<T> qualifier, @Nullable Map<String, Object> argumentValues) {
        Qualifier<T> declaredQualifier = beanDefinition.getDeclaredQualifier();
        Qualifier<?> prevQualifier = resolutionContext.getCurrentQualifier();
        try {
            Object bean;
            resolutionContext.setCurrentQualifier(declaredQualifier != null && !AnyQualifier.INSTANCE.equals(declaredQualifier) ? declaredQualifier : qualifier);
            if (beanDefinition instanceof ParametrizedInstantiatableBeanDefinition) {
                ParametrizedInstantiatableBeanDefinition parametrizedInstantiatableBeanDefinition = (ParametrizedInstantiatableBeanDefinition)beanDefinition;
                Argument<Object>[] requiredArguments = parametrizedInstantiatableBeanDefinition.getRequiredArguments();
                Map<String, Object> convertedValues = this.getRequiredArgumentValues(resolutionContext, requiredArguments, argumentValues, beanDefinition);
                bean = parametrizedInstantiatableBeanDefinition.instantiate(resolutionContext, this, convertedValues);
            } else if (beanDefinition instanceof InstantiatableBeanDefinition) {
                InstantiatableBeanDefinition instantiatableBeanDefinition = (InstantiatableBeanDefinition)beanDefinition;
                bean = instantiatableBeanDefinition.instantiate(resolutionContext, this);
            } else {
                throw new BeanInstantiationException(resolutionContext, "Expected InstantiatableBeanDefinition [" + beanDefinition + "]");
            }
            if (bean == null) {
                throw new BeanInstantiationException(resolutionContext, "InstantiatableBeanDefinition [" + beanDefinition + "] returned null");
            }
            if (bean instanceof Qualified) {
                Qualified qualified = (Qualified)bean;
                qualified.$withBeanQualifier(declaredQualifier);
            }
            Object t = bean;
            return t;
        }
        catch (BeanInstantiationException | DependencyInjectionException | DisabledBeanException e) {
            throw e;
        }
        catch (Throwable e) {
            if (!resolutionContext.getPath().isEmpty()) {
                throw new BeanInstantiationException(resolutionContext, e);
            }
            throw new BeanInstantiationException(beanDefinition, e);
        }
        finally {
            resolutionContext.setCurrentQualifier(prevQualifier);
        }
    }

    @NonNull
    private <T> T postBeanCreated(@NonNull BeanResolutionContext resolutionContext, @NonNull BeanDefinition<T> beanDefinition, @Nullable Qualifier<T> qualifier, @NonNull T bean) {
        Qualifier<T> finalQualifier = qualifier != null ? qualifier : beanDefinition.getDeclaredQualifier();
        bean = this.triggerBeanCreatedEventListener(resolutionContext, beanDefinition, bean, finalQualifier);
        if (beanDefinition instanceof ValidatedBeanDefinition) {
            ValidatedBeanDefinition validatedBeanDefinition = (ValidatedBeanDefinition)beanDefinition;
            bean = validatedBeanDefinition.validate(resolutionContext, bean);
        }
        if (LOG_LIFECYCLE.isDebugEnabled()) {
            LOG_LIFECYCLE.debug("Created bean [{}] from definition [{}] with qualifier [{}]", bean, beanDefinition, finalQualifier);
        }
        return bean;
    }

    @NonNull
    private <T> T triggerBeanCreatedEventListener(@NonNull BeanResolutionContext resolutionContext, @NonNull BeanDefinition<T> beanDefinition, @NonNull T bean, @Nullable Qualifier<T> finalQualifier) {
        if (!(beanDefinition instanceof AbstractProviderDefinition)) {
            Class<T> beanType = beanDefinition.getBeanType();
            if (!(bean instanceof BeanCreatedEventListener) && CollectionUtils.isNotEmpty(this.beanCreationEventListeners)) {
                for (Map.Entry<Class<?>, ListenersSupplier<BeanCreatedEventListener>> entry : this.beanCreationEventListeners) {
                    if (!entry.getKey().isAssignableFrom(beanType)) continue;
                    BeanKey<T> beanKey = new BeanKey<T>(beanDefinition, finalQualifier);
                    for (BeanCreatedEventListener listener : entry.getValue().get(resolutionContext)) {
                        bean = listener.onCreated(new BeanCreatedEvent<T>(this, beanDefinition, beanKey, bean));
                        if (bean != null) continue;
                        throw new BeanInstantiationException(resolutionContext, "Listener [" + listener + "] returned null from onCreated event");
                    }
                }
            }
        }
        return bean;
    }

    @NonNull
    private <T> Map<String, Object> getRequiredArgumentValues(@NonNull BeanResolutionContext resolutionContext, @NonNull Argument<?>[] requiredArguments, @Nullable Map<String, Object> argumentValues, @NonNull BeanDefinition<T> beanDefinition) {
        LinkedHashMap<String, Object> convertedValues;
        if (argumentValues == null) {
            convertedValues = requiredArguments.length == 0 ? null : CollectionUtils.newLinkedHashMap(requiredArguments.length);
            argumentValues = Collections.emptyMap();
        } else {
            convertedValues = CollectionUtils.newLinkedHashMap(requiredArguments.length);
        }
        if (convertedValues == null) {
            return Collections.emptyMap();
        }
        MutableConversionService conversionService = this.getConversionService();
        for (Argument<?> requiredArgument : requiredArguments) {
            String argumentName = requiredArgument.getName();
            Object val = argumentValues.get(argumentName);
            if (val == null) {
                if (requiredArgument.isDeclaredNullable()) continue;
                throw new BeanInstantiationException(resolutionContext, "Missing bean argument [" + requiredArgument + "] for type: " + beanDefinition.getBeanType().getName() + ". Required arguments: " + ArrayUtils.toString(requiredArguments));
            }
            Object convertedValue = requiredArgument.getType().isInstance(val) ? val : conversionService.convert(val, requiredArgument).orElseThrow(() -> new BeanInstantiationException(resolutionContext, "Invalid bean argument [" + requiredArgument + "]. Cannot convert object [" + val + "] to required type: " + requiredArgument.getType()));
            convertedValues.put(argumentName, convertedValue);
        }
        return convertedValues;
    }

    @NonNull
    protected <T> BeanDefinition<T> findConcreteCandidate(@NonNull Class<T> beanType, @Nullable Qualifier<T> qualifier, @NonNull Collection<BeanDefinition<T>> candidates) {
        if (qualifier instanceof AnyQualifier) {
            return candidates.iterator().next();
        }
        throw new NonUniqueBeanException(beanType, candidates.iterator());
    }

    @Internal
    protected void processParallelBeans(List<BeanDefinitionProducer> parallelBeans) {
        List<BeanDefinitionProducer> finalParallelBeans;
        if (!parallelBeans.isEmpty() && !(finalParallelBeans = parallelBeans.stream().filter(p -> p.isReferenceEnabled(this)).toList()).isEmpty()) {
            new Thread(() -> {
                ArrayList<BeanDefinition<BeanDefinition>> parallelDefinitions = new ArrayList<BeanDefinition<BeanDefinition>>();
                finalParallelBeans.forEach(producer -> {
                    block2: {
                        try {
                            this.loadEagerBeans((BeanDefinitionProducer)producer, (Collection<BeanDefinition<Object>>)parallelDefinitions);
                        }
                        catch (Throwable e) {
                            BeanDefinitionReference beanDefinitionReference = producer.getReference();
                            LOG.error("Parallel Bean definition [" + beanDefinitionReference.getName() + MSG_COULD_NOT_BE_LOADED + e.getMessage(), e);
                            Boolean shutdownOnError = beanDefinitionReference.getAnnotationMetadata().booleanValue(Parallel.class, "shutdownOnError").orElse(true);
                            if (!shutdownOnError.booleanValue()) break block2;
                            this.stop();
                        }
                    }
                });
                this.filterReplacedBeans(null, parallelDefinitions);
                parallelDefinitions.forEach(beanDefinition -> ForkJoinPool.commonPool().execute(() -> {
                    block2: {
                        try {
                            this.initializeEagerBean((BeanDefinition<Object>)beanDefinition);
                        }
                        catch (Throwable e) {
                            LOG.error("Parallel Bean definition [" + beanDefinition.getName() + MSG_COULD_NOT_BE_LOADED + e.getMessage(), e);
                            Boolean shutdownOnError = beanDefinition.getAnnotationMetadata().booleanValue(Parallel.class, "shutdownOnError").orElse(true);
                            if (!shutdownOnError.booleanValue()) break block2;
                            this.stop();
                        }
                    }
                }));
                parallelDefinitions.clear();
            }).start();
        }
    }

    private <T> void filterReplacedBeans(BeanResolutionContext resolutionContext, Collection<BeanDefinition<T>> candidates) {
        if (candidates.size() > 1) {
            ArrayList replacementTypes = new ArrayList(2);
            for (BeanDefinition<T> candidate : candidates) {
                if (!candidate.getAnnotationMetadata().hasStereotype(REPLACES_ANN)) continue;
                replacementTypes.add(candidate);
            }
            if (!replacementTypes.isEmpty()) {
                candidates.removeIf(definition -> this.checkIfReplacementExists(resolutionContext, replacementTypes, (BeanDefinition)definition));
            }
        }
    }

    private <T> boolean checkIfReplacementExists(BeanResolutionContext resolutionContext, List<BeanDefinition<T>> replacementTypes, BeanDefinition<T> definitionToBeReplaced) {
        if (!definitionToBeReplaced.isEnabled(this, resolutionContext)) {
            return true;
        }
        AnnotationMetadata annotationMetadata = definitionToBeReplaced.getAnnotationMetadata();
        if (annotationMetadata.hasDeclaredStereotype((Class<? extends Annotation>)Infrastructure.class)) {
            return false;
        }
        for (BeanDefinition<T> replacementType : replacementTypes) {
            if (!this.isNotTheSameDefinition(replacementType, definitionToBeReplaced) || !this.isNotProxy(replacementType, definitionToBeReplaced) || !this.checkIfReplaces(replacementType, definitionToBeReplaced, annotationMetadata)) continue;
            return true;
        }
        return false;
    }

    private <T> boolean isNotTheSameDefinition(BeanDefinition<T> replacingCandidate, BeanDefinition<T> definitionToBeReplaced) {
        BeanDefinitionDelegate beanDefinitionDelegate;
        if (replacingCandidate instanceof BeanDefinitionDelegate) {
            beanDefinitionDelegate = (BeanDefinitionDelegate)replacingCandidate;
            replacingCandidate = beanDefinitionDelegate.getDelegate();
        }
        if (definitionToBeReplaced instanceof BeanDefinitionDelegate) {
            beanDefinitionDelegate = (BeanDefinitionDelegate)definitionToBeReplaced;
            definitionToBeReplaced = beanDefinitionDelegate.getDelegate();
        }
        return replacingCandidate != definitionToBeReplaced;
    }

    private <T> boolean isNotProxy(BeanDefinition<T> replacingCandidate, BeanDefinition<T> definitionToBeReplaced) {
        return !(replacingCandidate instanceof ProxyBeanDefinition) || ((ProxyBeanDefinition)replacingCandidate).getTargetDefinitionType() != definitionToBeReplaced.getClass();
    }

    private <T> boolean checkIfReplaces(BeanDefinition<T> replacingCandidate, BeanDefinition<T> definitionToBeReplaced, AnnotationMetadata annotationMetadata) {
        AnnotationValue<Replaces> replacesAnnotation = replacingCandidate.getAnnotation(Replaces.class);
        Class<T> replacedBeanType = replacesAnnotation.classValue("bean").orElse(this.getCanonicalBeanType(replacingCandidate));
        Optional<String> named = replacesAnnotation.stringValue("named");
        Optional<AnnotationClassValue<?>> qualifier = replacesAnnotation.annotationClassValue("qualifier");
        if (named.isPresent() && qualifier.isPresent()) {
            throw new ConfigurationException("Both \"named\" and \"qualifier\" should not be present: " + replacesAnnotation);
        }
        if (named.isPresent()) {
            String name = named.get();
            if (this.qualifiedByNamed(definitionToBeReplaced, replacedBeanType, name)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Bean [{}] replaces existing bean of type [{}] qualified by name [{}]", replacingCandidate.getBeanType(), definitionToBeReplaced.getBeanType(), name);
                }
                return true;
            }
            return false;
        }
        if (qualifier.isPresent()) {
            AnnotationClassValue<?> qualifierClassValue = qualifier.get();
            if (this.qualifiedByQualifier(definitionToBeReplaced, replacedBeanType, qualifierClassValue)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Bean [{}] replaces existing bean of type [{}] qualified by qualifier [{}]", replacingCandidate.getBeanType(), definitionToBeReplaced.getBeanType(), qualifierClassValue);
                }
                return true;
            }
            return false;
        }
        Optional<Class<?>> factory = replacesAnnotation.classValue("factory");
        if (factory.isPresent()) {
            Optional<Class<?>> declaringType = definitionToBeReplaced.getDeclaringType();
            if (declaringType.isPresent()) {
                boolean factoryReplaces;
                Class<?> factoryClass = factory.get();
                boolean bl = factoryReplaces = factoryClass == declaringType.get() && this.checkIfTypeMatches(definitionToBeReplaced, annotationMetadata, replacedBeanType);
                if (factoryReplaces) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Bean [{}] replaces existing bean of type [{}] in factory type [{}]", replacingCandidate.getBeanType(), replacedBeanType, factoryClass);
                    }
                    return true;
                }
            }
            return false;
        }
        boolean isTypeMatches = this.checkIfTypeMatches(definitionToBeReplaced, annotationMetadata, replacedBeanType);
        if (isTypeMatches && LOG.isDebugEnabled()) {
            LOG.debug("Bean [{}] replaces existing bean of type [{}]", (Object)replacingCandidate.getBeanType(), (Object)replacedBeanType);
        }
        return isTypeMatches;
    }

    private <T> boolean qualifiedByQualifier(BeanDefinition<T> definitionToBeReplaced, Class<T> replacedBeanType, AnnotationClassValue<?> qualifier) {
        Class qualifierClass = qualifier.getType().orElse(null);
        if (qualifierClass != null && !qualifierClass.isAssignableFrom(Annotation.class)) {
            return Qualifiers.byStereotype(qualifierClass).qualify(replacedBeanType, Stream.of(definitionToBeReplaced)).isPresent();
        }
        throw new ConfigurationException("Default qualifier value was used while replacing %s".formatted(replacedBeanType));
    }

    private <T> boolean qualifiedByNamed(BeanType<T> definitionToBeReplaced, Class replacedBeanType, String named) {
        return Qualifiers.byName(named).qualify(replacedBeanType, Stream.of(definitionToBeReplaced)).isPresent();
    }

    private <T> Class<T> getCanonicalBeanType(BeanDefinition<T> beanDefinition) {
        if (beanDefinition instanceof BeanDefinitionDelegate) {
            BeanDefinitionDelegate beanDefinitionDelegate = (BeanDefinitionDelegate)beanDefinition;
            beanDefinition = beanDefinitionDelegate.getDelegate();
        }
        if (beanDefinition instanceof AdvisedBeanType) {
            AdvisedBeanType advisedBeanType = (AdvisedBeanType)((Object)beanDefinition);
            return advisedBeanType.getInterceptedType();
        }
        if (beanDefinition instanceof ProxyBeanDefinition) {
            ProxyBeanDefinition proxyBeanDefinition = (ProxyBeanDefinition)beanDefinition;
            return proxyBeanDefinition.getTargetType();
        }
        return beanDefinition.getBeanType();
    }

    private <T> boolean checkIfTypeMatches(BeanDefinition<T> definitionToBeReplaced, AnnotationMetadata annotationMetadata, Class replacingCandidate) {
        Class bt = this.getCanonicalBeanType(definitionToBeReplaced);
        if (annotationMetadata.hasAnnotation(DefaultImplementation.class)) {
            Optional<Class> defaultImpl = annotationMetadata.classValue(DefaultImplementation.class);
            if (defaultImpl.isEmpty()) {
                defaultImpl = annotationMetadata.classValue(DefaultImplementation.class, "name");
            }
            if (defaultImpl.filter(impl -> impl == bt).isPresent()) {
                return replacingCandidate.isAssignableFrom(bt);
            }
            return replacingCandidate == bt;
        }
        return replacingCandidate != Object.class && replacingCandidate.isAssignableFrom(bt);
    }

    private <T> void doInjectAndInitialize(BeanResolutionContext resolutionContext, T instance, BeanDefinition<T> beanDefinition) {
        if (beanDefinition instanceof InjectableBeanDefinition) {
            InjectableBeanDefinition injectableBeanDefinition = (InjectableBeanDefinition)beanDefinition;
            injectableBeanDefinition.inject(resolutionContext, this, instance);
            if (beanDefinition instanceof InitializingBeanDefinition) {
                InitializingBeanDefinition initializingBeanDefinition = (InitializingBeanDefinition)beanDefinition;
                initializingBeanDefinition.initialize(resolutionContext, this, instance);
            }
        } else {
            throw new BeanContextException(MSG_BEAN_DEFINITION + beanDefinition + "] doesn't support injection!");
        }
    }

    private void loadEagerBeans(BeanDefinitionProducer producer, Collection<BeanDefinition<Object>> collector) {
        if (producer.isReferenceEnabled(this)) {
            BeanDefinitionReference reference = producer.getReference();
            BeanDefinition beanDefinition = reference.load(this);
            try (BeanResolutionContext resolutionContext = this.newResolutionContext(beanDefinition, null);){
                if (beanDefinition.isEnabled(this, resolutionContext)) {
                    collector.add(beanDefinition);
                }
            }
        }
    }

    private void initializeEagerBean(BeanDefinition<Object> beanDefinition) {
        if (beanDefinition.isIterable() || beanDefinition.hasStereotype(ConfigurationReader.class.getName())) {
            HashSet beanCandidates = new HashSet(5);
            this.collectIterableBeans(null, beanDefinition, beanCandidates);
            for (BeanDefinition beanDefinition2 : beanCandidates) {
                this.findOrCreateSingletonBeanRegistration(null, beanDefinition2, beanDefinition2.asArgument(), beanDefinition2.hasAnnotation(Context.class) ? null : beanDefinition.getDeclaredQualifier());
            }
        } else {
            this.findOrCreateSingletonBeanRegistration(null, beanDefinition, beanDefinition.asArgument(), null);
        }
    }

    @Nullable
    private <T> BeanRegistration<T> resolveBeanRegistration(@Nullable BeanResolutionContext resolutionContext, @NonNull Argument<T> beanType, @Nullable Qualifier<T> qualifier, boolean throwNoSuchBean) {
        BeanRegistration<T> registration;
        BeanRegistration inFlightBeanRegistration;
        Class beanClass = beanType.getType();
        if (this.thisInterfaces.contains(beanClass)) {
            return new BeanRegistration<DefaultBeanContext>(BeanIdentifier.of(beanClass.getName()), null, this);
        }
        if (InjectionPoint.class.isAssignableFrom(beanClass)) {
            return this.provideInjectionPoint(resolutionContext, beanType, qualifier, throwNoSuchBean);
        }
        BeanKey<T> beanKey = new BeanKey<T>(beanType, qualifier);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Looking up existing bean for key: {}", (Object)beanKey);
        }
        BeanRegistration beanRegistration = inFlightBeanRegistration = resolutionContext != null ? resolutionContext.getInFlightBean(beanKey) : null;
        if (inFlightBeanRegistration != null) {
            return inFlightBeanRegistration;
        }
        BeanRegistration<T> beanRegistration2 = this.singletonScope.findCachedSingletonBeanRegistration(beanType, qualifier);
        if (beanRegistration2 != null) {
            return beanRegistration2;
        }
        Optional<BeanDefinition<T>> concreteCandidate = this.findBeanDefinition(resolutionContext, beanType, qualifier);
        if (concreteCandidate.isPresent()) {
            BeanDefinition<T> definition = concreteCandidate.get();
            if (definition.isContainerType() && beanClass != definition.getBeanType()) {
                throw new NonUniqueBeanException(beanClass, Collections.singletonList(definition).iterator());
            }
            registration = this.resolveBeanRegistration(resolutionContext, definition, beanType, qualifier);
        } else {
            registration = null;
        }
        if ((registration == null || registration.bean == null) && throwNoSuchBean) {
            throw this.newNoSuchBeanException(resolutionContext, beanType, qualifier, null);
        }
        return registration;
    }

    private <T> Optional<BeanDefinition<T>> findBeanDefinition(BeanResolutionContext resolutionContext, Argument<T> beanType, Qualifier<T> qualifier) {
        BeanDefinition<T> beanDefinition = this.singletonScope.findCachedSingletonBeanDefinition(beanType, qualifier);
        if (beanDefinition != null) {
            return Optional.of(beanDefinition);
        }
        return this.findConcreteCandidate(resolutionContext, beanType, qualifier, true);
    }

    @Internal
    @NonNull
    protected <T> NoSuchBeanException newNoSuchBeanException(@Nullable BeanResolutionContext resolutionContext, @NonNull Argument<T> beanType, @NonNull Qualifier<T> qualifier, @Nullable String message) {
        if (message != null) {
            return new NoSuchBeanException(beanType, qualifier, message);
        }
        String disabledMessage = this.resolveDisabledBeanMessage(resolutionContext, beanType, qualifier);
        if (disabledMessage != null) {
            return new NoSuchBeanException(beanType, qualifier, disabledMessage);
        }
        return new NoSuchBeanException(beanType, qualifier);
    }

    @Nullable
    protected <T> String resolveDisabledBeanMessage(BeanResolutionContext resolutionContext, Argument<T> beanType, Qualifier<T> qualifier) {
        String disabledMessage = null;
        for (Map.Entry<String, List<String>> entry : this.disabledConfigurations.entrySet()) {
            String pkg = entry.getKey();
            if (!beanType.getTypeName().startsWith(pkg + ".")) continue;
            StringBuilder messageBuilder = new StringBuilder();
            String ls = CachedEnvironment.getProperty("line.separator");
            messageBuilder.append("The bean [").append(beanType.getTypeString(true)).append("] is disabled because it is within the package [").append(pkg).append("] which is disabled due to bean requirements: ").append(ls);
            for (String failure : entry.getValue()) {
                messageBuilder.append("* ").append(failure).append(ls);
            }
            disabledMessage = messageBuilder.toString();
            break;
        }
        if (disabledMessage == null) {
            Set<BeanDefinition<T>> beanDefinitions = this.collectBeanCandidates(resolutionContext, beanType, false, null, this.disabledBeans.values());
            if (qualifier != null) {
                beanDefinitions = qualifier.reduce(beanType.getType(), beanDefinitions.stream()).collect(Collectors.toSet());
            }
            if (!beanDefinitions.isEmpty()) {
                StringBuilder messageBuilder = new StringBuilder();
                String ls = CachedEnvironment.getProperty("line.separator");
                messageBuilder.append("The following matching beans are disabled by bean requirements: ").append(ls);
                for (BeanDefinition<T> beanDefinition : beanDefinitions) {
                    messageBuilder.append("* Bean of type [").append(beanDefinition.asArgument().getTypeString(false)).append("] is disabled because: ").append(ls);
                    if (!(beanDefinition instanceof DisabledBean)) continue;
                    DisabledBean disabledBean = (DisabledBean)beanDefinition;
                    for (String failure : disabledBean.reasons()) {
                        messageBuilder.append("   - ").append(failure).append(ls);
                    }
                }
                disabledMessage = messageBuilder.toString();
            }
        }
        return disabledMessage;
    }

    @Nullable
    private <T> BeanRegistration<T> provideInjectionPoint(BeanResolutionContext resolutionContext, Argument<T> beanType, Qualifier<T> qualifier, boolean throwNoSuchBean) {
        BeanResolutionContext.Path path = resolutionContext != null ? resolutionContext.getPath() : null;
        BeanResolutionContext.Segment injectionPointSegment = null;
        if (CollectionUtils.isNotEmpty(path)) {
            InjectionPoint ip;
            Iterator i = path.iterator();
            injectionPointSegment = (BeanResolutionContext.Segment)i.next();
            BeanResolutionContext.Segment segment = null;
            if (i.hasNext() && (segment = (BeanResolutionContext.Segment)i.next()).getDeclaringType().hasStereotype(INTRODUCTION_TYPE)) {
                BeanResolutionContext.Segment segment2 = segment = i.hasNext() ? (BeanResolutionContext.Segment)i.next() : null;
            }
            if (segment != null && (ip = segment.getInjectionPoint()) != null && beanType.isInstance(ip)) {
                return new BeanRegistration(BeanIdentifier.of(InjectionPoint.class.getName()), null, ip);
            }
        }
        if (injectionPointSegment == null || !injectionPointSegment.getArgument().isNullable()) {
            throw new BeanContextException("Failed to obtain injection point. No valid injection path present in path: " + path);
        }
        if (throwNoSuchBean) {
            throw this.newNoSuchBeanException(resolutionContext, beanType, qualifier, null);
        }
        return null;
    }

    @NonNull
    private <T> BeanRegistration<T> resolveBeanRegistration(@Nullable BeanResolutionContext resolutionContext, @NonNull BeanDefinition<T> definition) {
        return this.resolveBeanRegistration(resolutionContext, definition, definition.asArgument(), definition.getDeclaredQualifier());
    }

    @NonNull
    private <T> BeanRegistration<T> resolveBeanRegistration(@Nullable BeanResolutionContext resolutionContext, @NonNull BeanDefinition<T> definition, @NonNull Argument<T> beanType, @Nullable Qualifier<T> qualifier) {
        boolean isScopedProxyDefinition = definition.hasStereotype(SCOPED_PROXY_ANN);
        if (qualifier != null && AnyQualifier.INSTANCE.equals(definition.getDeclaredQualifier())) {
            definition = BeanDefinitionDelegate.create(definition, qualifier);
        }
        if (definition.isSingleton() && !isScopedProxyDefinition) {
            return this.findOrCreateSingletonBeanRegistration(resolutionContext, definition, beanType, qualifier);
        }
        boolean isProxy = definition.isProxy();
        if (isProxy && isScopedProxyDefinition) {
            Qualifier<T> q = qualifier;
            if (q == null) {
                q = definition.getDeclaredQualifier();
            }
            BeanRegistration<T> registration = this.createRegistration(resolutionContext, beanType, q, definition, true);
            Object bean = registration.bean;
            if (bean instanceof Qualified) {
                ((Qualified)bean).$withBeanQualifier(q);
            }
            return registration;
        }
        CustomScope<?> customScope = this.findCustomScope(resolutionContext, definition, isProxy, isScopedProxyDefinition);
        if (customScope != null) {
            if (isProxy) {
                definition = this.getProxyTargetBeanDefinition(beanType, qualifier);
            }
            return this.getOrCreateScopedRegistration(resolutionContext, customScope, qualifier, beanType, definition);
        }
        return this.createRegistration(resolutionContext, beanType, qualifier, definition, true);
    }

    @NonNull
    private <T> BeanRegistration<T> findOrCreateSingletonBeanRegistration(@Nullable BeanResolutionContext resolutionContext, @NonNull BeanDefinition<T> definition, @NonNull Argument<T> beanType, @Nullable Qualifier<T> qualifier) {
        BeanRegistration<T> beanRegistration = this.singletonScope.findBeanRegistration(definition, beanType, qualifier);
        if (beanRegistration != null) {
            return beanRegistration;
        }
        return this.singletonScope.getOrCreate(this, resolutionContext, definition, beanType, qualifier);
    }

    @Nullable
    private <T> CustomScope<?> findCustomScope(@Nullable BeanResolutionContext resolutionContext, @NonNull BeanDefinition<T> definition, boolean isProxy, boolean isScopedProxyDefinition) {
        Argument argument;
        BeanResolutionContext.Segment currentSegment;
        CustomScope customScope;
        Optional<Class<Annotation>> scope = definition.getScope();
        if (scope.isPresent()) {
            Class<Annotation> scopeAnnotation = scope.get();
            if (scopeAnnotation == Prototype.class) {
                return null;
            }
            CustomScope customScope2 = this.customScopeRegistry.findScope(scopeAnnotation).orElse(null);
            if (customScope2 != null) {
                return customScope2;
            }
        } else {
            Optional<String> scopeName = definition.getScopeName();
            if (scopeName.isPresent()) {
                String scopeAnnotation = scopeName.get();
                if (Prototype.class.getName().equals(scopeAnnotation)) {
                    return null;
                }
                customScope = this.customScopeRegistry.findScope(scopeAnnotation).orElse(null);
                if (customScope != null) {
                    return customScope;
                }
            }
        }
        if (resolutionContext != null && (currentSegment = (BeanResolutionContext.Segment)resolutionContext.getPath().currentSegment().orElse(null)) != null && (customScope = (CustomScope)this.customScopeRegistry.findDeclaredScope(argument = currentSegment.getArgument()).orElse(null)) != null) {
            return customScope;
        }
        if (!isScopedProxyDefinition || !isProxy) {
            return this.customScopeRegistry.findDeclaredScope(definition).orElse(null);
        }
        return null;
    }

    @NonNull
    private <T> BeanRegistration<T> getOrCreateScopedRegistration(final @Nullable BeanResolutionContext resolutionContext, @NonNull CustomScope<?> registeredScope, final @Nullable Qualifier<T> qualifier, @NonNull Argument<T> beanType, final @NonNull BeanDefinition<T> definition) {
        final BeanKey<T> beanKey = new BeanKey<T>(definition.asArgument(), qualifier);
        Object bean = registeredScope.getOrCreate(new BeanCreationContext<T>(){

            @Override
            @NonNull
            public BeanDefinition<T> definition() {
                return definition;
            }

            @Override
            @NonNull
            public BeanIdentifier id() {
                return beanKey;
            }

            @Override
            @NonNull
            public CreatedBean<T> create() throws BeanCreationException {
                return DefaultBeanContext.this.createRegistration(resolutionContext == null ? null : resolutionContext.copy(), beanKey.beanType, qualifier, definition, true);
            }
        });
        return BeanRegistration.of(this, beanKey, definition, bean);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    @Internal
    final <T> BeanRegistration<T> createRegistration(@Nullable BeanResolutionContext resolutionContext, @NonNull Argument<T> beanType, @Nullable Qualifier<T> qualifier, @NonNull BeanDefinition<T> definition, boolean dependent) {
        try (BeanResolutionContext context = this.newResolutionContext(definition, resolutionContext);){
            BeanRegistration<T> beanRegistration;
            block13: {
                BeanResolutionContext.Path path = context.getPath();
                boolean isNewPath = path.isEmpty();
                if (isNewPath) {
                    path.pushBeanCreate(definition, beanType);
                }
                try {
                    List<BeanRegistration<?>> parentDependentBeans = context.popDependentBeans();
                    T bean = this.doCreateBean(context, definition, qualifier);
                    BeanRegistration<?> dependentFactoryBean = context.getAndResetDependentFactoryBean();
                    if (dependentFactoryBean != null) {
                        this.destroyBean(dependentFactoryBean);
                    }
                    BeanKey<T> beanKey = new BeanKey<T>(beanType, qualifier);
                    List<BeanRegistration<?>> dependentBeans = context.getAndResetDependentBeans();
                    BeanRegistration<T> beanRegistration2 = BeanRegistration.of(this, beanKey, definition, bean, dependentBeans);
                    context.pushDependentBeans(parentDependentBeans);
                    if (dependent) {
                        context.addDependentBean(beanRegistration2);
                    }
                    beanRegistration = beanRegistration2;
                    if (!isNewPath) break block13;
                }
                catch (Throwable throwable) {
                    if (isNewPath) {
                        path.pop();
                    }
                    throw throwable;
                }
                path.pop();
            }
            return beanRegistration;
        }
    }

    private <T> Optional<BeanDefinition<T>> findConcreteCandidate(@Nullable BeanResolutionContext resolutionContext, @NonNull Argument<T> beanType, @Nullable Qualifier<T> qualifier, boolean throwNonUnique) {
        if (beanType.getType() == Object.class && qualifier == null) {
            return Optional.empty();
        }
        BeanCandidateKey<T> bk = new BeanCandidateKey<T>(beanType, qualifier, throwNonUnique);
        Optional<BeanDefinition<T>> beanDefinition = this.beanConcreteCandidateCache.get(bk);
        if (beanDefinition == null) {
            beanDefinition = this.findConcreteCandidateNoCache(resolutionContext, beanType, qualifier, throwNonUnique);
            this.beanConcreteCandidateCache.put(bk, beanDefinition);
        }
        return beanDefinition;
    }

    private <T> Optional<BeanDefinition<T>> findConcreteCandidateNoCache(@Nullable BeanResolutionContext resolutionContext, @NonNull Argument<T> beanType, @Nullable Qualifier<T> qualifier, boolean throwNonUnique) {
        Predicate<BeanDefinition<T>> predicate = candidate -> !candidate.isAbstract();
        Collection<BeanDefinition<T>> candidates = this.findBeanCandidates(resolutionContext, beanType, true, predicate);
        return this.pickOneBean(beanType, qualifier, throwNonUnique, candidates);
    }

    private <T> Optional<BeanDefinition<T>> findProxyTargetNoCache(@Nullable BeanResolutionContext resolutionContext, @NonNull Argument<T> beanType, @Nullable Qualifier<T> qualifier) {
        Set<BeanDefinition<T>> candidates = this.collectBeanCandidates(resolutionContext, beanType, true, null, this.proxyTargetBeans);
        return this.pickOneBean(beanType, qualifier, false, candidates);
    }

    @NonNull
    private <T> Optional<BeanDefinition<T>> pickOneBean(Argument<T> beanType, Qualifier<T> qualifier, boolean throwNonUnique, Collection<BeanDefinition<T>> candidates) {
        BeanDefinition<T> definition;
        if (candidates.isEmpty()) {
            return Optional.empty();
        }
        if (qualifier != null) {
            Stream<BeanDefinition<T>> qualified;
            List<BeanDefinition<T>> beanDefinitionList;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Qualifying bean [{}] for qualifier: {} ", (Object)beanType.getName(), (Object)qualifier);
            }
            if ((beanDefinitionList = (qualified = qualifier.reduce(beanType.getType(), candidates.stream())).toList()).isEmpty()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("No qualifying beans of type [{}] found for qualifier: {} ", (Object)beanType.getName(), (Object)qualifier);
                }
                return Optional.empty();
            }
            definition = this.lastChanceResolve(beanType, qualifier, throwNonUnique, beanDefinitionList);
        } else if (candidates.size() == 1) {
            definition = candidates.iterator().next();
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Searching for @Primary for type [{}] from candidates: {} ", (Object)beanType.getName(), (Object)candidates);
            }
            definition = this.lastChanceResolve(beanType, null, throwNonUnique, candidates);
        }
        if (LOG.isDebugEnabled() && definition != null) {
            if (qualifier != null) {
                LOG.debug("Found concrete candidate [{}] for type: {} {} ", definition, qualifier, beanType.getName());
            } else {
                LOG.debug("Found concrete candidate [{}] for type: {} ", (Object)definition, (Object)beanType.getName());
            }
        }
        return Optional.ofNullable(definition);
    }

    private <T> BeanDefinition<T> lastChanceResolve(Argument<T> beanType, Qualifier<T> qualifier, boolean throwNonUnique, Collection<BeanDefinition<T>> candidates) {
        List<BeanDefinition> primary;
        Class beanClass = beanType.getType();
        if (candidates.size() > 1 && !(primary = candidates.stream().filter(BeanType::isPrimary).toList()).isEmpty()) {
            candidates = primary;
        }
        if (candidates.size() == 1) {
            return candidates.iterator().next();
        }
        BeanDefinition definition = null;
        if ((candidates = candidates.stream().filter(candidate -> !candidate.hasDeclaredStereotype((Class<? extends Annotation>)Secondary.class)).toList()).size() == 1) {
            return candidates.iterator().next();
        }
        if (candidates.stream().anyMatch(candidate -> candidate.hasAnnotation(Order.class))) {
            Iterator i = candidates.stream().sorted((bean1, bean2) -> {
                int order1 = OrderUtil.getOrder(bean1.getAnnotationMetadata());
                int order2 = OrderUtil.getOrder(bean2.getAnnotationMetadata());
                return Integer.compare(order1, order2);
            }).iterator();
            if (i.hasNext()) {
                BeanDefinition bean = (BeanDefinition)i.next();
                if (i.hasNext()) {
                    BeanDefinition next = (BeanDefinition)i.next();
                    if (OrderUtil.getOrder(bean.getAnnotationMetadata()) == OrderUtil.getOrder(next.getAnnotationMetadata())) {
                        throw new NonUniqueBeanException(beanType.getType(), candidates.iterator());
                    }
                }
                LOG.debug("Picked bean {} with the highest precedence for type {} and qualifier {}", bean, beanType, qualifier);
                return bean;
            }
            throw new NonUniqueBeanException(beanType.getType(), candidates.iterator());
        }
        Collection exactMatches = this.filterExactMatch(beanClass, candidates);
        if (exactMatches.size() == 1) {
            definition = exactMatches.iterator().next();
        } else if (throwNonUnique) {
            definition = this.findConcreteCandidate(beanClass, qualifier, candidates);
        }
        return definition;
    }

    private void readAllBeanConfigurations() {
        Iterable<BeanConfiguration> beanConfigurations = this.resolveBeanConfigurations();
        for (BeanConfiguration beanConfiguration : beanConfigurations) {
            this.registerConfiguration(beanConfiguration);
        }
    }

    private <T> Collection<BeanDefinition<T>> filterExactMatch(Class<T> beanType, Collection<BeanDefinition<T>> candidates) {
        ArrayList<BeanDefinition<T>> list = new ArrayList<BeanDefinition<T>>(candidates.size());
        for (BeanDefinition<T> candidate : candidates) {
            if (candidate.getBeanType() != beanType) continue;
            list.add(candidate);
        }
        return list;
    }

    private void readAllBeanDefinitionClasses() {
        ArrayList<BeanDefinitionProducer> eagerInitBeans = new ArrayList<BeanDefinitionProducer>(20);
        ArrayList<BeanDefinitionProducer> processedBeans = new ArrayList<BeanDefinitionProducer>(10);
        ArrayList<BeanDefinitionProducer> parallelBeans = new ArrayList<BeanDefinitionProducer>(10);
        List<BeanDefinitionReference> beanDefinitionReferences = this.resolveBeanDefinitionReferences();
        ArrayList<BeanDefinitionProducer> producers = new ArrayList<BeanDefinitionProducer>(beanDefinitionReferences.size());
        ArrayList<BeanDefinitionProducer> proxyTargetBeans = new ArrayList<BeanDefinitionProducer>(beanDefinitionReferences.size());
        for (BeanDefinitionReference beanDefinitionReference : beanDefinitionReferences) {
            producers.add(new BeanDefinitionProducer(beanDefinitionReference));
        }
        this.beanDefinitionsClasses.addAll(producers);
        Collection<BeanConfiguration> allConfigurations = this.beanConfigurations.values();
        ArrayList<BeanConfiguration> configurationsDisabled = new ArrayList<BeanConfiguration>(allConfigurations.size());
        for (BeanConfiguration bc : allConfigurations) {
            if (bc.isEnabled(this)) continue;
            configurationsDisabled.add(bc);
        }
        block2: for (BeanDefinitionProducer beanDefinitionProducer : producers) {
            Class aClass;
            if (beanDefinitionProducer.isDisabled()) continue;
            BeanDefinitionReference beanDefinitionReference = beanDefinitionProducer.reference;
            for (BeanConfiguration disableConfiguration : configurationsDisabled) {
                if (!disableConfiguration.isWithin(beanDefinitionReference)) continue;
                beanDefinitionProducer.referenceEnabled = false;
                continue block2;
            }
            if (beanDefinitionReference.isProxiedBean()) {
                beanDefinitionProducer.referenceEnabled = false;
                BeanDefinitionProducer proxyBeanProducer = new BeanDefinitionProducer(beanDefinitionReference);
                if (!beanDefinitionReference.isProxyTarget()) continue;
                proxyTargetBeans.add(proxyBeanProducer);
                continue;
            }
            AnnotationMetadata annotationMetadata = beanDefinitionReference.getAnnotationMetadata();
            Class<T>[] indexes = annotationMetadata.classValues(INDEXES_TYPE);
            if (indexes.length > 0) {
                for (int i = 0; i < indexes.length; ++i) {
                    Class indexedType = indexes[i];
                    this.resolveTypeIndex(indexedType).add(beanDefinitionProducer);
                }
            } else if (annotationMetadata.hasStereotype(ADAPTER_TYPE) && this.indexedTypes.contains(aClass = (Class)annotationMetadata.classValue(ADAPTER_TYPE, "value").orElse(null))) {
                this.resolveTypeIndex(aClass).add(beanDefinitionProducer);
            }
            if (this.isEagerInit(beanDefinitionReference)) {
                eagerInitBeans.add(beanDefinitionProducer);
            } else if (annotationMetadata.hasDeclaredStereotype(PARALLEL_TYPE)) {
                parallelBeans.add(beanDefinitionProducer);
            }
            if (!beanDefinitionReference.requiresMethodProcessing()) continue;
            processedBeans.add(beanDefinitionProducer);
        }
        this.beanDefinitionReferences = null;
        this.beanConfigurationsList = null;
        this.proxyTargetBeans.addAll(proxyTargetBeans);
        this.initializeEventListeners();
        this.initializeContext(eagerInitBeans, processedBeans, parallelBeans);
    }

    private boolean isEagerInit(BeanDefinitionReference beanDefinitionReference) {
        return beanDefinitionReference.isContextScope() || this.eagerInitSingletons && beanDefinitionReference.isSingleton() || this.eagerInitStereotypesPresent && beanDefinitionReference.getAnnotationMetadata().hasDeclaredStereotype(this.eagerInitStereotypes);
    }

    @NonNull
    private Collection<BeanDefinitionProducer> resolveTypeIndex(Class<?> indexedType) {
        return this.beanIndex.computeIfAbsent(indexedType, aClass -> {
            this.indexedTypes.add(indexedType);
            return new ArrayList(20);
        });
    }

    private <T> Collection<BeanDefinition<T>> findBeanCandidatesInternal(BeanResolutionContext resolutionContext, Argument<T> beanType) {
        Collection<BeanDefinition<T>> beanDefinitions = this.beanCandidateCache.get(beanType);
        if (beanDefinitions == null) {
            beanDefinitions = this.findBeanCandidates(resolutionContext, beanType, true, null);
            this.beanCandidateCache.put(beanType, beanDefinitions);
        }
        return beanDefinitions;
    }

    @Internal
    public <T> BeanRegistration<T> getBeanRegistration(@Nullable BeanResolutionContext resolutionContext, @NonNull Argument<T> beanType, @Nullable Qualifier<T> qualifier) {
        return this.resolveBeanRegistration(resolutionContext, beanType, qualifier, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Internal
    public <T> Collection<BeanRegistration<T>> getBeanRegistrations(@Nullable BeanResolutionContext resolutionContext, @NonNull Argument<T> beanType, @Nullable Qualifier<T> qualifier) {
        Collection<BeanRegistration<T>> beanRegistrations;
        CollectionHolder existing;
        boolean hasQualifier;
        boolean bl = hasQualifier = qualifier != null;
        if (LOG.isDebugEnabled()) {
            if (hasQualifier) {
                LOG.debug("Resolving beans for type: {} {} ", (Object)qualifier, (Object)beanType.getTypeName());
            } else {
                LOG.debug("Resolving beans for type: {}", (Object)beanType.getTypeName());
            }
        }
        BeanKey<T> key = new BeanKey<T>(beanType, qualifier);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Looking up existing beans for key: {}", (Object)key);
        }
        if ((existing = this.singletonBeanRegistrations.get(key)) != null && existing.registrations != null) {
            this.logResolvedExistingBeanRegistrations(beanType, qualifier, existing.registrations);
            return existing.registrations;
        }
        Collection<BeanDefinition<T>> beanDefinitions = this.findBeanCandidatesInternal(resolutionContext, beanType);
        if (!beanDefinitions.isEmpty()) {
            Stream<BeanDefinition<T>> candidateStream = this.applyBeanResolutionFilters(resolutionContext, beanDefinitions.stream());
            if (qualifier != null) {
                candidateStream = qualifier.reduce(beanType.getType(), candidateStream);
            }
            beanDefinitions = candidateStream.toList();
        }
        if (beanDefinitions.isEmpty()) {
            beanRegistrations = Collections.emptySet();
        } else {
            boolean allCandidatesAreSingleton = true;
            for (BeanDefinition<T> definition : beanDefinitions) {
                if (definition.isSingleton()) continue;
                allCandidatesAreSingleton = false;
            }
            if (allCandidatesAreSingleton) {
                CollectionHolder holder;
                CollectionHolder collectionHolder = holder = this.singletonBeanRegistrations.computeIfAbsent(key, beanKey -> new CollectionHolder());
                synchronized (collectionHolder) {
                    if (holder.registrations != null) {
                        this.logResolvedExistingBeanRegistrations(beanType, qualifier, holder.registrations);
                        return holder.registrations;
                    }
                    holder.registrations = this.resolveBeanRegistrations(resolutionContext, beanDefinitions, beanType, qualifier);
                    return holder.registrations;
                }
            }
            beanRegistrations = this.resolveBeanRegistrations(resolutionContext, beanDefinitions, beanType, qualifier);
        }
        if (LOG.isDebugEnabled() && !beanRegistrations.isEmpty()) {
            if (hasQualifier) {
                LOG.debug("Found {} bean registrations for type [{} {}]", beanRegistrations.size(), qualifier, beanType.getName());
            } else {
                LOG.debug("Found {} bean registrations for type [{}]", (Object)beanRegistrations.size(), (Object)beanType.getName());
            }
            for (BeanRegistration<T> beanRegistration : beanRegistrations) {
                LOG.debug("  {} {}", (Object)beanRegistration.definition(), (Object)beanRegistration.definition().getDeclaredQualifier());
            }
        }
        return beanRegistrations;
    }

    private <T> Collection<BeanRegistration<T>> resolveBeanRegistrations(BeanResolutionContext resolutionContext, Collection<BeanDefinition<T>> beanDefinitions, Argument<T> beanType, Qualifier<T> qualifier) {
        boolean hasOrderAnnotation = false;
        HashSet<BeanRegistration<T>> beansOfTypeList = new HashSet<BeanRegistration<T>>();
        for (BeanDefinition<T> definition : beanDefinitions) {
            if (!hasOrderAnnotation && definition.hasAnnotation(Order.class)) {
                hasOrderAnnotation = true;
            }
            this.addCandidateToList(resolutionContext, definition, beanType, qualifier, beansOfTypeList);
        }
        if (beansOfTypeList != Collections.EMPTY_SET) {
            if (Ordered.class.isAssignableFrom(beanType.getType())) {
                return beansOfTypeList.stream().sorted(OrderUtil.COMPARATOR).toList();
            }
            if (hasOrderAnnotation) {
                return beansOfTypeList.stream().sorted(BEAN_REGISTRATION_COMPARATOR).toList();
            }
        }
        return beansOfTypeList;
    }

    private <T> void logResolvedExistingBeanRegistrations(Argument<T> beanType, Qualifier<T> qualifier, Collection<BeanRegistration<T>> existing) {
        if (LOG.isDebugEnabled()) {
            if (qualifier == null) {
                LOG.debug("Found {} existing beans for type [{}]: {} ", existing.size(), beanType.getName(), existing);
            } else {
                LOG.debug("Found {} existing beans for type [{} {}]: {} ", existing.size(), qualifier, beanType.getName(), existing);
            }
        }
    }

    private <T> Stream<BeanDefinition<T>> applyBeanResolutionFilters(@Nullable BeanResolutionContext resolutionContext, Stream<BeanDefinition<T>> candidateStream) {
        BeanResolutionContext.Segment segment;
        BeanResolutionContext.Segment segment2 = segment = resolutionContext != null ? (BeanResolutionContext.Segment)resolutionContext.getPath().peek() : null;
        if (segment instanceof AbstractBeanResolutionContext.ConstructorSegment || segment instanceof AbstractBeanResolutionContext.MethodSegment) {
            BeanDefinition declaringBean = segment.getDeclaringType();
            candidateStream = candidateStream.filter(c -> {
                if (c.equals(declaringBean)) {
                    return false;
                }
                if (declaringBean instanceof ProxyBeanDefinition) {
                    ProxyBeanDefinition proxyBeanDefinition = (ProxyBeanDefinition)declaringBean;
                    return !proxyBeanDefinition.getTargetDefinitionType().equals(c.getClass());
                }
                return true;
            });
        }
        return candidateStream.filter(c -> !c.isAbstract());
    }

    private <T> void addCandidateToList(@Nullable BeanResolutionContext resolutionContext, @NonNull BeanDefinition<T> candidate, @NonNull Argument<T> beanType, @Nullable Qualifier<T> qualifier, @NonNull Collection<BeanRegistration<T>> beansOfTypeList) {
        BeanRegistration<T> beanRegistration;
        block9: {
            beanRegistration = null;
            try {
                beanRegistration = this.resolveBeanRegistration(resolutionContext, candidate);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Found a registration {} for candidate: {} with qualifier: {}", beanRegistration, candidate, qualifier);
                }
            }
            catch (DisabledBeanException e) {
                if (!AbstractBeanContextConditional.ConditionLog.LOG.isDebugEnabled()) break block9;
                AbstractBeanContextConditional.ConditionLog.LOG.debug("Bean of type [{}] disabled for reason: {}", (Object)beanType.getTypeName(), (Object)e.getMessage());
            }
        }
        if (beanRegistration != null) {
            if (candidate.isContainerType()) {
                Object container = beanRegistration.bean;
                if (container instanceof Object[]) {
                    Object[] array = (Object[])container;
                    container = Arrays.asList(array);
                }
                if (container instanceof Iterable) {
                    Iterable iterable = (Iterable)container;
                    int i = 0;
                    for (Object o : iterable) {
                        if (o == null || !beanType.isInstance(o)) continue;
                        beansOfTypeList.add(BeanRegistration.of(this, new BeanKey<T>(beanType, Qualifiers.byQualifiers(Qualifiers.byName(String.valueOf(i++)), qualifier)), candidate, o));
                    }
                }
            } else {
                beansOfTypeList.add(beanRegistration);
            }
        }
    }

    private <T> boolean isCandidatePresent(Argument<T> beanType, Qualifier<T> qualifier) {
        Collection<BeanDefinition<T>> candidates = this.findBeanCandidates(null, beanType, true, null);
        if (!candidates.isEmpty()) {
            this.filterReplacedBeans(null, candidates);
            Stream<BeanDefinition<T>> stream = candidates.stream();
            if (qualifier != null && !(qualifier instanceof AnyQualifier)) {
                stream = qualifier.reduce(beanType.getType(), stream);
            }
            return stream.findAny().isPresent();
        }
        return false;
    }

    private static <T> List<T> nullSafe(List<T> list) {
        if (list == null) {
            return Collections.emptyList();
        }
        return list;
    }

    private List<BeanRegistration> topologicalSort(Collection<BeanRegistration> beans) {
        Map<Boolean, List<BeanRegistration>> initial = beans.stream().sorted(Comparator.comparing(s -> s.getBeanDefinition().getRequiredComponents().size())).collect(Collectors.groupingBy(b -> b.getBeanDefinition().getRequiredComponents().isEmpty()));
        ArrayList<BeanRegistration> sorted = new ArrayList<BeanRegistration>(DefaultBeanContext.nullSafe(initial.get(true)));
        ArrayList<BeanRegistration> unsorted = new ArrayList<BeanRegistration>(DefaultBeanContext.nullSafe(initial.get(false)));
        HashSet satisfied = new HashSet();
        HashSet unsatisfied = new HashSet();
        while (!unsorted.isEmpty()) {
            boolean acyclic = false;
            unsatisfied.clear();
            Iterator i = unsorted.iterator();
            while (i.hasNext()) {
                BeanRegistration bean = (BeanRegistration)i.next();
                boolean found = false;
                Collection<Class<?>> components = bean.getBeanDefinition().getRequiredComponents();
                for (Class<?> clazz : components) {
                    block6: {
                        block5: {
                            if (satisfied.contains(clazz)) continue;
                            if (unsatisfied.contains(clazz)) break block5;
                            if (!unsorted.stream().map(BeanRegistration::getBeanDefinition).map(BeanDefinition::getBeanType).anyMatch(clazz::isAssignableFrom)) break block6;
                        }
                        found = true;
                        unsatisfied.add(clazz);
                        break;
                    }
                    satisfied.add(clazz);
                }
                if (found) continue;
                acyclic = true;
                i.remove();
                sorted.add(0, bean);
            }
            if (acyclic) continue;
            sorted.add(0, (BeanRegistration)unsorted.remove(0));
        }
        return sorted;
    }

    @Override
    @NonNull
    public MutableConvertibleValues<Object> getAttributes() {
        return MutableConvertibleValues.of(this.attributes);
    }

    @Override
    @NonNull
    public Optional<Object> getAttribute(CharSequence name) {
        if (name != null) {
            return Optional.ofNullable(this.attributes.get(name));
        }
        return Optional.empty();
    }

    @Override
    @NonNull
    public <T> Optional<T> getAttribute(CharSequence name, Class<T> type) {
        if (name != null) {
            Object o = this.attributes.get(name);
            if (type.isInstance(o)) {
                return Optional.of(o);
            }
            if (o != null) {
                return this.getConversionService().convert(o, type);
            }
        }
        return Optional.empty();
    }

    @Override
    @NonNull
    public BeanContext setAttribute(@NonNull CharSequence name, @Nullable Object value) {
        if (name != null) {
            if (value != null) {
                this.attributes.put(name, value);
            } else {
                this.attributes.remove(name);
            }
        }
        return this;
    }

    @Override
    @NonNull
    public <T> Optional<T> removeAttribute(@NonNull CharSequence name, @NonNull Class<T> type) {
        Object o = this.attributes.remove(name);
        if (type.isInstance(o)) {
            return Optional.of(o);
        }
        return Optional.empty();
    }

    @Override
    public void finalizeConfiguration() {
        this.readAllBeanConfigurations();
        this.readAllBeanDefinitionClasses();
    }

    @Override
    public MutableConversionService getConversionService() {
        return this.conversionService;
    }

    static final class BeanKey<T>
    implements BeanIdentifier {
        final Argument<T> beanType;
        private final Qualifier<T> qualifier;
        private final int hashCode;

        BeanKey(BeanDefinition<T> definition, Qualifier<T> qualifier) {
            this(definition.asArgument(), qualifier);
        }

        BeanKey(Argument<T> argument, Qualifier<T> qualifier) {
            this.beanType = argument;
            this.qualifier = qualifier;
            this.hashCode = argument.typeHashCode();
        }

        BeanKey(Class<T> beanType, Qualifier<T> qualifier, Class<?> ... typeArguments) {
            this(Argument.of(beanType, typeArguments), qualifier);
        }

        @Override
        public int length() {
            return this.toString().length();
        }

        @Override
        public char charAt(int index) {
            return this.toString().charAt(index);
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            return this.toString().subSequence(start, end);
        }

        @Override
        public String toString() {
            return (String)(this.qualifier != null ? this.qualifier + " " : "") + this.beanType.getName();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BeanKey beanKey = (BeanKey)o;
            return this.beanType.equalsType(beanKey.beanType) && Objects.equals(this.qualifier, beanKey.qualifier);
        }

        public int hashCode() {
            return this.hashCode;
        }

        @Override
        public String getName() {
            Qualifier<T> qualifier = this.qualifier;
            if (qualifier instanceof Named) {
                Named named = (Named)((Object)qualifier);
                return named.getName();
            }
            return Primary.SIMPLE_NAME;
        }
    }

    @Internal
    static final class BeanDefinitionProducer {
        @Nullable
        private volatile BeanDefinitionReference reference;
        @Nullable
        private volatile BeanDefinition definition;
        @Nullable
        private volatile Boolean referenceEnabled;
        @Nullable
        private volatile Boolean definitionEnabled;

        BeanDefinitionProducer(@NonNull BeanDefinitionReference reference) {
            this.reference = reference;
        }

        public boolean isReferenceEnabled(DefaultBeanContext context) {
            return this.isReferenceEnabled(context, null);
        }

        public boolean isReferenceEnabled(DefaultBeanContext context, @Nullable BeanResolutionContext resolutionContext) {
            BeanDefinitionReference ref = this.reference;
            if (ref == null) {
                return false;
            }
            if (this.referenceEnabled == null) {
                if (ref.isEnabled(context, resolutionContext)) {
                    this.referenceEnabled = true;
                } else {
                    this.referenceEnabled = false;
                    this.reference = null;
                }
            }
            return this.referenceEnabled;
        }

        public boolean isDisabled() {
            if (this.reference == null) {
                return true;
            }
            Boolean refEnabled = this.referenceEnabled;
            if (refEnabled != null && !refEnabled.booleanValue()) {
                return true;
            }
            Boolean defEnabled = this.definitionEnabled;
            return defEnabled != null && defEnabled == false;
        }

        public boolean isDefinitionEnabled(DefaultBeanContext defaultBeanContext) {
            return this.isDefinitionEnabled(defaultBeanContext, null);
        }

        public boolean isDefinitionEnabled(DefaultBeanContext context, @Nullable BeanResolutionContext resolutionContext) {
            if (this.definitionEnabled == null) {
                if (this.isReferenceEnabled(context, resolutionContext)) {
                    BeanDefinition def = this.getDefinition(context);
                    if (def.isEnabled(context, resolutionContext)) {
                        this.definition = def;
                        this.definitionEnabled = true;
                    } else {
                        this.definitionEnabled = false;
                    }
                } else {
                    this.definitionEnabled = false;
                }
            }
            return this.definitionEnabled;
        }

        public <T> BeanDefinitionReference<T> getReference() {
            Boolean refEnabled = this.referenceEnabled;
            if (this.reference == null || refEnabled == null || !refEnabled.booleanValue()) {
                throw new IllegalStateException("The reference is not enabled");
            }
            return this.reference;
        }

        public <T> BeanDefinition<T> getDefinition(BeanContext beanContext) {
            Boolean defEnabled = this.definitionEnabled;
            if (defEnabled != null && !defEnabled.booleanValue()) {
                throw new IllegalStateException("The definition is not enabled");
            }
            try {
                BeanDefinition<T> def = this.definition;
                if (def == null) {
                    this.definition = def = this.getReference().load(beanContext);
                }
                return def;
            }
            catch (Throwable e) {
                throw new BeanInstantiationException(DefaultBeanContext.MSG_BEAN_DEFINITION + this.reference.getName() + DefaultBeanContext.MSG_COULD_NOT_BE_LOADED + e.getMessage(), e);
            }
        }

        public <T> boolean isReferenceCandidateBean(Argument<T> beanType) {
            BeanDefinitionReference ref = this.reference;
            return ref != null && ref.isCandidateBean(beanType);
        }

        public void disable(BeanDefinitionReference<?> reference) {
            BeanDefinitionReference ref = this.reference;
            if (ref != null && ref.equals(reference)) {
                this.reference = null;
            }
        }
    }

    private final class BeanContextUnsafeExecutionHandle
    extends BeanContextExecutionHandle
    implements UnsafeExecutionHandle<Object, Object> {
        private final UnsafeExecutable<Object, Object> unsafeExecutionHandle;

        public BeanContextUnsafeExecutionHandle(ExecutableMethod<Object, ?> method, BeanDefinition<?> beanDefinition, UnsafeExecutable<Object, Object> unsafeExecutionHandle) {
            super(method, beanDefinition);
            this.unsafeExecutionHandle = unsafeExecutionHandle;
        }

        @Override
        public Object invokeUnsafe(Object ... arguments) {
            return this.unsafeExecutionHandle.invokeUnsafe(this.getTarget(), arguments);
        }

        @Override
        public String toString() {
            return this.unsafeExecutionHandle.toString();
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private class BeanContextExecutionHandle
    implements MethodExecutionHandle<Object, Object> {
        private final ExecutableMethod<Object, ?> method;
        private final BeanDefinition<?> beanDefinition;
        private Object target;

        public BeanContextExecutionHandle(ExecutableMethod<Object, ?> method, BeanDefinition<? extends Object> beanDefinition) {
            this.method = method;
            this.beanDefinition = beanDefinition;
        }

        @Override
        @NonNull
        public AnnotationMetadata getAnnotationMetadata() {
            return this.method.getAnnotationMetadata();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object getTarget() {
            Object target = this.target;
            if (target == null) {
                BeanContextExecutionHandle beanContextExecutionHandle = this;
                synchronized (beanContextExecutionHandle) {
                    target = this.target;
                    if (target == null) {
                        this.target = target = DefaultBeanContext.this.getBean(this.beanDefinition);
                    }
                }
            }
            return target;
        }

        @Override
        public Class getDeclaringType() {
            return this.beanDefinition.getBeanType();
        }

        @Override
        public String getMethodName() {
            return this.method.getMethodName();
        }

        @Override
        public Argument[] getArguments() {
            return this.method.getArguments();
        }

        @Override
        public Method getTargetMethod() {
            return this.method.getTargetMethod();
        }

        @Override
        public ReturnType getReturnType() {
            return this.method.getReturnType();
        }

        @Override
        public Object invoke(Object ... arguments) {
            return this.method.invoke(this.getTarget(), arguments);
        }

        @Override
        @NonNull
        public ExecutableMethod<Object, Object> getExecutableMethod() {
            return this.method;
        }

        public String toString() {
            return this.method.toString();
        }
    }

    private class SingletonBeanResolutionContext
    extends AbstractBeanResolutionContext {
        public SingletonBeanResolutionContext(BeanDefinition<?> beanDefinition) {
            super(DefaultBeanContext.this, beanDefinition);
        }

        @Override
        public BeanResolutionContext copy() {
            SingletonBeanResolutionContext copy = new SingletonBeanResolutionContext(this.rootDefinition);
            copy.copyStateFrom(this);
            return copy;
        }

        @Override
        public <T> void addInFlightBean(BeanIdentifier beanIdentifier, BeanRegistration<T> beanRegistration) {
            DefaultBeanContext.this.singlesInCreation.put(beanIdentifier, beanRegistration);
        }

        @Override
        public void removeInFlightBean(BeanIdentifier beanIdentifier) {
            DefaultBeanContext.this.singlesInCreation.remove(beanIdentifier);
        }

        @Override
        @Nullable
        public <T> BeanRegistration<T> getInFlightBean(BeanIdentifier beanIdentifier) {
            return DefaultBeanContext.this.singlesInCreation.get(beanIdentifier);
        }
    }

    @Internal
    static interface ListenersSupplier<T extends EventListener> {
        @NonNull
        public Iterable<T> get(@Nullable BeanResolutionContext var1);
    }

    static final class BeanCandidateKey<T> {
        private final Argument<T> beanType;
        private final Qualifier<T> qualifier;
        private final boolean throwNonUnique;
        private final int hashCode;

        BeanCandidateKey(Argument<T> argument, Qualifier<T> qualifier, boolean throwNonUnique) {
            this.beanType = argument;
            this.qualifier = qualifier;
            this.hashCode = argument.typeHashCode();
            this.throwNonUnique = throwNonUnique;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BeanCandidateKey beanKey = (BeanCandidateKey)o;
            return this.beanType.equalsType(beanKey.beanType) && Objects.equals(this.qualifier, beanKey.qualifier) && this.throwNonUnique == beanKey.throwNonUnique;
        }

        public int hashCode() {
            return this.hashCode;
        }
    }

    private static final class CollectionHolder<T> {
        Collection<BeanRegistration<T>> registrations;

        private CollectionHolder() {
        }
    }

    private static final class ObjectExecutionHandle<T, R>
    extends AbstractExecutionHandle<T, R>
    implements UnsafeExecutionHandle<T, R> {
        @Nullable
        private final UnsafeExecutable<T, R> unsafeExecutable;
        private final T target;

        ObjectExecutionHandle(T target, ExecutableMethod<T, R> method) {
            super(method);
            UnsafeExecutable unsafeExecutable;
            this.target = target;
            this.unsafeExecutable = method instanceof UnsafeExecutable ? (unsafeExecutable = (UnsafeExecutable)((Object)method)) : null;
        }

        @Override
        public T getTarget() {
            return this.target;
        }

        @Override
        public R invoke(Object ... arguments) {
            return this.method.invoke(this.target, arguments);
        }

        @Override
        public R invokeUnsafe(Object ... arguments) {
            if (this.unsafeExecutable == null) {
                return this.invoke(arguments);
            }
            return this.unsafeExecutable.invokeUnsafe(this.target, arguments);
        }

        @Override
        public Method getTargetMethod() {
            return this.method.getTargetMethod();
        }

        @Override
        public Class getDeclaringType() {
            return this.target.getClass();
        }
    }

    private static final class BeanExecutionHandle<T, R>
    extends AbstractExecutionHandle<T, R> {
        private final BeanContext beanContext;
        private final Class<T> beanType;
        private final Qualifier<T> qualifier;
        private final boolean isSingleton;
        private T target;

        BeanExecutionHandle(BeanContext beanContext, Class<T> beanType, Qualifier<T> qualifier, ExecutableMethod<T, R> method) {
            super(method);
            this.beanContext = beanContext;
            this.beanType = beanType;
            this.qualifier = qualifier;
            this.isSingleton = beanContext.findBeanDefinition(beanType, qualifier).map(BeanDefinition::isSingleton).orElse(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T getTarget() {
            T target = this.target;
            if (target == null) {
                BeanExecutionHandle beanExecutionHandle = this;
                synchronized (beanExecutionHandle) {
                    target = this.target;
                    if (target == null) {
                        this.target = target = this.beanContext.getBean(this.beanType, this.qualifier);
                    }
                }
            }
            return target;
        }

        @Override
        public Method getTargetMethod() {
            return this.method.getTargetMethod();
        }

        @Override
        public Class getDeclaringType() {
            return this.beanType;
        }

        @Override
        public R invoke(Object ... arguments) {
            if (this.isSingleton) {
                T target = this.getTarget();
                return this.method.invoke(target, arguments);
            }
            return this.method.invoke(this.beanContext.getBean(this.beanType, this.qualifier), arguments);
        }
    }

    private static abstract class AbstractExecutionHandle<T, R>
    implements MethodExecutionHandle<T, R> {
        protected final ExecutableMethod<T, R> method;

        AbstractExecutionHandle(ExecutableMethod<T, R> method) {
            this.method = method;
        }

        @Override
        @NonNull
        public ExecutableMethod<T, R> getExecutableMethod() {
            return this.method;
        }

        @Override
        public Argument[] getArguments() {
            return this.method.getArguments();
        }

        public String toString() {
            return this.method.toString();
        }

        @Override
        public String getMethodName() {
            return this.method.getMethodName();
        }

        @Override
        public ReturnType<R> getReturnType() {
            return this.method.getReturnType();
        }

        @Override
        public AnnotationMetadata getAnnotationMetadata() {
            return this.method.getAnnotationMetadata();
        }
    }
}

