/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.context.exceptions;

import io.micronaut.context.exceptions.NoSuchBeanException;
import io.micronaut.core.type.Argument;
import io.micronaut.inject.BeanDefinition;
import java.util.Collections;
import java.util.Iterator;

public class NonUniqueBeanException
extends NoSuchBeanException {
    private final transient Iterator possibleCandidates;
    private final Class<?> targetType;

    public <T> NonUniqueBeanException(Class<? extends T> targetType, Iterator<BeanDefinition<T>> candidates) {
        super(NonUniqueBeanException.buildMessage(candidates));
        this.targetType = targetType;
        this.possibleCandidates = candidates;
    }

    public <T> Iterator<BeanDefinition<T>> getPossibleCandidates() {
        if (this.possibleCandidates != null) {
            return this.possibleCandidates;
        }
        return Collections.emptyIterator();
    }

    public <T> Class<T> getBeanType() {
        return this.targetType;
    }

    private static <T> String buildMessage(Iterator<BeanDefinition<T>> possibleCandidates) {
        StringBuilder message = new StringBuilder("Multiple possible bean candidates found: [");
        while (possibleCandidates.hasNext()) {
            Argument<T> next = possibleCandidates.next().asArgument();
            message.append(next.getTypeString(true));
            if (!possibleCandidates.hasNext()) continue;
            message.append(", ");
        }
        message.append("]");
        return message.toString();
    }
}

