/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http;

import io.micronaut.core.convert.ConversionContext;
import io.micronaut.core.type.Headers;
import io.micronaut.http.MediaType;
import io.micronaut.http.util.HttpHeadersUtil;
import jakarta.annotation.Nullable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.OptionalLong;

public interface HttpHeaders
extends Headers {
    public static final String ACCEPT = "Accept";
    public static final String ACCEPT_CH = "Accept-CH";
    public static final String ACCEPT_CH_LIFETIME = "Accept-CH-Lifetime";
    public static final String ACCEPT_CHARSET = "Accept-Charset";
    public static final String ACCEPT_ENCODING = "Accept-Encoding";
    public static final String ACCEPT_LANGUAGE = "Accept-Language";
    public static final String ACCEPT_RANGES = "Accept-Ranges";
    public static final String ACCEPT_PATCH = "Accept-Patch";
    public static final String ACCESS_CONTROL_ALLOW_CREDENTIALS = "Access-Control-Allow-Credentials";
    public static final String ACCESS_CONTROL_ALLOW_HEADERS = "Access-Control-Allow-Headers";
    public static final String ACCESS_CONTROL_ALLOW_METHODS = "Access-Control-Allow-Methods";
    public static final String ACCESS_CONTROL_ALLOW_ORIGIN = "Access-Control-Allow-Origin";
    public static final String ACCESS_CONTROL_EXPOSE_HEADERS = "Access-Control-Expose-Headers";
    public static final String ACCESS_CONTROL_MAX_AGE = "Access-Control-Max-Age";
    public static final String ACCESS_CONTROL_REQUEST_HEADERS = "Access-Control-Request-Headers";
    public static final String ACCESS_CONTROL_REQUEST_METHOD = "Access-Control-Request-Method";
    public static final String AGE = "Age";
    public static final String ALLOW = "Allow";
    public static final String AUTHORIZATION = "Authorization";
    public static final String AUTHORIZATION_INFO = "Authorization-Info";
    public static final String CACHE_CONTROL = "Cache-Control";
    public static final String CONNECTION = "Connection";
    public static final String CONTENT_BASE = "Content-Base";
    public static final String CONTENT_DISPOSITION = "Content-Disposition";
    public static final String CONTENT_DPR = "Content-DPR";
    public static final String CONTENT_ENCODING = "Content-Encoding";
    public static final String CONTENT_LANGUAGE = "Content-Language";
    public static final String CONTENT_LENGTH = "Content-Length";
    public static final String CONTENT_LOCATION = "Content-Location";
    public static final String CONTENT_TRANSFER_ENCODING = "Content-Transfer-Encoding";
    public static final String CONTENT_MD5 = "Content-MD5";
    public static final String CONTENT_RANGE = "Content-Range";
    public static final String CONTENT_TYPE = "Content-Type";
    public static final String COOKIE = "Cookie";
    public static final String CROSS_ORIGIN_RESOURCE_POLICY = "Cross-Origin-Resource-Policy";
    public static final String DATE = "Date";
    public static final String DEVICE_MEMORY = "Device-Memory";
    public static final String DOWNLINK = "Downlink";
    public static final String DPR = "DPR";
    public static final String ECT = "ECT";
    public static final String ETAG = "ETag";
    public static final String EXPECT = "Expect";
    public static final String EXPIRES = "Expires";
    public static final String FEATURE_POLICY = "Feature-Policy";
    public static final String FORWARDED = "Forwarded";
    public static final String FROM = "From";
    public static final String HOST = "Host";
    public static final String IF_MATCH = "If-Match";
    public static final String IF_MODIFIED_SINCE = "If-Modified-Since";
    public static final String IF_NONE_MATCH = "If-None-Match";
    public static final String IF_RANGE = "If-Range";
    public static final String IF_UNMODIFIED_SINCE = "If-Unmodified-Since";
    public static final String LAST_MODIFIED = "Last-Modified";
    public static final String LINK = "Link";
    public static final String LOCATION = "Location";
    public static final String MAX_FORWARDS = "Max-Forwards";
    public static final String ORIGIN = "Origin";
    public static final String PRAGMA = "Pragma";
    public static final String PROXY_AUTHENTICATE = "Proxy-Authenticate";
    public static final String PROXY_AUTHORIZATION = "Proxy-Authorization";
    public static final String RANGE = "Range";
    public static final String REFERER = "Referer";
    public static final String REFERRER_POLICY = "Referrer-Policy";
    public static final String RETRY_AFTER = "Retry-After";
    public static final String RTT = "RTT";
    public static final String SAVE_DATA = "Save-Data";
    public static final String SEC_WEBSOCKET_KEY1 = "Sec-WebSocket-Key1";
    public static final String SEC_WEBSOCKET_KEY2 = "Sec-WebSocket-Key2";
    public static final String SEC_WEBSOCKET_LOCATION = "Sec-WebSocket-Location";
    public static final String SEC_WEBSOCKET_ORIGIN = "Sec-WebSocket-Origin";
    public static final String SEC_WEBSOCKET_PROTOCOL = "Sec-WebSocket-Protocol";
    public static final String SEC_WEBSOCKET_VERSION = "Sec-WebSocket-Version";
    public static final String SEC_WEBSOCKET_KEY = "Sec-WebSocket-Key";
    public static final String SEC_WEBSOCKET_ACCEPT = "Sec-WebSocket-Accept";
    public static final String SERVER = "Server";
    public static final String SET_COOKIE = "Set-Cookie";
    public static final String SET_COOKIE2 = "Set-Cookie2";
    public static final String SOURCE_MAP = "SourceMap";
    public static final String TE = "TE";
    public static final String TRAILER = "Trailer";
    public static final String TRANSFER_ENCODING = "Transfer-Encoding";
    public static final String UPGRADE = "Upgrade";
    public static final String USER_AGENT = "User-Agent";
    public static final String VARY = "Vary";
    public static final String VIA = "Via";
    public static final String VIEWPORT_WIDTH = "Viewport-Width";
    public static final String WARNING = "Warning";
    public static final String WEBSOCKET_LOCATION = "WebSocket-Location";
    public static final String WEBSOCKET_ORIGIN = "WebSocket-Origin";
    public static final String WEBSOCKET_PROTOCOL = "WebSocket-Protocol";
    public static final String WIDTH = "Width";
    public static final String WWW_AUTHENTICATE = "WWW-Authenticate";
    public static final String X_AUTH_TOKEN = "X-Auth-Token";
    public static final List<String> STANDARD_HEADERS = Collections.unmodifiableList(Arrays.asList("Accept", "Accept", "Accept-CH", "Accept-CH-Lifetime", "Accept-Charset", "Accept-Encoding", "Accept-Language", "Accept-Ranges", "Accept-Patch", "Access-Control-Allow-Credentials", "Access-Control-Allow-Headers", "Access-Control-Allow-Methods", "Access-Control-Allow-Origin", "Access-Control-Expose-Headers", "Access-Control-Max-Age", "Access-Control-Request-Headers", "Access-Control-Request-Method", "Age", "Allow", "Authorization", "Authorization-Info", "Cache-Control", "Connection", "Content-Base", "Content-Disposition", "Content-DPR", "Content-Encoding", "Content-Language", "Content-Length", "Content-Location", "Content-Transfer-Encoding", "Content-MD5", "Content-Range", "Content-Type", "Cookie", "Cross-Origin-Resource-Policy", "Date", "Device-Memory", "Downlink", "DPR", "ECT", "ETag", "Expect", "Expires", "Feature-Policy", "Forwarded", "From", "Host", "If-Match", "If-Modified-Since", "If-None-Match", "If-Range", "If-Unmodified-Since", "Last-Modified", "Link", "Location", "Max-Forwards", "Origin", "Pragma", "Proxy-Authenticate", "Proxy-Authorization", "Range", "Referer", "Referrer-Policy", "Retry-After", "RTT", "Save-Data", "Sec-WebSocket-Key1", "Sec-WebSocket-Key2", "Sec-WebSocket-Location", "Sec-WebSocket-Origin", "Sec-WebSocket-Protocol", "Sec-WebSocket-Version", "Sec-WebSocket-Key", "Sec-WebSocket-Accept", "Server", "Set-Cookie", "Set-Cookie2", "SourceMap", "TE", "Trailer", "Transfer-Encoding", "Upgrade", "User-Agent", "Vary", "Via", "Viewport-Width", "Warning", "WebSocket-Location", "WebSocket-Origin", "WebSocket-Protocol", "Width", "WWW-Authenticate", "X-Auth-Token"));

    default public Optional<ZonedDateTime> findDate(CharSequence name) {
        try {
            return this.findFirst(name).map(str -> {
                LocalDateTime localDateTime = LocalDateTime.parse(str, DateTimeFormatter.RFC_1123_DATE_TIME);
                return ZonedDateTime.of(localDateTime, ZoneId.of("GMT"));
            });
        }
        catch (DateTimeParseException e) {
            return Optional.empty();
        }
    }

    default public ZonedDateTime getDate(CharSequence name) {
        return this.findDate(name).orElse(null);
    }

    default public Integer getInt(CharSequence name) {
        return this.findInt(name).orElse(null);
    }

    default public Optional<Integer> findInt(CharSequence name) {
        return this.get(name, ConversionContext.INT);
    }

    default public Optional<String> findFirst(CharSequence name) {
        return this.getFirst(name, ConversionContext.STRING);
    }

    default public Optional<MediaType> contentType() {
        return this.getFirst((CharSequence)CONTENT_TYPE, MediaType.CONVERSION_CONTEXT);
    }

    default public OptionalLong contentLength() {
        Long aLong = this.getFirst((CharSequence)CONTENT_LENGTH, ConversionContext.LONG).orElse(null);
        if (aLong != null) {
            return OptionalLong.of(aLong);
        }
        return OptionalLong.empty();
    }

    default public List<MediaType> accept() {
        return MediaType.orderedOf(this.getAll(ACCEPT));
    }

    @Nullable
    default public Charset acceptCharset() {
        return this.findFirst(ACCEPT_CHARSET).map(text -> {
            if ((text = HttpHeadersUtil.splitAcceptHeader(text)) != null) {
                try {
                    return Charset.forName(text);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return StandardCharsets.UTF_8;
        }).orElse(null);
    }

    @Nullable
    default public Locale acceptLanguage() {
        return this.findFirst(ACCEPT_LANGUAGE).map(text -> {
            String part = HttpHeadersUtil.splitAcceptHeader(text);
            return part == null ? Locale.getDefault() : Locale.forLanguageTag(part);
        }).orElse(null);
    }

    default public boolean isKeepAlive() {
        return this.findFirst(CONNECTION).map(val -> val.equalsIgnoreCase("keep-alive")).orElse(false);
    }

    default public Optional<String> getOrigin() {
        return this.findFirst(ORIGIN);
    }

    default public Optional<String> getAuthorization() {
        return this.findFirst(AUTHORIZATION);
    }

    default public Optional<String> getContentType() {
        return this.findFirst(CONTENT_TYPE);
    }
}

