/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server;

import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.convert.exceptions.ConversionErrorException;
import io.micronaut.core.execution.ExecutionFlow;
import io.micronaut.core.propagation.PropagatedContext;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.ReturnType;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.http.HttpAttributes;
import io.micronaut.http.HttpMethod;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.MediaType;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.body.MessageBodyHandlerRegistry;
import io.micronaut.http.filter.FilterRunner;
import io.micronaut.http.filter.GenericHttpFilter;
import io.micronaut.http.server.ExecutableRouteInfo;
import io.micronaut.http.server.RouteExecutor;
import io.micronaut.http.server.exceptions.ExceptionHandler;
import io.micronaut.http.server.exceptions.response.ErrorContext;
import io.micronaut.http.server.types.files.FileCustomizableResponseType;
import io.micronaut.inject.BeanDefinition;
import io.micronaut.inject.qualifiers.Qualifiers;
import io.micronaut.json.JsonSyntaxException;
import io.micronaut.web.router.DefaultRouteInfo;
import io.micronaut.web.router.RouteInfo;
import io.micronaut.web.router.RouteMatch;
import io.micronaut.web.router.UriRouteMatch;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestLifecycle {
    private static final Logger LOG = LoggerFactory.getLogger(RequestLifecycle.class);
    private final RouteExecutor routeExecutor;
    private HttpRequest<?> request;
    private boolean multipartEnabled = true;

    protected RequestLifecycle(RouteExecutor routeExecutor, HttpRequest<?> request) {
        this.routeExecutor = Objects.requireNonNull(routeExecutor, "routeExecutor");
        this.request = Objects.requireNonNull(request, "request");
    }

    protected final HttpRequest<?> request() {
        return this.request;
    }

    protected final void multipartEnabled(boolean multipartEnabled) {
        this.multipartEnabled = multipartEnabled;
    }

    protected final ExecutionFlow<MutableHttpResponse<?>> normalFlow() {
        MediaType contentType;
        if (!this.multipartEnabled && (contentType = (MediaType)this.request.getContentType().orElse(null)) != null && contentType.equals(MediaType.MULTIPART_FORM_DATA_TYPE)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Multipart uploads have been disabled via configuration. Rejected request for URI {}, method {}, and content type {}", this.request.getUri(), this.request.getMethodName(), contentType);
            }
            return this.onStatusError(HttpResponse.status(HttpStatus.UNSUPPORTED_MEDIA_TYPE), "Content Type [" + contentType + "] not allowed");
        }
        UriRouteMatch<Object, Object> routeMatch = this.routeExecutor.findRouteMatch(this.request);
        if (routeMatch == null) {
            FileCustomizableResponseType fileCustomizableResponseType = this.findFile();
            if (fileCustomizableResponseType != null) {
                return this.runWithFilters(() -> {
                    MutableHttpResponse<FileCustomizableResponseType> fileResponse = HttpResponse.ok(fileCustomizableResponseType);
                    return ExecutionFlow.just(fileResponse);
                });
            }
            return this.onRouteMiss(this.request);
        }
        RouteExecutor.setRouteAttributes(this.request, routeMatch);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Matched route {} - {} to controller {}", this.request.getMethodName(), this.request.getUri().getPath(), routeMatch.getDeclaringType());
        }
        if (routeMatch.getRouteInfo().isWebSocketRoute()) {
            return this.onStatusError(HttpResponse.status(HttpStatus.BAD_REQUEST), "Not a WebSocket request");
        }
        return this.runWithFilters(() -> {
            PropagatedContext propagatedContext = PropagatedContext.get();
            return this.fulfillArguments(routeMatch).flatMap(rm -> this.routeExecutor.callRoute(propagatedContext, (RouteMatch<?>)rm, this.request).flatMap(res -> this.handleStatusException((MutableHttpResponse<?>)res, (RouteMatch<?>)rm, propagatedContext))).onErrorResume(exp -> this.onErrorNoFilter((Throwable)exp, propagatedContext));
        });
    }

    protected final ExecutionFlow<MutableHttpResponse<?>> onError(Throwable t) {
        return this.runWithFilters(() -> this.onErrorNoFilter(t, PropagatedContext.get()));
    }

    private ExecutionFlow<MutableHttpResponse<?>> onErrorNoFilter(Throwable t, PropagatedContext propagatedContext) {
        Throwable cause;
        RouteMatch<?> errorRoute;
        ConversionErrorException cee;
        Throwable throwable2;
        Optional<RouteInfo> previousRequestRouteInfo = this.request.getAttribute(HttpAttributes.ROUTE_INFO, RouteInfo.class);
        Class declaringType = previousRequestRouteInfo.map(RouteInfo::getDeclaringType).orElse(null);
        if ((t instanceof CompletionException || t instanceof ExecutionException) && t.getCause() != null) {
            t = t.getCause();
        }
        if (t instanceof ConversionErrorException && (throwable2 = (cee = (ConversionErrorException)t).getCause()) instanceof JsonSyntaxException) {
            JsonSyntaxException jse = (JsonSyntaxException)throwable2;
            t = jse;
        }
        if ((errorRoute = this.routeExecutor.findErrorRoute(cause = t, declaringType, this.request)) != null) {
            if (this.routeExecutor.serverConfiguration.isLogHandledExceptions()) {
                this.routeExecutor.logException(cause);
            }
            try {
                return ExecutionFlow.just(errorRoute).flatMap(routeMatch -> this.routeExecutor.callRoute(propagatedContext, (RouteMatch<?>)routeMatch, this.request).flatMap(res -> this.handleStatusException((MutableHttpResponse<?>)res, (RouteMatch<?>)routeMatch, propagatedContext))).onErrorResume(u -> this.createDefaultErrorResponseFlow(this.request, (Throwable)u)).map(response -> {
                    response.setAttribute(HttpAttributes.EXCEPTION, cause);
                    return response;
                }).onErrorResume(throwable -> this.createDefaultErrorResponseFlow(this.request, (Throwable)throwable));
            }
            catch (Throwable e) {
                return this.createDefaultErrorResponseFlow(this.request, e);
            }
        }
        Optional<BeanDefinition<ExceptionHandler>> optionalDefinition = this.routeExecutor.beanContext.findBeanDefinition(ExceptionHandler.class, Qualifiers.byTypeArgumentsClosest(cause.getClass(), Object.class));
        if (optionalDefinition.isPresent()) {
            BeanDefinition<ExceptionHandler> handlerDefinition = optionalDefinition.get();
            Optional optionalMethod = handlerDefinition.findPossibleMethods("handle").findFirst();
            DefaultRouteInfo routeInfo = optionalMethod.isPresent() ? new ExecutableRouteInfo(optionalMethod.get(), true) : new DefaultRouteInfo<Object>(AnnotationMetadata.EMPTY_METADATA, ReturnType.of(Object.class, new Argument[0]), List.of(), MediaType.fromType(handlerDefinition.getBeanType()).map(Collections::singletonList).orElse(Collections.emptyList()), handlerDefinition.getBeanType(), true, false, MessageBodyHandlerRegistry.EMPTY);
            Supplier<ExecutionFlow> responseSupplier = () -> {
                ExceptionHandler handler = (ExceptionHandler)this.routeExecutor.beanContext.getBean(handlerDefinition);
                try {
                    if (this.routeExecutor.serverConfiguration.isLogHandledExceptions()) {
                        this.routeExecutor.logException(cause);
                    }
                    Object result = handler.handle(this.request, cause);
                    return this.routeExecutor.createResponseForBody(propagatedContext, this.request, result, routeInfo, null);
                }
                catch (Throwable e) {
                    return this.createDefaultErrorResponseFlow(this.request, e);
                }
            };
            ExecutorService executor = this.routeExecutor.findExecutor(routeInfo);
            ExecutionFlow responseFlow = executor != null ? ExecutionFlow.async(executor, responseSupplier) : responseSupplier.get();
            return responseFlow.map(response -> {
                response.setAttribute(HttpAttributes.EXCEPTION, cause);
                return response;
            }).onErrorResume(throwable -> this.createDefaultErrorResponseFlow(this.request, (Throwable)throwable));
        }
        if (RouteExecutor.isIgnorable(cause)) {
            RouteExecutor.logIgnoredException(cause);
            return ExecutionFlow.empty();
        }
        return this.createDefaultErrorResponseFlow(this.request, cause);
    }

    protected final ExecutionFlow<MutableHttpResponse<?>> runWithFilters(Supplier<ExecutionFlow<MutableHttpResponse<?>>> downstream) {
        List<GenericHttpFilter> httpFilters = this.routeExecutor.router.findFilters(this.request);
        ArrayList<GenericHttpFilter> filters = new ArrayList<GenericHttpFilter>(httpFilters.size() + 1);
        filters.addAll(httpFilters);
        filters.add(request -> {
            this.request = request;
            return (ExecutionFlow)downstream.get();
        });
        FilterRunner filterRunner = new FilterRunner(filters){

            @Override
            protected ExecutionFlow<? extends HttpResponse<?>> processResponse(HttpRequest<?> request, HttpResponse<?> response, PropagatedContext propagatedContext) {
                RequestLifecycle.this.request = request;
                RouteInfo routeInfo = response.getAttribute(HttpAttributes.ROUTE_INFO, RouteInfo.class).orElse(null);
                return RequestLifecycle.this.handleStatusException((MutableHttpResponse)response, routeInfo, propagatedContext).onErrorResume(throwable -> RequestLifecycle.this.onErrorNoFilter((Throwable)throwable, propagatedContext));
            }

            @Override
            protected ExecutionFlow<? extends HttpResponse<?>> processFailure(HttpRequest<?> request, Throwable failure, PropagatedContext propagatedContext) {
                RequestLifecycle.this.request = request;
                return RequestLifecycle.this.onErrorNoFilter(failure, propagatedContext);
            }
        };
        return filterRunner.run(this.request);
    }

    private ExecutionFlow<MutableHttpResponse<?>> handleStatusException(MutableHttpResponse<?> response, RouteMatch<?> routeMatch, PropagatedContext propagatedContext) {
        RouteInfo<?> routeInfo = routeMatch == null ? null : routeMatch.getRouteInfo();
        return this.handleStatusException(response, routeInfo, propagatedContext);
    }

    private ExecutionFlow<MutableHttpResponse<?>> handleStatusException(MutableHttpResponse<?> response, RouteInfo<?> routeInfo, PropagatedContext propagatedContext) {
        RouteMatch<Object> statusRoute;
        if (response.code() >= 400 && routeInfo != null && !routeInfo.isErrorRoute() && (statusRoute = this.routeExecutor.findStatusRoute(this.request, response.code(), routeInfo)) != null) {
            return this.fulfillArguments(statusRoute).flatMap(rm -> this.routeExecutor.callRoute(propagatedContext, (RouteMatch<?>)rm, this.request).flatMap(res -> this.handleStatusException((MutableHttpResponse<?>)res, (RouteMatch<?>)rm, propagatedContext))).onErrorResume(exp -> this.onErrorNoFilter((Throwable)exp, propagatedContext));
        }
        return ExecutionFlow.just(response);
    }

    private ExecutionFlow<MutableHttpResponse<?>> createDefaultErrorResponseFlow(HttpRequest<?> httpRequest, Throwable cause) {
        return ExecutionFlow.just(this.routeExecutor.createDefaultErrorResponse(httpRequest, cause));
    }

    final ExecutionFlow<MutableHttpResponse<?>> onRouteMiss(HttpRequest<?> httpRequest) {
        HttpMethod httpMethod = httpRequest.getMethod();
        String requestMethodName = httpRequest.getMethodName();
        MediaType contentType = httpRequest.getContentType().orElse(null);
        if (LOG.isDebugEnabled()) {
            LOG.debug("No matching route: {} {}", (Object)httpMethod, (Object)httpRequest.getUri());
        }
        List anyMatchingRoutes = this.routeExecutor.router.findAny(httpRequest);
        Collection<MediaType> acceptedTypes = httpRequest.accept();
        boolean hasAcceptHeader = CollectionUtils.isNotEmpty(acceptedTypes);
        HashSet<MediaType> acceptableContentTypes = contentType != null ? new HashSet<MediaType>(5) : null;
        HashSet<String> allowedMethods = new HashSet<String>(5);
        HashSet<MediaType> produceableContentTypes = hasAcceptHeader ? new HashSet<MediaType>(5) : null;
        for (UriRouteMatch anyRoute : anyMatchingRoutes) {
            String routeMethod = anyRoute.getRouteInfo().getHttpMethodName();
            if (!requestMethodName.equals(routeMethod)) {
                allowedMethods.add(routeMethod);
            }
            if (contentType != null && !anyRoute.getRouteInfo().doesConsume(contentType)) {
                acceptableContentTypes.addAll(anyRoute.getRouteInfo().getConsumes());
            }
            if (!hasAcceptHeader || anyRoute.getRouteInfo().doesProduce(acceptedTypes)) continue;
            produceableContentTypes.addAll(anyRoute.getRouteInfo().getProduces());
        }
        if (CollectionUtils.isNotEmpty(acceptableContentTypes)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Content type not allowed for URI {}, method {}, and content type {}", httpRequest.getUri(), requestMethodName, contentType);
            }
            return this.onStatusError(HttpResponse.status(HttpStatus.UNSUPPORTED_MEDIA_TYPE), "Content Type [" + contentType + "] not allowed. Allowed types: " + acceptableContentTypes);
        }
        if (CollectionUtils.isNotEmpty(produceableContentTypes)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Content type not allowed for URI {}, method {}, and content type {}", httpRequest.getUri(), requestMethodName, contentType);
            }
            return this.onStatusError(HttpResponse.status(HttpStatus.NOT_ACCEPTABLE), "Specified Accept Types " + acceptedTypes + " not supported. Supported types: " + produceableContentTypes);
        }
        if (!allowedMethods.isEmpty()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Method not allowed for URI {} and method {}", (Object)httpRequest.getUri(), (Object)requestMethodName);
            }
            return this.onStatusError(HttpResponse.notAllowedGeneric(allowedMethods), "Method [" + requestMethodName + "] not allowed for URI [" + httpRequest.getUri() + "]. Allowed methods: " + allowedMethods);
        }
        return this.onStatusError(HttpResponse.status(HttpStatus.NOT_FOUND), "Page Not Found");
    }

    protected final ExecutionFlow<MutableHttpResponse<?>> onStatusError(MutableHttpResponse<?> defaultResponse, String message) {
        Optional statusRoute = this.routeExecutor.router.findStatusRoute(defaultResponse.status(), this.request);
        if (statusRoute.isPresent()) {
            return this.runWithFilters(() -> {
                PropagatedContext propagatedContext = PropagatedContext.get();
                return this.fulfillArguments((RouteMatch)statusRoute.get()).flatMap(routeMatch -> this.routeExecutor.callRoute(propagatedContext, (RouteMatch<?>)routeMatch, this.request).flatMap(res -> this.handleStatusException((MutableHttpResponse<?>)res, (RouteMatch<?>)routeMatch, propagatedContext))).onErrorResume(exp -> this.onErrorNoFilter((Throwable)exp, propagatedContext));
            });
        }
        if (this.request.getMethod() != HttpMethod.HEAD && (defaultResponse = this.routeExecutor.errorResponseProcessor.processResponse(ErrorContext.builder(this.request).errorMessage(message).build(), (MutableHttpResponse<?>)defaultResponse)).getContentType().isEmpty()) {
            defaultResponse = defaultResponse.contentType(MediaType.APPLICATION_JSON_TYPE);
        }
        MutableHttpResponse<?> finalDefaultResponse = defaultResponse;
        return this.runWithFilters(() -> ExecutionFlow.just(finalDefaultResponse));
    }

    @Nullable
    protected FileCustomizableResponseType findFile() {
        return null;
    }

    protected ExecutionFlow<RouteMatch<?>> fulfillArguments(RouteMatch<?> routeMatch) {
        this.routeExecutor.requestArgumentSatisfier.fulfillArgumentRequirementsBeforeFilters(routeMatch, this.request());
        return ExecutionFlow.just(routeMatch);
    }
}

