/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.execution.DelayedExecutionFlow;
import io.micronaut.http.MediaType;
import io.micronaut.http.multipart.PartData;
import io.micronaut.http.server.netty.MicronautHttpData;
import io.micronaut.http.server.netty.body.HttpBody;
import io.micronaut.http.server.netty.body.ImmediateMultiObjectBody;
import io.micronaut.http.server.netty.multipart.NettyCompletedFileUpload;
import io.micronaut.http.server.netty.multipart.NettyPartData;
import io.micronaut.web.router.RouteMatch;
import io.netty.channel.EventLoop;
import io.netty.handler.codec.http.multipart.FileUpload;
import io.netty.util.ReferenceCounted;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Sinks;

@Internal
public final class FormRouteCompleter
implements Subscriber<Object>,
HttpBody {
    private static final Logger LOG = LoggerFactory.getLogger(FormRouteCompleter.class);
    private final DelayedExecutionFlow<RouteMatch<?>> execute = DelayedExecutionFlow.create();
    private final EventLoop eventLoop;
    private boolean executed;
    private final RouteMatch<?> routeMatch;
    private Subscription upstreamSubscription;
    private final Set<MicronautHttpData<?>> allData = new LinkedHashSet();
    private final Map<String, Claimant> claimants = new HashMap<String, Claimant>();
    private boolean upstreamDemanded = false;

    FormRouteCompleter(RouteMatch<?> routeMatch, EventLoop eventLoop) {
        this.eventLoop = eventLoop;
        this.routeMatch = routeMatch;
    }

    public DelayedExecutionFlow<RouteMatch<?>> getExecute() {
        return this.execute;
    }

    @Override
    public void onSubscribe(Subscription s) {
        this.upstreamSubscription = s;
        s.request(1L);
    }

    @Override
    public void onNext(Object o) {
        try {
            this.addData((MicronautHttpData)o);
        }
        catch (Exception e) {
            this.upstreamSubscription.cancel();
            this.onError(e);
        }
    }

    @Override
    public void onComplete() {
        for (Claimant claimant : this.claimants.values()) {
            claimant.sink.tryEmitComplete();
        }
        if (!this.executed) {
            this.executed = true;
            this.execute.complete(this.routeMatch);
        }
    }

    @Override
    public void onError(Throwable failure) {
        for (Claimant claimant : this.claimants.values()) {
            claimant.sink.tryEmitError(failure);
        }
        for (Object toDiscard : this.routeMatch.getVariableValues().values()) {
            Object rc;
            if (toDiscard instanceof io.micronaut.core.io.buffer.ReferenceCounted) {
                rc = (io.micronaut.core.io.buffer.ReferenceCounted)toDiscard;
                rc.release();
            }
            if (toDiscard instanceof ReferenceCounted) {
                rc = (ReferenceCounted)toDiscard;
                rc.release();
            }
            if (!(toDiscard instanceof NettyCompletedFileUpload)) continue;
            NettyCompletedFileUpload fu = (NettyCompletedFileUpload)toDiscard;
            fu.discard();
        }
        this.executed = true;
        try {
            this.execute.completeExceptionally(failure);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    private void addData(MicronautHttpData<?> data) {
        this.allData.add(data);
        this.upstreamDemanded = false;
        String name = data.getName();
        Claimant claimant = this.claimants.get(name);
        data.touch(claimant != null);
        if (claimant == null) {
            this.upstreamSubscription.request(1L);
            return;
        }
        claimant.send(data);
        if (!this.executed && this.routeMatch.isFulfilled()) {
            this.executed = true;
            this.execute.complete(this.routeMatch);
        }
        if (this.executed) {
            if (!this.upstreamDemanded) {
                for (Claimant other : this.claimants.values()) {
                    if (other.demand <= 0L) continue;
                    this.upstreamDemanded = true;
                    this.upstreamSubscription.request(1L);
                    break;
                }
            }
        } else {
            this.upstreamSubscription.request(1L);
        }
    }

    private Claimant createClaimant(String name) {
        Claimant claimant = new Claimant();
        if (this.claimants.putIfAbsent(name, claimant) != null) {
            throw new IllegalStateException("Field already claimed");
        }
        return claimant;
    }

    public Flux<? extends MicronautHttpData<?>> claimFieldsRaw(String name) {
        return this.createClaimant(name).flux();
    }

    public <R> Flux<R> claimFields(String name, BiFunction<? super MicronautHttpData<?>, ? super Flux<PartData>, R> fieldFactory) {
        FieldSplitter<R> proc = new FieldSplitter<R>(fieldFactory);
        this.claimFieldsRaw(name).subscribe(proc);
        return proc.outer.asFlux();
    }

    public Flux<? extends MicronautHttpData<?>> claimFieldsComplete(String name) {
        Claimant claimant = this.createClaimant(name);
        claimant.skipUnfinished = true;
        return claimant.flux();
    }

    public boolean isClaimed(String name) {
        return this.claimants.containsKey(name);
    }

    @Override
    public void release() {
        for (MicronautHttpData<?> data : this.allData) {
            data.release();
        }
    }

    @Override
    @Nullable
    public HttpBody next() {
        return null;
    }

    public Map<String, Object> asMap(Charset defaultCharset) {
        return ImmediateMultiObjectBody.toMap(defaultCharset, this.allData);
    }

    private class Claimant {
        private final Sinks.Many<MicronautHttpData<?>> sink = Sinks.many().unicast().onBackpressureBuffer();
        private long demand;
        private MicronautHttpData<?> last;
        private MicronautHttpData<?> unsentIncomplete;
        private boolean skipUnfinished = false;

        private Claimant() {
        }

        public Flux<MicronautHttpData<?>> flux() {
            return this.sink.asFlux().doOnRequest(this::request).doOnTerminate(this::releaseNotForwarded).doOnCancel(this::releaseNotForwarded);
        }

        private void request(long n) {
            if (!FormRouteCompleter.this.eventLoop.inEventLoop()) {
                FormRouteCompleter.this.eventLoop.execute(() -> this.request(n));
                return;
            }
            long newDemand = this.demand + n;
            if (newDemand < this.demand) {
                newDemand = Long.MAX_VALUE;
            }
            this.demand = newDemand;
            if (newDemand > 0L && !FormRouteCompleter.this.upstreamDemanded) {
                FormRouteCompleter.this.upstreamDemanded = true;
                FormRouteCompleter.this.upstreamSubscription.request(1L);
            }
        }

        public void send(MicronautHttpData<?> data) {
            if (this.last != data) {
                data.retain();
                this.last = data;
            }
            if (this.skipUnfinished && !data.isCompleted()) {
                this.unsentIncomplete = data;
                return;
            }
            this.unsentIncomplete = null;
            --this.demand;
            if (this.sink.tryEmitNext(data) != Sinks.EmitResult.OK && LOG.isDebugEnabled()) {
                LOG.debug("Failed to emit data for field {}", (Object)data.getName());
            }
        }

        void releaseNotForwarded() {
            if (this.unsentIncomplete != null) {
                this.unsentIncomplete.release();
                this.unsentIncomplete = null;
            }
        }
    }

    private static class FieldSplitter<R>
    implements Subscriber<MicronautHttpData<?>> {
        final BiFunction<? super MicronautHttpData<?>, ? super Flux<PartData>, R> fieldFactory;
        Subscription upstream;
        final Sinks.Many<R> outer = Sinks.many().unicast().onBackpressureBuffer();
        MicronautHttpData<?> currentData = null;
        Sinks.Many<PartData> innerSink;
        boolean firstInner = true;

        FieldSplitter(BiFunction<? super MicronautHttpData<?>, ? super Flux<PartData>, R> fieldFactory) {
            this.fieldFactory = fieldFactory;
        }

        @Override
        public void onSubscribe(Subscription s) {
            this.upstream = s;
            s.request(1L);
        }

        @Override
        public void onNext(MicronautHttpData<?> data) {
            MicronautHttpData.Chunk chunk;
            if (data != this.currentData) {
                if (this.innerSink != null) {
                    this.innerSink.tryEmitComplete();
                }
                this.currentData = data;
                this.innerSink = Sinks.many().unicast().onBackpressureBuffer();
                this.firstInner = true;
                this.outer.tryEmitNext(this.fieldFactory.apply(data, this.innerSink.asFlux().doOnRequest(n -> {
                    if (this.firstInner) {
                        this.firstInner = false;
                        if (n != Long.MAX_VALUE) {
                            --n;
                        }
                    }
                    if (n != 0L) {
                        this.upstream.request(n);
                    }
                })));
            }
            if ((chunk = data.pollChunk()) == null) {
                this.upstream.request(1L);
            } else {
                NettyPartData part = new NettyPartData(() -> {
                    if (data instanceof FileUpload) {
                        FileUpload fileUpload = (FileUpload)((Object)data);
                        return Optional.of(MediaType.of(fileUpload.getContentType()));
                    }
                    return Optional.empty();
                }, chunk::claim);
                this.innerSink.tryEmitNext(part);
            }
        }

        @Override
        public void onError(Throwable t) {
            this.outer.tryEmitError(t);
            if (this.innerSink != null) {
                this.innerSink.tryEmitError(t);
            }
        }

        @Override
        public void onComplete() {
            this.outer.tryEmitComplete();
            if (this.innerSink != null) {
                this.innerSink.tryEmitComplete();
            }
        }
    }
}

