/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.management.health.monitor;

import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.health.CurrentHealthStatus;
import io.micronaut.health.HealthStatus;
import io.micronaut.management.health.indicator.HealthIndicator;
import io.micronaut.management.health.indicator.HealthResult;
import io.micronaut.runtime.server.EmbeddedServer;
import io.micronaut.scheduling.annotation.Scheduled;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;

@Singleton
@Requirements(value={@Requires(beans={EmbeddedServer.class}), @Requires(property="micronaut.application.name"), @Requires(property="micronaut.health.monitor.enabled", value="true", defaultValue="true")})
public class HealthMonitorTask {
    private static final Logger LOG = LoggerFactory.getLogger(HealthMonitorTask.class);
    private final CurrentHealthStatus currentHealthStatus;
    private final List<HealthIndicator> healthIndicators;

    @Inject
    public HealthMonitorTask(CurrentHealthStatus currentHealthStatus, List<HealthIndicator> healthIndicators) {
        this.currentHealthStatus = currentHealthStatus;
        this.healthIndicators = healthIndicators;
    }

    public HealthMonitorTask(CurrentHealthStatus currentHealthStatus, HealthIndicator ... healthIndicators) {
        this(currentHealthStatus, Arrays.asList(healthIndicators));
    }

    @Scheduled(fixedDelay="${micronaut.health.monitor.interval:1m}", initialDelay="${micronaut.health.monitor.initial-delay:1m}")
    void monitor() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Starting health monitor check");
        }
        List resultPublishers = this.healthIndicators.stream().map(HealthIndicator::getResult).collect(Collectors.toList());
        Flux.merge(resultPublishers).collectList().doOnError(e -> {
            if (LOG.isErrorEnabled()) {
                LOG.error("Health monitor check failed with exception: " + e.getMessage(), (Throwable)e);
            }
            this.currentHealthStatus.update(HealthStatus.DOWN.describe("Error occurred running health check: " + e.getMessage()));
        }).subscribe(healthResults -> {
            Optional<HealthResult> firstDown = healthResults.stream().filter(r -> r.getStatus().equals(HealthStatus.DOWN) || r.getStatus().getOperational().orElse(true) == false).findFirst();
            if (firstDown.isPresent()) {
                this.currentHealthStatus.update(firstDown.get().getStatus());
            } else {
                this.currentHealthStatus.update(HealthStatus.UP);
            }
        });
    }
}

