/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.runtime.beans;

import io.micronaut.aop.InterceptorBean;
import io.micronaut.aop.MethodInterceptor;
import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.context.annotation.BootstrapContextCompatible;
import io.micronaut.context.annotation.Mapper;
import io.micronaut.context.expressions.ConfigurableExpressionEvaluationContext;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.beans.BeanIntrospection;
import io.micronaut.core.beans.BeanProperty;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionContext;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.format.Format;
import io.micronaut.core.expressions.EvaluatedExpression;
import io.micronaut.core.expressions.ExpressionEvaluationContext;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.ObjectUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.inject.ExecutableMethod;
import io.micronaut.inject.annotation.AnnotationMetadataHierarchy;
import io.micronaut.inject.annotation.EvaluatedAnnotationMetadata;
import io.micronaut.inject.annotation.MutableAnnotationMetadata;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Function;

@InterceptorBean(value={Mapper.class})
@Internal
@BootstrapContextCompatible
final class MapperIntroduction
implements MethodInterceptor<Object, Object> {
    private final ConversionService conversionService;
    private final Map<ExecutableMethod<?, ?>, MapInvocation> cachedInvocations = new ConcurrentHashMap();

    MapperIntroduction(ConversionService conversionService) {
        this.conversionService = conversionService;
    }

    @Override
    public int getOrder() {
        return -100;
    }

    @Override
    public Object intercept(MethodInvocationContext<Object, Object> context) {
        if (context.hasDeclaredAnnotation(Mapper.class)) {
            ExecutableMethod<Object, Object> key = context.getExecutableMethod();
            MapInvocation invocation = this.cachedInvocations.get(key);
            if (invocation == null) {
                List<AnnotationValue<Mapper.Mapping>> annotations;
                Map<String, Function<Object, BiConsumer<Object, BeanIntrospection.Builder<Object>>>> customMappers;
                Argument toType = context.getReturnType().asArgument();
                Argument<?> fromType = context.getArguments()[0];
                BeanIntrospection<Object> toIntrospection = BeanIntrospection.getIntrospection(toType.getType());
                Class fromClass = fromType.getType();
                boolean isMap = Map.class.isAssignableFrom(fromClass);
                BeanIntrospection<Object> fromIntrospection = isMap ? null : BeanIntrospection.getIntrospection(fromClass);
                AnnotationMetadata annotationMetadata = context.getAnnotationMetadata();
                Mapper.ConflictStrategy conflictStrategy = annotationMetadata.enumValue(Mapper.class, "conflictStrategy", Mapper.ConflictStrategy.class).orElse(null);
                invocation = annotationMetadata.isPresent(Mapper.class, "value") ? (!(customMappers = this.buildCustomMappers(fromIntrospection, toIntrospection, conflictStrategy, annotations = context.getAnnotationValuesByType(Mapper.Mapping.class), isMap)).isEmpty() ? (isMap ? callContext -> {
                    MapStrategy mapStrategy = MapperIntroduction.buildMapStrategy(conflictStrategy, customMappers, callContext);
                    return this.map((Map)callContext.getParameterValues()[0], mapStrategy, toIntrospection);
                } : callContext -> {
                    MapStrategy mapStrategy = MapperIntroduction.buildMapStrategy(conflictStrategy, customMappers, callContext);
                    return this.map(callContext.getParameterValues()[0], mapStrategy, fromIntrospection, toIntrospection);
                }) : this.mapDefault(toIntrospection, fromIntrospection, isMap)) : this.mapDefault(toIntrospection, fromIntrospection, isMap);
                this.cachedInvocations.put(key, invocation);
            }
            return invocation.map(context);
        }
        return context.proceed();
    }

    private static MapStrategy buildMapStrategy(Mapper.ConflictStrategy conflictStrategy, Map<String, Function<Object, BiConsumer<Object, BeanIntrospection.Builder<Object>>>> customMappers, MethodInvocationContext<Object, Object> callContext) {
        MapStrategy mapStrategy = new MapStrategy(conflictStrategy);
        AnnotationMetadata callAnnotationMetadata = callContext.getAnnotationMetadata();
        if (callAnnotationMetadata instanceof EvaluatedAnnotationMetadata) {
            EvaluatedAnnotationMetadata evaluatedAnnotationMetadata = (EvaluatedAnnotationMetadata)callAnnotationMetadata;
            ConfigurableExpressionEvaluationContext evaluationContext = evaluatedAnnotationMetadata.getEvaluationContext();
            customMappers.forEach((name, mapperSupplier) -> mapStrategy.customMappers.put((String)name, (BiConsumer)mapperSupplier.apply(evaluationContext)));
        } else {
            customMappers.forEach((name, mapperSupplier) -> mapStrategy.customMappers.put((String)name, (BiConsumer)mapperSupplier.apply(null)));
        }
        return mapStrategy;
    }

    private Map<String, Function<Object, BiConsumer<Object, BeanIntrospection.Builder<Object>>>> buildCustomMappers(BeanIntrospection<Object> fromIntrospection, BeanIntrospection<Object> toIntrospection, Mapper.ConflictStrategy conflictStrategy, List<AnnotationValue<Mapper.Mapping>> annotations, boolean isMap) {
        HashMap<String, Function<Object, BiConsumer<Object, BeanIntrospection.Builder<Object>>>> customMappers = new HashMap<String, Function<Object, BiConsumer<Object, BeanIntrospection.Builder<Object>>>>();
        for (AnnotationValue<Mapper.Mapping> mapping : annotations) {
            EvaluatedExpression ee;
            int i;
            String to = mapping.stringValue("to").orElse(null);
            String format = mapping.stringValue("format").orElse(null);
            BeanIntrospection.Builder<Object> builderMeta = toIntrospection.builder();
            if (!StringUtils.isNotEmpty(to) || (i = builderMeta.indexOf(to)) == -1) continue;
            Argument<?> argument = builderMeta.getBuilderArguments()[i];
            ArgumentConversionContext<?> conversionContext = null;
            if (format != null) {
                conversionContext = ConversionContext.of(argument);
                MutableAnnotationMetadata annotationMetadata = new MutableAnnotationMetadata();
                annotationMetadata.addAnnotation(Format.class.getName(), Map.of("value", format));
                conversionContext = conversionContext.with(new AnnotationMetadataHierarchy(argument.getAnnotationMetadata(), annotationMetadata));
            } else if (conflictStrategy == Mapper.ConflictStrategy.CONVERT || conflictStrategy == null) {
                conversionContext = ConversionContext.of(argument);
            }
            Map<CharSequence, Object> values = mapping.getValues();
            Object defaultValue = mapping.contains("defaultValue") ? mapping.stringValue("defaultValue").flatMap(v -> this.conversionService.convert(v, argument)).orElseThrow(() -> new IllegalStateException("Invalid defaultValue [" + values.get("defaultValue") + "] specified to @Mapping annotation for type " + argument)) : null;
            Object from = values.get("from");
            Object condition = values.get("condition");
            EvaluatedExpression evaluatedCondition = condition instanceof EvaluatedExpression ? (ee = (EvaluatedExpression)condition) : null;
            ArgumentConversionContext<?> finalConversionContext = conversionContext;
            if (from instanceof EvaluatedExpression) {
                EvaluatedExpression evaluatedExpression = (EvaluatedExpression)from;
                if (evaluatedCondition != null) {
                    customMappers.put(to, expressionEvaluationContext -> (object, builder) -> {
                        ExpressionEvaluationContext evaluationContext = (ExpressionEvaluationContext)expressionEvaluationContext;
                        if (ObjectUtils.coerceToBoolean(evaluatedCondition.evaluate(evaluationContext))) {
                            Object v = evaluatedExpression.evaluate(evaluationContext);
                            this.handleValue(i, argument, defaultValue, finalConversionContext, (BeanIntrospection.Builder<Object>)builder, v);
                        } else if (defaultValue != null) {
                            builder.with(i, argument, defaultValue);
                        }
                    });
                    continue;
                }
                customMappers.put(to, expressionEvaluationContext -> (object, builder) -> {
                    ExpressionEvaluationContext evaluationContext = (ExpressionEvaluationContext)expressionEvaluationContext;
                    Object v = evaluatedExpression.evaluate(evaluationContext);
                    this.handleValue(i, argument, defaultValue, finalConversionContext, (BeanIntrospection.Builder<Object>)builder, v);
                });
                continue;
            }
            if (from == null) continue;
            String propertyName = from.toString();
            if (fromIntrospection != null) {
                BeanProperty<Object, Object> fromProperty = fromIntrospection.getRequiredProperty(propertyName, Object.class);
                customMappers.put(to, expressionEvaluationContext -> (object, builder) -> {
                    Object result = fromProperty.get(object);
                    this.handleValue(i, argument, defaultValue, finalConversionContext, (BeanIntrospection.Builder<Object>)builder, result);
                });
                continue;
            }
            if (!isMap) continue;
            customMappers.put(to, expressionEvaluationContext -> (object, builder) -> {
                Object result = ((Map)object).get(propertyName);
                this.handleValue(i, argument, defaultValue, finalConversionContext, (BeanIntrospection.Builder<Object>)builder, result);
            });
        }
        return customMappers;
    }

    private void handleValue(int index, Argument<Object> argument, Object defaultValue, ArgumentConversionContext<?> conversionContext, BeanIntrospection.Builder<Object> builder, Object value) {
        if (value == null) {
            if (defaultValue != null) {
                builder.with(index, argument, defaultValue);
            }
        } else if (argument.isInstance(value)) {
            builder.with(index, argument, value);
        } else if (conversionContext != null) {
            builder.convert(index, conversionContext, value, this.conversionService);
        } else {
            throw new IllegalArgumentException("Cannot map invalid value [" + value + "] to type: " + argument);
        }
    }

    private MapInvocation mapDefault(BeanIntrospection<Object> toIntrospection, BeanIntrospection<Object> fromIntrospection, boolean isMap) {
        MapInvocation invocation = isMap ? callContext -> this.map((Map)callContext.getParameterValues()[0], MapStrategy.DEFAULT, toIntrospection) : callContext -> this.map(callContext.getParameterValues()[0], MapStrategy.DEFAULT, fromIntrospection, toIntrospection);
        return invocation;
    }

    private <I, O> O map(I input, MapStrategy mapStrategy, BeanIntrospection<I> inputIntrospection, BeanIntrospection<O> outputIntrospection) {
        boolean isDefault = mapStrategy == MapStrategy.DEFAULT;
        Mapper.ConflictStrategy conflictStrategy = mapStrategy.conflictStrategy();
        BeanIntrospection.Builder<O> builder = outputIntrospection.builder();
        @NonNull Argument<?>[] arguments = builder.getBuilderArguments();
        if (!isDefault) {
            this.processCustomMappers(input, mapStrategy, builder, arguments);
        }
        for (BeanProperty<I, Object> beanProperty : inputIntrospection.getBeanProperties()) {
            int i;
            if (beanProperty.isWriteOnly()) continue;
            String propertyName = beanProperty.getName();
            if (!isDefault && mapStrategy.customMappers().containsKey(propertyName) || (i = builder.indexOf(propertyName)) <= -1) continue;
            Argument<?> argument = arguments[i];
            Object value = beanProperty.get(input);
            if (argument.isInstance(value)) {
                builder.with(i, argument, value);
                continue;
            }
            if (conflictStrategy == Mapper.ConflictStrategy.CONVERT) {
                ArgumentConversionContext<?> conversionContext = ConversionContext.of(argument);
                builder.convert(i, conversionContext, value, this.conversionService);
                continue;
            }
            builder.with(i, argument, value);
        }
        return builder.build();
    }

    private <I, O> void processCustomMappers(I input, MapStrategy mapStrategy, BeanIntrospection.Builder<O> builder, @NonNull Argument<Object>[] arguments) {
        Map<String, BiConsumer<Object, BeanIntrospection.Builder<Object>>> customMappers = mapStrategy.customMappers();
        customMappers.forEach((name, func) -> {
            int i = builder.indexOf((String)name);
            if (i > -1) {
                func.accept(input, builder);
            }
        });
    }

    private <O> O map(Map<String, Object> input, MapStrategy mapStrategy, BeanIntrospection<O> outputIntrospection) {
        BeanIntrospection.Builder<O> builder = outputIntrospection.builder();
        @NonNull Argument<?>[] arguments = builder.getBuilderArguments();
        this.handleMapInput(input, mapStrategy, builder, arguments);
        return builder.build();
    }

    private <O> void handleMapInput(Map<String, Object> input, MapStrategy mapStrategy, BeanIntrospection.Builder<O> builder, @NonNull Argument<Object>[] arguments) {
        boolean isDefault;
        Mapper.ConflictStrategy conflictStrategy = mapStrategy.conflictStrategy();
        boolean bl = isDefault = mapStrategy == MapStrategy.DEFAULT;
        if (!isDefault) {
            this.processCustomMappers(input, mapStrategy, builder, arguments);
        }
        input.forEach((key, value) -> {
            int i = builder.indexOf((String)key);
            if (!isDefault && mapStrategy.customMappers().containsKey(key)) {
                return;
            }
            if (i > -1) {
                Argument argument = arguments[i];
                if (conflictStrategy == Mapper.ConflictStrategy.CONVERT) {
                    builder.convert(i, ConversionContext.of(argument), value, this.conversionService);
                } else {
                    builder.with(i, argument, value);
                }
            }
        });
    }

    @FunctionalInterface
    private static interface MapInvocation {
        public Object map(MethodInvocationContext<Object, Object> var1);
    }

    private record MapStrategy(Mapper.ConflictStrategy conflictStrategy, Map<String, BiConsumer<Object, BeanIntrospection.Builder<Object>>> customMappers) {
        static final MapStrategy DEFAULT = new MapStrategy(Mapper.ConflictStrategy.CONVERT, Collections.emptyMap());

        private MapStrategy {
            if (conflictStrategy == null) {
                conflictStrategy = Mapper.ConflictStrategy.CONVERT;
            }
            if (customMappers == null) {
                customMappers = new HashMap<String, BiConsumer<Object, BeanIntrospection.Builder<Object>>>();
            }
        }

        public MapStrategy(Mapper.ConflictStrategy conflictStrategy) {
            this(conflictStrategy, new HashMap<String, BiConsumer<Object, BeanIntrospection.Builder<Object>>>());
        }
    }
}

