/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.testresources.testcontainers;

import io.micronaut.testresources.core.Scope;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.Network;

public final class TestContainers {
    private static final Map<Key, GenericContainer<?>> CONTAINERS_BY_KEY = new HashMap();
    private static final Map<String, Set<GenericContainer<?>>> CONTAINERS_BY_PROPERTY = new HashMap();
    private static final ReentrantLock LOCK = new ReentrantLock();
    private static final Logger LOGGER = LoggerFactory.getLogger(TestContainers.class);
    private static final Map<String, Network> NETWORKS_BY_KEY = new ConcurrentHashMap<String, Network>();

    private TestContainers() {
    }

    private static <B> B withLock(String description, Supplier<B> supplier) {
        LOCK.lock();
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Locked for {}", (Object)description);
        }
        try {
            B b = supplier.get();
            return b;
        }
        finally {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Unlocked for {}", (Object)description);
            }
            LOCK.unlock();
        }
    }

    static <T extends GenericContainer<? extends T>> T getOrCreate(String requestedProperty, Class<?> owner, String name, Map<String, Object> query, Supplier<T> creator) {
        Key key = Key.of(owner, name, Scope.from(query), query);
        return (T)TestContainers.withLock("getOrCreate", () -> {
            GenericContainer container = CONTAINERS_BY_KEY.get(key);
            if (container == null) {
                container = (GenericContainer)creator.get();
                LOGGER.info("Starting test container {}", (Object)name);
                container.start();
                CONTAINERS_BY_KEY.put(key, container);
            }
            CONTAINERS_BY_PROPERTY.computeIfAbsent(requestedProperty, e -> new LinkedHashSet()).add(container);
            return container;
        });
    }

    public static Map<Scope, List<GenericContainer<?>>> listAll() {
        return TestContainers.listByScope(Scope.ROOT);
    }

    public static Map<Scope, List<GenericContainer<?>>> listByScope(String id) {
        Scope scope = Scope.of(id);
        return TestContainers.listByScope(scope);
    }

    private static Map<Scope, List<GenericContainer<?>>> listByScope(Scope scope) {
        return TestContainers.withLock("listByScope", () -> CONTAINERS_BY_KEY.entrySet().stream().filter(entry -> scope.includes(((Key)entry.getKey()).scope)).collect(Collectors.groupingBy(entry -> ((Key)entry.getKey()).scope, Collectors.mapping(Map.Entry::getValue, Collectors.toList()))));
    }

    private static List<GenericContainer<?>> filterByScope(Scope scope, Set<GenericContainer<?>> containers) {
        if (containers.isEmpty()) {
            return Collections.emptyList();
        }
        return TestContainers.withLock("filterByScope", () -> CONTAINERS_BY_KEY.entrySet().stream().filter(entry -> containers.contains(entry.getValue()) && scope.includes(((Key)entry.getKey()).scope)).map(Map.Entry::getValue).collect(Collectors.toList()));
    }

    public static Network network(String name) {
        return NETWORKS_BY_KEY.computeIfAbsent(name, k -> Network.newNetwork());
    }

    public static boolean closeAll() {
        return TestContainers.withLock("closeAll", () -> {
            boolean closed = false;
            for (GenericContainer<?> container : CONTAINERS_BY_KEY.values()) {
                container.close();
                closed = true;
            }
            CONTAINERS_BY_KEY.clear();
            CONTAINERS_BY_PROPERTY.clear();
            NETWORKS_BY_KEY.values().forEach(Network::close);
            NETWORKS_BY_KEY.clear();
            return closed;
        });
    }

    public static Map<String, Network> getNetworks() {
        return Collections.unmodifiableMap(NETWORKS_BY_KEY);
    }

    public static boolean closeScope(String id) {
        Scope scope = Scope.of(id);
        return TestContainers.withLock("closeScope", () -> {
            boolean closed = false;
            Iterator<Map.Entry<Key, GenericContainer<?>>> iterator = CONTAINERS_BY_KEY.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<Key, GenericContainer<?>> entry = iterator.next();
                Scope existingScope = entry.getKey().scope;
                if (!scope.includes(existingScope)) continue;
                iterator.remove();
                GenericContainer<?> container = entry.getValue();
                LOGGER.debug("Stopping container {}", (Object)container.getContainerId());
                container.close();
                closed = true;
                for (Set<GenericContainer<?>> value : CONTAINERS_BY_PROPERTY.values()) {
                    value.remove(container);
                }
            }
            return closed;
        });
    }

    public static List<GenericContainer<?>> findByRequestedProperty(Scope scope, String property) {
        return TestContainers.withLock("findByRequestedProperty", () -> {
            Set<GenericContainer<?>> byProperty = CONTAINERS_BY_PROPERTY.getOrDefault(property, Collections.emptySet());
            LOGGER.debug("Found {} containers for property {}. All properties: {}", byProperty.size(), property, CONTAINERS_BY_PROPERTY.keySet());
            return TestContainers.filterByScope(scope, byProperty);
        });
    }

    private static final class Key {
        private final Class<?> type;
        private final String name;
        private final Map<String, String> properties;
        private final int hashCode;
        final Scope scope;

        private Key(Class<?> type, String name, Scope scope, Map<String, String> properties) {
            this.type = type;
            this.name = name;
            this.scope = scope;
            this.properties = properties;
            this.hashCode = 31 * (31 * (31 * type.hashCode() + properties.hashCode()) + scope.hashCode()) + name.hashCode();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            if (!this.name.equals(key.name)) {
                return false;
            }
            if (!this.scope.equals(key.scope)) {
                return false;
            }
            if (!this.type.equals(key.type)) {
                return false;
            }
            return this.properties.equals(key.properties);
        }

        public int hashCode() {
            return this.hashCode;
        }

        static <T> Key of(Class<T> type, String name, Scope scope, Map<String, Object> properties) {
            if (properties.isEmpty()) {
                return new Key(type, name, scope, Collections.emptyMap());
            }
            HashMap<String, String> converted = new HashMap<String, String>(properties.size());
            for (Map.Entry<String, Object> entry : properties.entrySet()) {
                converted.put(entry.getKey(), String.valueOf(entry.getValue()));
            }
            return new Key(type, name, scope, Collections.unmodifiableMap(converted));
        }
    }
}

