/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.context.conditions;

import io.micronaut.context.annotation.Requires;
import io.micronaut.context.condition.Condition;
import io.micronaut.context.conditions.MatchesAbsenceOfBeansCondition;
import io.micronaut.context.conditions.MatchesAbsenceOfClassesCondition;
import io.micronaut.context.conditions.MatchesConfigurationCondition;
import io.micronaut.context.conditions.MatchesCurrentNotOsCondition;
import io.micronaut.context.conditions.MatchesCurrentOsCondition;
import io.micronaut.context.conditions.MatchesCustomCondition;
import io.micronaut.context.conditions.MatchesEnvironmentCondition;
import io.micronaut.context.conditions.MatchesMissingPropertyCondition;
import io.micronaut.context.conditions.MatchesNotEnvironmentCondition;
import io.micronaut.context.conditions.MatchesPresenceOfBeansCondition;
import io.micronaut.context.conditions.MatchesPresenceOfClassesCondition;
import io.micronaut.context.conditions.MatchesPresenceOfEntitiesCondition;
import io.micronaut.context.conditions.MatchesPresenceOfResourcesCondition;
import io.micronaut.context.conditions.MatchesPropertyCondition;
import io.micronaut.context.conditions.MatchesSdkCondition;
import io.micronaut.core.annotation.AnnotationClassValue;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.util.StringUtils;
import java.util.EnumSet;
import java.util.List;

@Internal
public class MatchesConditionUtils {
    private MatchesConditionUtils() {
    }

    public static void createConditions(AnnotationValue<Requires> requirement, List<Condition> preConditions, List<Condition> postConditions) {
        AnnotationClassValue<?>[] beans;
        EnumSet<Requires.Family> notOs;
        EnumSet<Requires.Family> os;
        Object[] resourcePaths;
        String configurationName;
        String property;
        String[] env;
        AnnotationClassValue<?>[] classes;
        if (requirement.contains("classes") && (classes = requirement.annotationClassValues("classes")).length > 0) {
            preConditions.add(new MatchesPresenceOfClassesCondition(classes));
        }
        if (requirement.contains("missing") && (classes = requirement.annotationClassValues("missing")).length > 0) {
            preConditions.add(new MatchesAbsenceOfClassesCondition(classes));
        }
        if (requirement.contains("env") && (env = requirement.stringValues("env")).length > 0) {
            preConditions.add(new MatchesEnvironmentCondition(env));
        }
        if (requirement.contains("notEnv") && (env = requirement.stringValues("notEnv")).length > 0) {
            preConditions.add(new MatchesNotEnvironmentCondition(env));
        }
        if (requirement.contains("entities") && (classes = requirement.annotationClassValues("entities")).length > 0) {
            preConditions.add(new MatchesPresenceOfEntitiesCondition(classes));
        }
        if (requirement.contains("property") && StringUtils.isNotEmpty(property = (String)requirement.stringValue("property").orElse(null))) {
            MatchesPropertyCondition.Condition condition = MatchesPropertyCondition.Condition.CONTAINS;
            String value = requirement.stringValue().orElse(null);
            if (value != null) {
                condition = MatchesPropertyCondition.Condition.EQUALS;
            }
            String defaultValue = requirement.stringValue("defaultValue").orElse(null);
            if (value == null) {
                String notEquals = requirement.stringValue("notEquals").orElse(null);
                if (notEquals != null) {
                    value = notEquals;
                    condition = MatchesPropertyCondition.Condition.NOT_EQUALS;
                } else {
                    String pattern = requirement.stringValue("pattern").orElse(null);
                    if (pattern != null) {
                        value = pattern;
                        condition = MatchesPropertyCondition.Condition.PATTERN;
                    }
                }
            }
            preConditions.add(new MatchesPropertyCondition(property, value, defaultValue, condition));
        }
        if (requirement.contains("missingProperty") && StringUtils.isNotEmpty(property = (String)requirement.stringValue("missingProperty").orElse(null))) {
            preConditions.add(new MatchesMissingPropertyCondition(property));
        }
        if (requirement.contains("configuration") && StringUtils.isNotEmpty(configurationName = (String)requirement.stringValue("configuration").orElse(null))) {
            String minimumVersion = requirement.stringValue("version").orElse(null);
            preConditions.add(new MatchesConfigurationCondition(configurationName, minimumVersion));
        }
        if (requirement.contains("sdk")) {
            Requires.Sdk sdk = requirement.enumValue("sdk", Requires.Sdk.class).orElse(null);
            String version = requirement.stringValue("version").orElse(null);
            if (sdk != null && StringUtils.isNotEmpty(version)) {
                preConditions.add(new MatchesSdkCondition(sdk, version));
            }
        }
        if (requirement.contains("resources") && ArrayUtils.isNotEmpty(resourcePaths = requirement.stringValues("resources"))) {
            preConditions.add(new MatchesPresenceOfResourcesCondition((String[])resourcePaths));
        }
        if (requirement.contains("os") && !(os = requirement.enumValuesSet("os", Requires.Family.class)).isEmpty()) {
            preConditions.add(new MatchesCurrentOsCondition(os));
        }
        if (requirement.contains("notOs") && !(notOs = requirement.enumValuesSet("notOs", Requires.Family.class)).isEmpty()) {
            preConditions.add(new MatchesCurrentNotOsCondition(notOs));
        }
        if (requirement.contains("bean")) {
            AnnotationClassValue bean = requirement.annotationClassValue("bean").orElse(null);
            preConditions.add(new MatchesPresenceOfClassesCondition(new AnnotationClassValue[]{bean}));
            postConditions.add(new MatchesPresenceOfBeansCondition(new AnnotationClassValue[]{bean}));
        }
        if (requirement.contains("beans") && (beans = requirement.annotationClassValues("beans")).length != 0) {
            preConditions.add(new MatchesPresenceOfClassesCondition(beans));
            postConditions.add(new MatchesPresenceOfBeansCondition(beans));
        }
        if (requirement.contains("missingBeans") && (beans = requirement.annotationClassValues("missingBeans")).length != 0) {
            postConditions.add(new MatchesAbsenceOfBeansCondition(beans));
        }
        if (requirement.contains("condition")) {
            requirement.annotationClassValue("condition").ifPresent(annotationClassValue -> postConditions.add(new MatchesCustomCondition((AnnotationClassValue<?>)annotationClassValue)));
        }
    }
}

