/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.context.conditions;

import io.micronaut.context.BeanContext;
import io.micronaut.context.condition.Condition;
import io.micronaut.context.condition.ConditionContext;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.util.StringUtils;
import io.micronaut.core.version.SemanticVersion;
import io.micronaut.inject.BeanConfiguration;
import java.util.Objects;
import java.util.Optional;

@Internal
public record MatchesConfigurationCondition(String configurationName, @Nullable String minimumVersion) implements Condition
{
    @Override
    public boolean matches(ConditionContext context) {
        BeanContext beanContext = context.getBeanContext();
        Optional<BeanConfiguration> beanConfiguration = beanContext.findBeanConfiguration(this.configurationName);
        if (beanConfiguration.isEmpty()) {
            context.fail("Required configuration [" + this.configurationName + "] is not active");
            return false;
        }
        String version = beanConfiguration.get().getVersion();
        if (version != null && StringUtils.isNotEmpty(this.minimumVersion)) {
            boolean matches = SemanticVersion.isAtLeast(version, this.minimumVersion);
            if (!matches) {
                context.fail("Required configuration [" + this.configurationName + "] version requirements not met. Required: " + this.minimumVersion + ", Current: " + version);
            }
            return matches;
        }
        return true;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MatchesConfigurationCondition that = (MatchesConfigurationCondition)o;
        return Objects.equals(this.minimumVersion, that.minimumVersion) && Objects.equals(this.configurationName, that.configurationName);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.configurationName, this.minimumVersion);
    }

    @Override
    public String toString() {
        return "MatchesConfigurationCondition{configurationName='" + this.configurationName + "', minimumVersion='" + this.minimumVersion + "'}";
    }
}

