/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.context.conditions;

import io.micronaut.context.BeanContext;
import io.micronaut.context.condition.Condition;
import io.micronaut.context.condition.ConditionContext;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.value.PropertyResolver;
import java.util.Objects;

@Internal
public record MatchesMissingPropertyCondition(String property) implements Condition
{
    @Override
    public boolean matches(ConditionContext context) {
        PropertyResolver propertyResolver;
        BeanContext beanContext = context.getBeanContext();
        if (beanContext instanceof PropertyResolver && (propertyResolver = (PropertyResolver)((Object)beanContext)).containsProperties(this.property)) {
            context.fail("Property [" + this.property + "] present");
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MatchesMissingPropertyCondition that = (MatchesMissingPropertyCondition)o;
        return Objects.equals(this.property, that.property);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.property);
    }

    @Override
    public String toString() {
        return "MatchesMissingPropertyCondition{property='" + this.property + "'}";
    }
}

