/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.context.conditions;

import io.micronaut.context.ApplicationContext;
import io.micronaut.context.BeanContext;
import io.micronaut.context.condition.Condition;
import io.micronaut.context.condition.ConditionContext;
import io.micronaut.context.env.Environment;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.io.ResourceLoader;
import io.micronaut.core.io.ResourceResolver;
import io.micronaut.core.io.file.FileSystemResourceLoader;
import io.micronaut.core.io.scan.ClassPathResourceLoader;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

@Internal
public record MatchesPresenceOfResourcesCondition(String[] resourcePaths) implements Condition
{
    @Override
    public boolean matches(ConditionContext context) {
        List<ResourceLoader> resourceLoaders;
        BeanContext beanContext = context.getBeanContext();
        if (beanContext instanceof ApplicationContext) {
            ApplicationContext applicationContext = (ApplicationContext)beanContext;
            Environment resourceLoader = applicationContext.getEnvironment();
            resourceLoaders = Arrays.asList(resourceLoader, FileSystemResourceLoader.defaultLoader());
        } else {
            resourceLoaders = Arrays.asList(ClassPathResourceLoader.defaultLoader(beanContext.getClassLoader()), FileSystemResourceLoader.defaultLoader());
        }
        ResourceResolver resolver = new ResourceResolver(resourceLoaders);
        for (String resourcePath : this.resourcePaths) {
            if (!resolver.getResource(resourcePath).isEmpty()) continue;
            context.fail("Resource [" + resourcePath + "] does not exist");
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MatchesPresenceOfResourcesCondition that = (MatchesPresenceOfResourcesCondition)o;
        return Objects.deepEquals(this.resourcePaths, that.resourcePaths);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.resourcePaths);
    }

    @Override
    public String toString() {
        return "MatchesPresenceOfResourcesCondition{resourcePaths=" + Arrays.toString(this.resourcePaths) + "}";
    }
}

