/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.async.propagation;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.async.propagation.ReactorPropagation;
import io.micronaut.core.propagation.PropagatedContext;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.CorePublisher;
import reactor.core.CoreSubscriber;
import reactor.util.context.Context;

public final class ReactivePropagation {
    private ReactivePropagation() {
    }

    public static <T> Publisher<T> propagate(PropagatedContext propagatedContext, Publisher<T> actual) {
        if (actual instanceof CorePublisher) {
            CorePublisher corePublisher = (CorePublisher)actual;
            return ReactivePropagation.propagate(propagatedContext, corePublisher);
        }
        return subscriber -> {
            try (PropagatedContext.Scope ignore = propagatedContext.propagate();){
                actual.subscribe(ReactivePropagation.propagate(propagatedContext, subscriber));
            }
        };
    }

    public static <T> Publisher<T> propagate(final PropagatedContext propagatedContext, final CorePublisher<T> actual) {
        return new CorePublisher<T>(){

            @Override
            public void subscribe(@NonNull CoreSubscriber<? super T> subscriber) {
                try (PropagatedContext.Scope ignore = propagatedContext.propagate();){
                    actual.subscribe(ReactivePropagation.propagate(propagatedContext, subscriber));
                }
            }

            @Override
            public void subscribe(Subscriber<? super T> subscriber) {
                if (subscriber instanceof CoreSubscriber) {
                    CoreSubscriber coreSubscriber = (CoreSubscriber)subscriber;
                    this.subscribe(coreSubscriber);
                    return;
                }
                try (PropagatedContext.Scope ignore = propagatedContext.propagate();){
                    actual.subscribe(ReactivePropagation.propagate(propagatedContext, subscriber));
                }
            }
        };
    }

    public static <T> Subscriber<T> propagate(final PropagatedContext propagatedContext, final Subscriber<T> actual) {
        return new CoreSubscriber<T>(){

            @Override
            @NonNull
            public Context currentContext() {
                Context ctx;
                if (actual instanceof CoreSubscriber) {
                    CoreSubscriber actualSubscriber = (CoreSubscriber)actual;
                    ctx = actualSubscriber.currentContext();
                } else {
                    ctx = Context.empty();
                }
                return ReactorPropagation.addPropagatedContext(ctx, propagatedContext);
            }

            @Override
            public void onSubscribe(@NonNull Subscription s2) {
                try (PropagatedContext.Scope ignore = propagatedContext.propagate();){
                    actual.onSubscribe(s2);
                }
            }

            @Override
            public void onNext(T t2) {
                try (PropagatedContext.Scope ignore = propagatedContext.propagate();){
                    actual.onNext(t2);
                }
            }

            @Override
            public void onError(Throwable t2) {
                try (PropagatedContext.Scope ignore = propagatedContext.propagate();){
                    actual.onError(t2);
                }
            }

            @Override
            public void onComplete() {
                try (PropagatedContext.Scope ignore = propagatedContext.propagate();){
                    actual.onComplete();
                }
            }
        };
    }
}

