/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.async.subscriber;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.execution.DelayedExecutionFlow;
import io.micronaut.core.execution.ExecutionFlow;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.CorePublisher;
import reactor.core.CoreSubscriber;
import reactor.core.publisher.Operators;
import reactor.core.publisher.Signal;
import reactor.util.context.Context;

@Internal
public final class LazySendingSubscriber<T>
implements CoreSubscriber<T>,
CorePublisher<T>,
Subscription {
    private final DelayedExecutionFlow<Publisher<T>> result = DelayedExecutionFlow.create();
    private boolean receivedFirst = false;
    private volatile boolean sentFirst = false;
    private boolean sendingFirst = false;
    private T first;
    private Subscription upstream;
    private volatile CoreSubscriber<? super T> downstream;
    private Signal<? extends T> heldBackSignal;
    private long heldBackDemand = 0L;

    private LazySendingSubscriber() {
    }

    @NonNull
    public static <T> ExecutionFlow<Publisher<T>> create(@NonNull Publisher<T> input) {
        LazySendingSubscriber<T> subscriber = new LazySendingSubscriber<T>();
        input.subscribe(subscriber);
        return subscriber.result;
    }

    @Override
    public Context currentContext() {
        return this.downstream == null ? Context.empty() : this.downstream.currentContext();
    }

    @Override
    public void onSubscribe(Subscription s2) {
        this.upstream = s2;
        s2.request(1L);
    }

    @Override
    public void onNext(T t2) {
        if (!this.receivedFirst) {
            this.receivedFirst = true;
            this.first = t2;
            this.result.complete(this);
        } else {
            this.downstream.onNext(t2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onError(Throwable t2) {
        if (this.receivedFirst) {
            CoreSubscriber<T> d;
            LazySendingSubscriber lazySendingSubscriber = this;
            synchronized (lazySendingSubscriber) {
                d = this.downstream;
                if (d == null || !this.sentFirst) {
                    this.heldBackSignal = Signal.error(t2);
                    return;
                }
            }
            d.onError(t2);
        } else {
            this.receivedFirst = true;
            this.result.completeExceptionally(t2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onComplete() {
        CoreSubscriber<T> d;
        if (!this.receivedFirst) {
            this.onNext(null);
        }
        LazySendingSubscriber lazySendingSubscriber = this;
        synchronized (lazySendingSubscriber) {
            d = this.downstream;
            if (d == null || !this.sentFirst) {
                this.heldBackSignal = Signal.complete();
                return;
            }
        }
        d.onComplete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void subscribe(CoreSubscriber<? super T> subscriber) {
        LazySendingSubscriber lazySendingSubscriber = this;
        synchronized (lazySendingSubscriber) {
            this.downstream = subscriber;
        }
        subscriber.onSubscribe(this);
    }

    @Override
    public void subscribe(Subscriber<? super T> s2) {
        this.subscribe(Operators.toCoreSubscriber(s2));
    }

    private static long saturatingAdd(long a, long b) {
        long sum = a + b;
        if (sum < a) {
            return Long.MAX_VALUE;
        }
        return sum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void request(long n) {
        if (!this.sentFirst) {
            Signal<? super T> heldBackSignal;
            if (this.sendingFirst) {
                LazySendingSubscriber lazySendingSubscriber = this;
                synchronized (lazySendingSubscriber) {
                    if (!this.sentFirst) {
                        this.heldBackDemand = LazySendingSubscriber.saturatingAdd(this.heldBackDemand, n);
                        return;
                    }
                }
                this.upstream.request(n);
                return;
            }
            this.sendingFirst = true;
            if (this.first != null) {
                this.downstream.onNext(this.first);
                this.first = null;
            }
            LazySendingSubscriber lazySendingSubscriber = this;
            synchronized (lazySendingSubscriber) {
                this.sentFirst = true;
                heldBackSignal = this.heldBackSignal;
                n = LazySendingSubscriber.saturatingAdd(n, this.heldBackDemand);
            }
            if (heldBackSignal != null) {
                heldBackSignal.accept(this.downstream);
                return;
            }
            if (--n <= 0L) {
                return;
            }
        }
        this.upstream.request(n);
    }

    @Override
    public void cancel() {
        if (!this.sentFirst) {
            this.sentFirst = true;
            T t2 = this.first;
            this.first = null;
            Operators.onNextDropped(t2, this.currentContext());
        }
        this.upstream.cancel();
    }
}

