/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.execution;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.execution.DelayedExecutionFlow;
import io.micronaut.core.execution.ImperativeExecutionFlow;
import io.micronaut.core.execution.ImperativeExecutionFlowImpl;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;

@Internal
public interface ExecutionFlow<T> {
    @NonNull
    public static <K> ExecutionFlow<K> just(@Nullable K value) {
        return new ImperativeExecutionFlowImpl(value, null);
    }

    @NonNull
    public static <K> ExecutionFlow<K> error(@NonNull Throwable e) {
        return new ImperativeExecutionFlowImpl(null, e);
    }

    @NonNull
    public static <T> ExecutionFlow<T> empty() {
        return new ImperativeExecutionFlowImpl(null, null);
    }

    @NonNull
    public static <T> ExecutionFlow<T> async(@NonNull Executor executor, @NonNull Supplier<? extends ExecutionFlow<T>> supplier) {
        DelayedExecutionFlow completableFuture = DelayedExecutionFlow.create();
        executor.execute(() -> ((ExecutionFlow)supplier.get()).onComplete(completableFuture::complete));
        return completableFuture;
    }

    @NonNull
    public <R> ExecutionFlow<R> map(@NonNull Function<? super T, ? extends R> var1);

    @NonNull
    public <R> ExecutionFlow<R> flatMap(@NonNull Function<? super T, ? extends ExecutionFlow<? extends R>> var1);

    @NonNull
    public <R> ExecutionFlow<R> then(@NonNull Supplier<? extends ExecutionFlow<? extends R>> var1);

    @NonNull
    public ExecutionFlow<T> onErrorResume(@NonNull Function<? super Throwable, ? extends ExecutionFlow<? extends T>> var1);

    @NonNull
    public ExecutionFlow<T> putInContext(@NonNull String var1, @NonNull Object var2);

    @NonNull
    default public ExecutionFlow<T> putInContextIfAbsent(@NonNull String key, @NonNull Object value) {
        return this;
    }

    public void onComplete(@NonNull BiConsumer<? super T, Throwable> var1);

    public void completeTo(@NonNull CompletableFuture<T> var1);

    @NonNull
    default public ExecutionFlow<T> timeout(@NonNull Duration timeout, @NonNull ScheduledExecutorService scheduler, @Nullable BiConsumer<T, Throwable> onDiscard) {
        DelayedExecutionFlow delayed = DelayedExecutionFlow.create();
        AtomicBoolean completed = new AtomicBoolean(false);
        ScheduledFuture<?> future = scheduler.schedule(() -> {
            if (completed.compareAndSet(false, true)) {
                this.cancel();
                delayed.completeExceptionally(new TimeoutException());
            }
        }, timeout.toNanos(), TimeUnit.NANOSECONDS);
        this.onComplete((t2, throwable) -> {
            if (completed.compareAndSet(false, true)) {
                future.cancel(false);
                if (throwable != null) {
                    delayed.completeExceptionally((Throwable)throwable);
                } else {
                    delayed.complete(t2);
                }
            } else if (onDiscard != null) {
                onDiscard.accept((Object)t2, (Throwable)throwable);
            }
        });
        delayed.onCancel(this::cancel);
        return delayed;
    }

    @Nullable
    public ImperativeExecutionFlow<T> tryComplete();

    @Nullable
    default public T tryCompleteValue() {
        ImperativeExecutionFlow<T> imperativeFlow = this.tryComplete();
        if (imperativeFlow != null) {
            return imperativeFlow.getValue();
        }
        return null;
    }

    @Nullable
    default public Throwable tryCompleteError() {
        ImperativeExecutionFlow<T> imperativeFlow = this.tryComplete();
        if (imperativeFlow != null) {
            return imperativeFlow.getError();
        }
        return null;
    }

    @NonNull
    default public CompletableFuture<T> toCompletableFuture() {
        CompletableFuture completableFuture = new CompletableFuture();
        this.completeTo(completableFuture);
        return completableFuture;
    }

    default public void cancel() {
    }
}

