/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.reflect;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.beans.BeanIntrospection;
import io.micronaut.core.beans.BeanIntrospector;
import io.micronaut.core.convert.ConversionContext;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.exceptions.ConversionErrorException;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.core.reflect.ClassUtils;
import io.micronaut.core.reflect.exception.InstantiationException;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.core.util.CollectionUtils;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstantiationUtils {
    public static Optional<?> tryInstantiate(String name, ClassLoader classLoader) {
        try {
            return ClassUtils.forName(name, classLoader).flatMap(InstantiationUtils::tryInstantiate);
        }
        catch (Throwable e) {
            Logger log = LoggerFactory.getLogger(InstantiationUtils.class);
            if (log.isDebugEnabled()) {
                log.debug("Tried, but could not instantiate type: {}", (Object)name, (Object)e);
            }
            return Optional.empty();
        }
    }

    @NonNull
    public static <T> Optional<T> tryInstantiate(@NonNull Class<T> type, Map propertiesMap, ConversionContext context) {
        ArgumentUtils.requireNonNull("type", type);
        if (propertiesMap.isEmpty()) {
            return InstantiationUtils.tryInstantiate(type);
        }
        Supplier<Object> reflectionFallback = () -> {
            Logger log = LoggerFactory.getLogger(InstantiationUtils.class);
            if (log.isDebugEnabled()) {
                log.debug("Tried, but could not instantiate type: {}", (Object)type);
            }
            return null;
        };
        Object result = BeanIntrospector.SHARED.findIntrospection(type).map(introspection -> {
            Argument<?>[] constructorArguments = introspection.getConstructorArguments();
            ArrayList arguments = new ArrayList(constructorArguments.length);
            try {
                Object instance;
                if (constructorArguments.length > 0) {
                    LinkedHashMap bindMap = CollectionUtils.newLinkedHashMap(propertiesMap.size());
                    Set entries = propertiesMap.entrySet();
                    for (Map.Entry entry : entries) {
                        Object key = entry.getKey();
                        bindMap.put(NameUtils.decapitalize(NameUtils.dehyphenate(key.toString())), entry.getValue());
                    }
                    for (Argument<?> argument : constructorArguments) {
                        if (bindMap.containsKey(argument.getName())) {
                            Object converted = ConversionService.SHARED.convert(bindMap.get(argument.getName()), argument.getType(), ConversionContext.of(argument)).orElseThrow(() -> new ConversionErrorException(argument, context.getLastError().orElse(() -> new IllegalArgumentException("Value [" + bindMap.get(argument.getName()) + "] cannot be converted to type : " + argument.getType()))));
                            arguments.add(converted);
                            continue;
                        }
                        if (argument.isDeclaredNullable()) {
                            arguments.add(null);
                            continue;
                        }
                        context.reject(new ConversionErrorException(argument, () -> new IllegalArgumentException("No Value found for argument " + argument.getName())));
                    }
                    instance = introspection.instantiate(arguments.toArray());
                } else {
                    instance = introspection.instantiate();
                }
                return instance;
            }
            catch (InstantiationException e) {
                return reflectionFallback.get();
            }
        }).orElseGet(reflectionFallback);
        return Optional.ofNullable(result);
    }

    @NonNull
    public static <T> Optional<T> tryInstantiate(@NonNull Class<T> type) {
        ArgumentUtils.requireNonNull("type", type);
        Supplier<Object> reflectionFallback = () -> {
            Logger logger = ClassUtils.REFLECTION_LOGGER;
            if (logger.isDebugEnabled()) {
                logger.debug("Cannot instantiate type [{}] without reflection. Attempting reflective instantiation", (Object)type);
            }
            try {
                Object bean = type.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                if (type.isInstance(bean)) {
                    return bean;
                }
                return null;
            }
            catch (Throwable e) {
                try {
                    Constructor defaultConstructor = type.getDeclaredConstructor(new Class[0]);
                    defaultConstructor.setAccessible(true);
                    return InstantiationUtils.tryInstantiate(defaultConstructor, new Object[0]).orElse(null);
                }
                catch (Throwable e1) {
                    Logger log = LoggerFactory.getLogger(InstantiationUtils.class);
                    if (log.isDebugEnabled()) {
                        log.debug("Tried, but could not instantiate type: {}", (Object)type, (Object)e);
                    }
                    return null;
                }
            }
        };
        Object result = BeanIntrospector.SHARED.findIntrospection(type).map(introspection -> {
            try {
                return introspection.instantiate();
            }
            catch (InstantiationException e) {
                return reflectionFallback.get();
            }
        }).orElseGet(reflectionFallback);
        return Optional.ofNullable(result);
    }

    @NonNull
    public static <T> Optional<T> tryInstantiate(@NonNull Constructor<T> type, Object ... args) {
        try {
            return Optional.of(type.newInstance(args));
        }
        catch (Throwable e) {
            Logger log = ClassUtils.REFLECTION_LOGGER;
            if (log.isDebugEnabled()) {
                log.debug("Tried, but could not instantiate type: {}", (Object)type, (Object)e);
            }
            return Optional.empty();
        }
    }

    public static <T> T instantiate(Class<T> type) {
        try {
            return (T)BeanIntrospector.SHARED.findIntrospection(type).map(BeanIntrospection::instantiate).orElseGet(() -> {
                try {
                    Logger log = ClassUtils.REFLECTION_LOGGER;
                    if (log.isDebugEnabled()) {
                        log.debug("Reflectively instantiating type: {}", (Object)type);
                    }
                    return type.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Throwable e) {
                    throw new InstantiationException("Could not instantiate type [" + type.getName() + "]: " + e.getMessage(), e);
                }
            });
        }
        catch (Throwable e) {
            throw new InstantiationException("Could not instantiate type [" + type.getName() + "]: " + e.getMessage(), e);
        }
    }

    public static <T> T instantiate(Class<T> type, Class<?>[] argTypes, Object ... args) {
        try {
            return (T)BeanIntrospector.SHARED.findIntrospection(type).map(bi -> bi.instantiate(args)).orElseGet(() -> InstantiationUtils.instantiateReflectively(type, argTypes, args));
        }
        catch (Throwable e) {
            throw new InstantiationException("Could not instantiate type [" + type.getName() + "]: " + e.getMessage(), e);
        }
    }

    @NonNull
    public static <T> T instantiateReflectively(Class<T> type, Class<?>[] argTypes, Object[] args) {
        try {
            Logger log = ClassUtils.REFLECTION_LOGGER;
            if (log.isDebugEnabled()) {
                log.debug("Reflectively instantiating type: {}", (Object)type);
            }
            Constructor<T> declaredConstructor = type.getDeclaredConstructor(argTypes);
            declaredConstructor.setAccessible(true);
            return declaredConstructor.newInstance(args);
        }
        catch (Throwable e) {
            throw new InstantiationException("Could not instantiate type [" + type.getName() + "]: " + e.getMessage(), e);
        }
    }

    public static Object instantiate(String type, ClassLoader classLoader) {
        try {
            return ClassUtils.forName(type, classLoader).flatMap(InstantiationUtils::tryInstantiate).orElseThrow(() -> new InstantiationException("No class found for name: " + type));
        }
        catch (Throwable e) {
            throw new InstantiationException("Could not instantiate type [" + type + "]: " + e.getMessage(), e);
        }
    }

    public static <T> T instantiate(String type, Class<T> requiredType) {
        try {
            return (T)ClassUtils.forName(type, requiredType.getClassLoader()).flatMap(aClass -> {
                if (requiredType == aClass || requiredType.isAssignableFrom((Class<?>)aClass)) {
                    return InstantiationUtils.tryInstantiate(aClass);
                }
                return Optional.empty();
            }).orElseThrow(() -> new InstantiationException("No compatible class found for name: " + type));
        }
        catch (Throwable e) {
            throw new InstantiationException("Could not instantiate type [" + type + "]: " + e.getMessage(), e);
        }
    }
}

